/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.document.function.impl;

import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.ygsoft.abc.service.document.function.WaterMarkFunction;
import com.ygsoft.abc.service.document.vo.TextWaterMarkVO;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.awt.FontMetrics;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.swing.JLabel;

public final class TextWaterMarkFunction
implements WaterMarkFunction<TextWaterMarkVO> {
    private static final IEcpLog LOG = EcpLogFactory.getLog(TextWaterMarkFunction.class);
    public static final TextWaterMarkFunction INSTANCE = new TextWaterMarkFunction();

    private TextWaterMarkFunction() {
    }

    @Override
    public void addWaterMark(PdfReader reader, PdfStamper stamper, TextWaterMarkVO waterMarkVO) {
        BaseFont font = TextWaterMarkFunction.getBaseFont(waterMarkVO.getFontPath());
        JLabel label = new JLabel();
        label.setText(waterMarkVO.getText());
        FontMetrics metrics = label.getFontMetrics(label.getFont());
        PdfGState gs = new PdfGState();
        gs.setFillOpacity(waterMarkVO.getOpacity().floatValue());
        gs.setStrokeOpacity(waterMarkVO.getOpacity().floatValue());
        Rectangle rectangle = reader.getPageSizeWithRotation(1);
        for (int i = 0; i < reader.getNumberOfPages(); ++i) {
            PdfContentByte content = stamper.getUnderContent(i + 1);
            content.beginText();
            content.setColorFill(waterMarkVO.getColor());
            content.setFontAndSize(font, (float)waterMarkVO.getFontSize());
            content.setGState(gs);
            if (waterMarkVO.isRepeat()) {
                TextWaterMarkFunction.setWaterMarkForRepeat(rectangle, metrics, content, waterMarkVO);
                continue;
            }
            TextWaterMarkFunction.setWaterMarkForNoRepeat(rectangle, metrics, content, waterMarkVO);
        }
    }

    private static void setWaterMarkForRepeat(Rectangle rectangle, FontMetrics metrics, PdfContentByte content, TextWaterMarkVO waterMarkVO) {
        BigDecimal halfUnit = new BigDecimal("2");
        int scale = 8;
        BigDecimal pageWidth = new BigDecimal(rectangle.getWidth());
        BigDecimal textWidth = new BigDecimal(metrics.stringWidth(waterMarkVO.getText())).multiply(halfUnit);
        BigDecimal repeatCountX = waterMarkVO.getRepeatCountX();
        BigDecimal xSpace = pageWidth.subtract(textWidth.multiply(repeatCountX)).divide(repeatCountX, 8, RoundingMode.HALF_UP);
        BigDecimal xMovement = BigDecimal.ZERO.subtract(textWidth.divide(halfUnit, 8, RoundingMode.HALF_UP));
        BigDecimal pageHeight = new BigDecimal(rectangle.getHeight());
        BigDecimal textHeight = new BigDecimal(metrics.getHeight()).multiply(new BigDecimal("7"));
        BigDecimal repeatCountY = waterMarkVO.getRepeatCountY();
        BigDecimal ySpace = pageHeight.subtract(textHeight.multiply(repeatCountY)).divide(repeatCountY, 8, RoundingMode.HALF_UP);
        BigDecimal yMovement = BigDecimal.ZERO.subtract(textHeight.divide(halfUnit, 8, RoundingMode.HALF_UP));
        for (int j = 0; j < repeatCountY.intValue() + 1; ++j) {
            float currentY = yMovement.floatValue() + (float)j * (textHeight.floatValue() + ySpace.floatValue());
            for (int k = 0; k < repeatCountX.intValue() + 1; ++k) {
                float currentX = xMovement.floatValue() + (float)k * (textWidth.floatValue() + xSpace.floatValue());
                content.showTextAligned(0, waterMarkVO.getText(), currentX, currentY, (float)waterMarkVO.getDegrees());
            }
        }
    }

    private static void setWaterMarkForNoRepeat(Rectangle rectangle, FontMetrics metrics, PdfContentByte content, TextWaterMarkVO waterMarkVO) {
        BigDecimal pageHeight = new BigDecimal(rectangle.getHeight());
        BigDecimal pageWidth = new BigDecimal(rectangle.getWidth());
        BigDecimal textWidth = new BigDecimal(metrics.stringWidth(waterMarkVO.getText())).multiply(new BigDecimal("2"));
        BigDecimal textHeight = new BigDecimal(metrics.getHeight()).multiply(new BigDecimal("7"));
        BigDecimal halfUnit = new BigDecimal("2");
        BigDecimal halfPageWidth = pageWidth.divide(halfUnit, RoundingMode.HALF_UP);
        BigDecimal halfImgWidth = textWidth.divide(halfUnit, RoundingMode.HALF_UP);
        float absoluteX = halfPageWidth.subtract(halfImgWidth).floatValue();
        BigDecimal halfPageHeight = pageHeight.divide(halfUnit, RoundingMode.HALF_UP);
        BigDecimal halfImgHeight = textHeight.divide(halfUnit, RoundingMode.HALF_UP);
        float absoluteY = halfPageHeight.subtract(halfImgHeight).floatValue();
        content.showTextAligned(0, waterMarkVO.getText(), absoluteX, absoluteY, (float)waterMarkVO.getDegrees());
    }

    private static BaseFont getBaseFont(String fontPath) {
        try {
            return BaseFont.createFont((String)fontPath, (String)"Identity-H", (boolean)false);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("\u521b\u5efa\u5b57\u4f53\u5931\u8d25\u3002fontPath=" + fontPath), (Throwable)e);
            }
            return null;
        }
    }
}

