/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.component;

import com.ygsoft.abc.service.annotation.AuditItemLog;
import com.ygsoft.abc.service.annotation.AuditMethod;
import com.ygsoft.abc.service.tool.AuditLogUtil;
import com.ygsoft.abc.service.tool.BeanCopyUtil;
import com.ygsoft.ecp.service.tool.UuidUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class SqlGenComponent
implements InitializingBean {
    public static final Logger LOG = LoggerFactory.getLogger(SqlGenComponent.class);

    public void afterPropertiesSet() throws Exception {
        List<Object> targetList = BeanCopyUtil.getAnnotationClass(AuditItemLog.class);
        ArrayList<String> typeIdList = new ArrayList<String>();
        ArrayList<String> itemSqlList = new ArrayList<String>();
        ArrayList<String> typeSqlList = new ArrayList<String>();
        for (Object o : targetList) {
            List<Method> methodList = BeanCopyUtil.findMethodByAnnotation(o.getClass(), AuditMethod.class);
            AuditItemLog auditLog = o.getClass().getAnnotation(AuditItemLog.class);
            String typeId = AuditLogUtil.getItemType(auditLog.auditItemType());
            if (!typeIdList.contains(typeId)) {
                typeIdList.add(typeId);
                typeSqlList.add(this.getAuditTypeSql(auditLog));
            }
            for (Method m : methodList) {
                AuditMethod auditMethod = (AuditMethod)BeanCopyUtil.findMethodAnnotation(o.getClass(), m, AuditMethod.class);
                String sqlSuccess = this.getAuditItemSql(auditLog, auditMethod, o.getClass(), m, true);
                itemSqlList.add(sqlSuccess);
                String sqlFailed = this.getAuditItemSql(auditLog, auditMethod, o.getClass(), m, false);
                itemSqlList.add(sqlFailed);
            }
        }
        if (LOG.isInfoEnabled() && CollectionUtils.isNotEmpty(typeSqlList)) {
            System.out.println("// ==============\u3010\u5ba1\u8ba1\u7c7b\u578b\u3011==============");
            typeSqlList.forEach(System.out::println);
            System.out.println();
        }
        if (LOG.isInfoEnabled() && CollectionUtils.isNotEmpty(itemSqlList)) {
            System.out.println("// ==============\u3010\u5ba1\u8ba1\u9879\u76ee\u3011==============");
            itemSqlList.forEach(System.out::println);
            System.out.println();
        }
    }

    private String getAuditTypeSql(AuditItemLog auditLog) {
        StringBuilder sb = new StringBuilder("insert into necp_umc_audit_itemtype (TYPEID, OWNERID, PTYPEID, TYPE_NAME, TYPEORDER, APPID, GID, S_LAST_TIME, S_CREATE_TIME) values('");
        sb.append(AuditLogUtil.getItemType(auditLog.auditItemType()));
        sb.append("', '");
        sb.append(auditLog.ownerId());
        sb.append("', '");
        sb.append("extend.businessManage");
        sb.append("', '");
        sb.append(auditLog.auditItemTypeName());
        sb.append("', '");
        sb.append(auditLog.auditItemTypeOrder());
        sb.append("', '");
        sb.append(auditLog.appId());
        sb.append("', '");
        sb.append(UuidUtil.newUUID());
        sb.append("', NULL, NULL);");
        return sb.toString();
    }

    private String getAuditItemSql(AuditItemLog auditLog, AuditMethod auditMethod, Class<?> clazz, Method method, boolean isSuccess) {
        String auditItemType = AuditLogUtil.getItemType(auditLog.auditItemType());
        String operateType = AuditLogUtil.getOperateType(auditMethod, method);
        String auditItemId = AuditLogUtil.getAuditItemId(clazz, method, isSuccess);
        StringBuilder sb = new StringBuilder("insert into necp_umc_audit_item (GID, OWNERID, APPID, AUDITITEMLEVEL, AUDITITEMNAME, AUDITITEMTYPE, STOPFLAG, OPERATETYPE, EVENTSTATUS, EVENTTYPE, AUDITITEMID, S_LAST_TIME, S_CREATE_TIME) values('");
        sb.append(UuidUtil.newUUID());
        sb.append("', '");
        sb.append(auditLog.ownerId());
        sb.append("', '");
        sb.append(auditLog.appId());
        sb.append("', '");
        sb.append(auditLog.auditItemLevel());
        sb.append("', '");
        sb.append(auditMethod.auditItemName());
        sb.append("', '");
        sb.append(auditItemType);
        sb.append("', '");
        sb.append(auditLog.stopFlag());
        sb.append("', '");
        sb.append(operateType);
        sb.append("', '");
        sb.append(AuditLogUtil.getEventStatus(isSuccess));
        sb.append("', '");
        sb.append(auditLog.eventType());
        sb.append("', '");
        sb.append(auditItemId);
        sb.append("', NULL, NULL);");
        return sb.toString();
    }
}

