/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.cache.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.ygsoft.abc.service.tool.CommonUtil;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class SeriesToFixedIntervalWorker {
    static final IEcpLog LOG = EcpLogFactory.getLog(SeriesToFixedIntervalWorker.class);
    private static final long DEFAULT_INTERVAL = 60000L;
    private static final Cache<String, SeriesToFixedIntervalWorker> CACHE = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).removalListener((key, value, cause) -> {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("SeriesToFixedIntervalWorker\u79fb\u9664--" + key));
        }
    }).maximumSize(1000L).build();
    private String workId = "";
    private long interval = 60000L;
    private volatile long currentTime = 0L;

    protected SeriesToFixedIntervalWorker(String workId) {
        this.workId = workId;
        this.currentTime = System.currentTimeMillis();
    }

    protected SeriesToFixedIntervalWorker(String workId, long intervalSeconds) {
        this.workId = workId;
        this.interval = intervalSeconds * 1000L;
        this.currentTime = System.currentTimeMillis();
    }

    public static SeriesToFixedIntervalWorker newInstance(String workId) {
        PreconditionUtil.checkNotTrimEmpty(workId, "\u53c2\u6570\u9519\u8bef\uff1aworkId \u4e3a\u7a7a\u3002");
        return (SeriesToFixedIntervalWorker)CACHE.get((Object)workId, id -> {
            SeriesToFixedIntervalWorker worker = new SeriesToFixedIntervalWorker(workId);
            return worker;
        });
    }

    public static SeriesToFixedIntervalWorker newInstance(String workId, long intervalSeconds) {
        PreconditionUtil.checkNotTrimEmpty(workId, "\u53c2\u6570\u9519\u8bef\uff1aworkId \u4e3a\u7a7a\u3002");
        PreconditionUtil.checkArgument(intervalSeconds > 1L, "\u53c2\u6570\u9519\u8bef\uff1aintervalSeconds\u5fc5\u987b\u5927\u4e8e1\u3002");
        return (SeriesToFixedIntervalWorker)CACHE.get((Object)workId, id -> {
            SeriesToFixedIntervalWorker worker = new SeriesToFixedIntervalWorker(workId, intervalSeconds);
            return worker;
        });
    }

    public void execute(Runnable runnable) {
        PreconditionUtil.checkNotNull(runnable, "\u53c2\u6570\u9519\u8bef\uff1arunnable\u4e3a\u7a7a\u3002");
        long now = System.currentTimeMillis();
        if (this.arriveTime(now)) {
            CompletableFuture.runAsync(runnable, CommonUtil.getThreadPoolExecutor());
            this.currentTime = now;
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)"===>\u672a\u5230\u65f6\u523b\uff0c\u65e0\u9700\u6267\u884c.");
        }
    }

    private boolean arriveTime(long now) {
        return now - this.currentTime > this.interval;
    }

    public String toString() {
        return "SeriesToFixedIntervalWorker [workId=" + this.workId + ", currentTime=" + this.currentTime + "]";
    }
}

