/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.ascpect;

import com.alibaba.fastjson.JSON;
import com.ygsoft.abc.service.annotation.TLog;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TLogAspect {
    private static final IEcpLog LOG = EcpLogFactory.getLog(TLogAspect.class);
    private static final int MAX_INFO_LENGTH = 1000;
    private final Set<Class<?>> baseClasses = new HashSet();
    private final Set<Class<?>> excludeClasses = new HashSet();

    @PostConstruct
    private void init() {
        this.baseClasses.add(Integer.class);
        this.baseClasses.add(Double.class);
        this.baseClasses.add(Float.class);
        this.baseClasses.add(Long.class);
        this.baseClasses.add(Short.class);
        this.baseClasses.add(Boolean.class);
        this.baseClasses.add(Byte.class);
        this.baseClasses.add(Character.class);
        this.baseClasses.add(String.class);
        this.excludeClasses.add(ServletResponse.class);
        this.excludeClasses.add(ServletRequest.class);
        this.excludeClasses.add(HttpSession.class);
    }

    @Pointcut(value="@annotation(com.ygsoft.abc.service.annotation.TLog)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        if (PropertyConfigUtil.isStressTest()) {
            return point.proceed();
        }
        String className = point.getTarget().getClass().getName();
        MethodSignature signature = (MethodSignature)point.getSignature();
        TLog tLog = signature.getMethod().getAnnotation(TLog.class);
        String methodName = signature.getName();
        String fullMethodName = className + "." + methodName;
        this.info("\u8fdb\u5165\u65b9\u6cd5[" + fullMethodName + "].");
        long beginTime = System.currentTimeMillis();
        Object[] args = point.getArgs();
        String[] params = signature.getParameterNames();
        this.printParams(args, params);
        if (tLog.checkArguments()) {
            this.checkEmpty(args, params);
        }
        if (!"".equals(tLog.text().trim())) {
            this.info("\u5f00\u59cb\u6267\u884c:" + tLog.text());
        }
        Object result = point.proceed();
        if (!"".equals(tLog.text().trim())) {
            this.info("\u7ed3\u675f\u6267\u884c:" + tLog.text());
        }
        long time = System.currentTimeMillis() - beginTime;
        this.info("\u65b9\u6cd5[" + fullMethodName + "]\u8017\u65f6[" + time + "ms].");
        this.info("\u65b9\u6cd5[" + fullMethodName + "]\u6267\u884c\u5b8c\u6bd5.");
        return result;
    }

    private void checkEmpty(Object[] args, String[] params) {
        for (int j = 0; j < args.length; ++j) {
            String msg = EcpI18nUtil.localizedString((String)"TLogAspect_around_130", (String)"\u53c2\u6570\u9519\u8bef\uff1a{0}\u4e3a\u7a7a\u3002", (Object[])new Object[]{params[j]});
            if (null != args[j] && (String.class != args[j].getClass() || !"".equals(String.valueOf(args[j]).trim()))) continue;
            throw new EmptyValueException("ABC.0001", msg);
        }
    }

    private void printParams(Object[] args, String[] params) {
        if (params.length < 1) {
            return;
        }
        this.info("\u65b9\u6cd5\u5165\u53c2{");
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            String value = null;
            if (null != args[i]) {
                value = args[i].toString();
                if (!this.baseClasses.contains(args[i].getClass()) && !this.checkExcluded(args[i].getClass())) {
                    try {
                        value = JSON.toJSONString((Object)args[i]);
                    }
                    catch (Exception e) {
                        value = "(\u65e0\u6cd5\u8f6c\u6362\u4e3ajson\u5b57\u7b26\u4e32)";
                    }
                }
            }
            this.info("\t" + param + ":");
            if (null == value) {
                this.info("null");
                continue;
            }
            this.shortInfo(value);
        }
        this.info("}.");
    }

    private void info(String msg) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)msg);
        }
    }

    private void shortInfo(String msg) {
        if (LOG.isInfoEnabled()) {
            if (msg.length() > 1000) {
                LOG.info((Object)(msg.substring(0, 1000) + "......"));
            } else {
                LOG.info((Object)msg);
            }
        }
    }

    private boolean checkExcluded(Class<? extends Object> clazz) {
        for (Class<? extends Object> clazz2 : this.excludeClasses) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }
}

