/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.ascpect;

import com.ygsoft.abc.service.exception.RepeatSubmitException;
import com.ygsoft.ecp.framework.token.TokenHolder;
import com.ygsoft.ecp.service.tool.RedisUtil;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class OneSubmitOnceExecuteAspect {
    private static final Logger LOG = LoggerFactory.getLogger(OneSubmitOnceExecuteAspect.class);

    @Pointcut(value="@annotation(com.ygsoft.abc.service.annotation.OneSubmitOnceExecute)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.checkSubmit(joinPoint);
    }

    private Object checkSubmit(ProceedingJoinPoint joinPoint) throws Throwable {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (attributes != null);
        HttpServletRequest request = attributes.getRequest();
        Assert.notNull((Object)request, (String)"request can not null");
        String token = TokenHolder.INSTANCE.getToken();
        String path = String.valueOf(request.getRequestURI());
        String key = token + path;
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("OneSubmitOnceExecuteAspect\u83b7\u53d6\u8bf7\u6c42key\u4e3a\uff1a%s\uff0c\u7ebf\u7a0bThread\uff1a%s", key, Thread.currentThread().getName()));
        }
        if (RedisUtil.getRedisService().get("abc", key) != null) {
            RedisUtil.getRedisService().setex("abc", key, 28800, key);
            Object result = joinPoint.proceed();
            RedisUtil.getRedisService().del("abc", key);
            return result;
        }
        throw new RepeatSubmitException("ABC.0040", "\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u3002");
    }
}

