/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.ascpect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ygsoft.abc.service.annotation.AuditField;
import com.ygsoft.abc.service.annotation.AuditMethod;
import com.ygsoft.abc.service.annotation.AuditParam;
import com.ygsoft.abc.service.audit.util.AuditEventUtil;
import com.ygsoft.abc.service.exception.CheckFailedException;
import com.ygsoft.abc.service.tool.AuditLogUtil;
import com.ygsoft.abc.service.tool.BeanCopyUtil;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AuditAspect {
    public static final Logger LOG = LoggerFactory.getLogger(AuditAspect.class);

    @Pointcut(value="@annotation(com.ygsoft.abc.service.annotation.AuditMethod)")
    public void auditMethod() {
    }

    private String getMsg(Object[] objectArray) {
        JSONObject json = (JSONObject)objectArray[1];
        String msg = (String)objectArray[0];
        if (!json.isEmpty()) {
            SerializerFeature[] serializerFeatures = new SerializerFeature[]{SerializerFeature.WriteEnumUsingName, SerializerFeature.WriteDateUseDateFormat};
            String jsonString = JSON.toJSONStringWithDateFormat((Object)json, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])serializerFeatures);
            msg = msg + "\uff0c\u53c2\u6570\uff1a" + jsonString;
        }
        return msg;
    }

    @Around(value="auditMethod()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        String msg = null;
        Class<?> clazz = joinPoint.getTarget().getClass();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Object[] objectArray = null;
        try {
            objectArray = this.doAfter(clazz, method, joinPoint.getArgs(), true);
            msg = this.getMsg(objectArray);
            if (LOG.isInfoEnabled()) {
                IEcpLog log = (IEcpLog)BeanCopyUtil.findFieldsObjectByClass(joinPoint.getTarget(), IEcpLog.class);
                if (log != null) {
                    log.info((Object)(method.getName() + "|" + msg));
                } else {
                    LOG.info(BeanCopyUtil.getClassSimpleName(clazz) + "|" + method.getName() + "|" + msg);
                }
            }
        }
        catch (Exception e) {
            LOG.error("\u5ba1\u8ba1\u65e5\u5fd7\u9519\u8bef", (Throwable)e);
        }
        Object object = joinPoint.proceed();
        msg = this.getMsg(objectArray);
        if (msg != null) {
            AuditLogUtil.save(AuditLogUtil.getAuditItemId(clazz, method, true), msg);
        }
        AuditEventUtil.remove();
        return object;
    }

    @AfterThrowing(value="auditMethod()")
    public void doAfterThrowing(JoinPoint joinPoint) {
        try {
            Class<?> clazz = joinPoint.getTarget().getClass();
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            Object[] objectArray = this.doAfter(clazz, method, joinPoint.getArgs(), false);
            String msg = this.getMsg(objectArray);
            AuditLogUtil.save(AuditLogUtil.getAuditItemId(clazz, method, false), msg);
        }
        catch (Exception e) {
            LOG.error("\u5ba1\u8ba1\u65e5\u5fd7\u9519\u8bef", (Throwable)e);
        }
    }

    private Object[] doAfter(Class<?> clazz, Method method, Object[] objects, boolean isSuccess) {
        AuditMethod auditMethod = method.getAnnotation(AuditMethod.class);
        Parameter[] parameters = method.getParameters();
        JSONObject json = new JSONObject();
        for (int i = 0; i < parameters.length; ++i) {
            AuditParam auditParam = parameters[i].getAnnotation(AuditParam.class);
            if (auditParam == null) continue;
            Map<String, Object> resMap = this.gen(auditParam, objects[i]);
            json.putAll(resMap);
        }
        AuditEventUtil.publish(json);
        AuditEventUtil.publish(json);
        Object[] objectArray = new Object[]{auditMethod.auditItemName(), json};
        return objectArray;
    }

    private Map<String, Object> gen(AuditParam auditParam, Object object) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (object == null) {
            return map;
        }
        if (auditParam.jsonClass() != Void.TYPE) {
            Object obj = JSONObject.parseObject((String)object.toString(), auditParam.jsonClass());
            return this.genFields(obj);
        }
        if (BeanCopyUtil.findFieldsByAnnotation(object.getClass(), AuditField.class).size() > 0) {
            return this.genFields(object);
        }
        if (List.class.isAssignableFrom(object.getClass()) || object.getClass().isArray()) {
            List<Object> putObject;
            List<Object> paramList = this.toList(object);
            ArrayList<Map<String, Object>> oList = new ArrayList<Map<String, Object>>();
            for (Object o : paramList) {
                Map<String, Object> extractObj = this.genFields(o);
                if (extractObj.isEmpty()) continue;
                oList.add(extractObj);
            }
            if (!oList.isEmpty()) {
                putObject = map.putIfAbsent(auditParam.value(), oList);
                this.checkRepeat(auditParam, putObject);
            } else {
                putObject = map.putIfAbsent(auditParam.value(), paramList);
                this.checkRepeat(auditParam, putObject);
            }
            return map;
        }
        Object putObject = map.putIfAbsent(auditParam.value(), AuditLogUtil.toReadableValue(auditParam, object));
        this.checkRepeat(auditParam, putObject);
        return map;
    }

    private List<Object> toList(Object object) {
        List<Object> paramList = object.getClass().isArray() ? Arrays.asList((Object[])object) : (List<Object>)object;
        return paramList;
    }

    private void checkRepeat(AuditParam auditParam, Object putObject) {
        if (putObject != null) {
            throw CheckFailedException.newInstance(auditParam.value() + ":\u4e2d\u6587\u540d\u79f0\u91cd\u590d");
        }
    }

    private Map<String, Object> genFields(Object object) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Field> fieldList = BeanCopyUtil.findFieldsByAnnotation(object.getClass(), AuditField.class);
        if (!fieldList.isEmpty()) {
            fieldList.forEach(field -> {
                AuditField annotation = field.getAnnotation(AuditField.class);
                try {
                    Object fieldObj = BeanCopyUtil.getProperty(object, field.getName());
                    if (fieldObj != null) {
                        String key = StringUtil.isEmpty((String)annotation.value()) ? field.getName() : annotation.value();
                        if (List.class.isAssignableFrom(fieldObj.getClass()) || fieldObj.getClass().isArray()) {
                            List<Object> valueList = this.toList(fieldObj);
                            if (!valueList.isEmpty()) {
                                ArrayList<Map<String, Object>> array = new ArrayList<Map<String, Object>>();
                                for (Object o : valueList) {
                                    Map<String, Object> extractObj = this.genFields(o);
                                    if (extractObj.isEmpty()) continue;
                                    array.add(extractObj);
                                }
                                if (array.isEmpty()) {
                                    map.put(key, valueList);
                                } else {
                                    map.put(key, array);
                                }
                            }
                        } else {
                            List<Field> objectFieldList = BeanCopyUtil.findFieldsByAnnotation(fieldObj.getClass(), AuditField.class);
                            if (objectFieldList.size() > 0) {
                                Map<String, Object> nestedObject = this.genFields(fieldObj);
                                if (!nestedObject.isEmpty()) {
                                    map.put(key, nestedObject);
                                }
                            } else {
                                Object putObject = map.putIfAbsent(key, AuditLogUtil.toReadableValue(annotation, object, field));
                                if (putObject != null) {
                                    throw CheckFailedException.newInstance(field.getName() + ":\u4e2d\u6587\u540d\u79f0\u91cd\u590d");
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                    throw CheckFailedException.newInstance(e.getMessage());
                }
            });
        }
        return map;
    }
}

