/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.date;

import com.ygsoft.ecp.framework.date.EcpDateException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcpDate
implements Serializable {
    private static final long serialVersionUID = -2898758069294956026L;
    private static final short[][] MONTHDAY = new short[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};
    private static final int DATEDELTA = 693594;
    private static final int SECSPERDAY = 86400;
    private static final int MSECSPERDAY = 86400000;
    public static final double SQLSTARTTIME = 25569.333333333332;
    private static final double MIN_DIFF = 5.0E-11;
    public static final long SQLSTARTMILLSECOND = Math.round(2.2091904E12);
    private int year = 1899;
    private int month = 12;
    private int day = 30;
    private int hour = 0;
    private int minute = 0;
    private int second = 0;
    private int millisecond = 0;
    private boolean fillZeroed = true;
    private char dateSeparate = (char)45;

    private void initDate(int iyear, int imonth, int iday, int ihour, int imin, int isec, int imsec) {
        this.year = iyear;
        this.month = imonth;
        this.day = iday;
        this.hour = ihour;
        this.minute = imin;
        this.second = isec;
        this.millisecond = imsec;
    }

    public EcpDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        this.initDate(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
    }

    public EcpDate(double dt) {
        this.initFromDouble(dt);
    }

    public EcpDate(int iyear, int imonth, int iday) {
        this.checkDate(iyear, imonth, iday);
        this.initDate(iyear, imonth, iday, 0, 0, 0, 0);
    }

    public EcpDate(int iyear, int imonth, int iday, int ihour) {
        this.checkDate(iyear, imonth, iday);
        this.checkTime(ihour, 0, 0, 0);
        this.initDate(iyear, imonth, iday, ihour, 0, 0, 0);
    }

    public EcpDate(int iyear, int imonth, int iday, int ihour, int imin) {
        this.checkDate(iyear, imonth, iday);
        this.checkTime(ihour, imin, 0, 0);
        this.initDate(iyear, imonth, iday, ihour, imin, 0, 0);
    }

    public EcpDate(int iyear, int imonth, int iday, int ihour, int imin, int isec) {
        this.checkDate(iyear, imonth, iday);
        this.checkTime(ihour, imin, isec, 0);
        this.initDate(iyear, imonth, iday, ihour, imin, isec, 0);
    }

    public EcpDate(int iyear, int imonth, int iday, int ihour, int imin, int isec, int imsec) {
        this.checkDate(iyear, imonth, iday);
        this.checkTime(ihour, imin, isec, imsec);
        this.initDate(iyear, imonth, iday, ihour, imin, isec, imsec);
    }

    public EcpDate(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        this.initDate(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
    }

    public void setAsDate(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        this.initDate(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
    }

    public EcpDate(Time dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        this.initDate(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
    }

    public void setAsTime(Time dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        this.initDate(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
    }

    public EcpDate(Timestamp dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        this.initDate(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
    }

    public void setAsTimestamp(Timestamp dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        this.initDate(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
    }

    public EcpDate(Calendar cl) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(cl.getTime());
        this.initDate(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
    }

    public EcpDate(String dateTimeString) {
        if (dateTimeString == null || dateTimeString.trim().length() == 0) {
            this.initFromDouble(0.0);
            return;
        }
        ArrayList<String> arlist = EcpDate.stringToArrayList(dateTimeString, " ");
        if (arlist.size() == 1) {
            ArrayList<String> ardate = EcpDate.stringToArrayList(arlist.get(0), this.dateSeparate);
            int iyear = Integer.parseInt(ardate.get(0));
            int imonth = Integer.parseInt(ardate.get(1));
            int iday = Integer.parseInt(ardate.get(2));
            this.checkDate(iyear, imonth, iday);
            this.initDate(iyear, imonth, iday, 0, 0, 0, 0);
        } else {
            ArrayList<String> ardate = EcpDate.stringToArrayList(arlist.get(0), this.dateSeparate);
            int iyear = Integer.parseInt(ardate.get(0));
            int imonth = Integer.parseInt(ardate.get(1));
            int iday = Integer.parseInt(ardate.get(2));
            ArrayList<String> artime = EcpDate.stringToArrayList(arlist.get(1), ":");
            int ihour = 0;
            int iminute = 0;
            int isecond = 0;
            int imsecond = 0;
            if (artime.size() == 3) {
                ihour = Integer.parseInt(artime.get(0));
                iminute = Integer.parseInt(artime.get(1));
                String secMsec = artime.get(2);
                int ipos = secMsec.indexOf(".");
                if (ipos >= 0) {
                    isecond = Integer.parseInt(secMsec.substring(0, ipos));
                    imsecond = Integer.parseInt(secMsec.substring(ipos + 1, secMsec.length()));
                } else {
                    isecond = Integer.parseInt(secMsec);
                }
            } else if (artime.size() == 2) {
                ihour = Integer.parseInt(artime.get(0));
                iminute = Integer.parseInt(artime.get(1));
            } else if (artime.size() == 1) {
                ihour = Integer.parseInt(artime.get(0));
            }
            this.checkDate(iyear, imonth, iday);
            this.checkTime(ihour, iminute, isecond, imsecond);
            this.initDate(iyear, imonth, iday, ihour, iminute, isecond, imsecond);
        }
    }

    private static ArrayList<String> stringToArrayList(String inStr, char sepecialChar) {
        String specialStr = String.valueOf(sepecialChar);
        ArrayList<String> result = new ArrayList<String>();
        if (inStr != null && inStr.length() > 0) {
            int lastPos = 0;
            int pos = 0;
            pos = inStr.indexOf(specialStr);
            while (pos != -1) {
                result.add(inStr.substring(lastPos, pos));
                lastPos = pos + specialStr.length();
                pos = inStr.indexOf(specialStr, lastPos);
            }
            result.add(inStr.substring(lastPos));
        }
        return result;
    }

    private static ArrayList<String> stringToArrayList(String inStr, String specialStr) {
        ArrayList<String> result = new ArrayList<String>();
        if (inStr != null && inStr.length() > 0) {
            int lastPos = 0;
            int pos = 0;
            pos = inStr.indexOf(specialStr);
            while (pos != -1) {
                result.add(inStr.substring(lastPos, pos));
                lastPos = pos + specialStr.length();
                pos = inStr.indexOf(specialStr, lastPos);
            }
            result.add(inStr.substring(lastPos));
        }
        return result;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int i) {
        this.year = i;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int i) {
        this.month = i;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int i) {
        this.day = i;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int i) {
        this.hour = i;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int i) {
        this.minute = i;
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int i) {
        this.second = i;
    }

    public int getMillisecond() {
        return this.millisecond;
    }

    public void setMillisecond(int i) {
        this.millisecond = i;
    }

    public char getDateSeparate() {
        return this.dateSeparate;
    }

    public void setDateSeparate(char c) {
        this.dateSeparate = c;
    }

    public boolean isFillZero() {
        return this.fillZeroed;
    }

    public void setFillZero(boolean b) {
        this.fillZeroed = b;
    }

    public long getSumDays() {
        long d = (long)this.getDate(this.toDouble());
        return d;
    }

    public long getOleDate() {
        return this.getSumDays();
    }

    public long getOleTime() {
        return (long)(this.getTime(this.toDouble()) * 8.64E7);
    }

    private void initFromDouble(double dt) {
        int[] date = this.internalDecodeDate(this.getDate(dt));
        int[] time = this.internalDecodeTime(this.getTime(dt));
        this.initDate(date[0], date[1], date[2], time[0], time[1], time[2], time[3]);
    }

    public static EcpDate encodeDate(int iyear, int imonth, int iday) {
        return new EcpDate(iyear, imonth, iday);
    }

    public java.sql.Date toDate() {
        return new java.sql.Date(this.toSqlLong());
    }

    public String toDateString() {
        return new StringBuffer().append(this.year).append(this.dateSeparate).append(this.fillZero(this.month)).append(this.dateSeparate).append(this.fillZero(this.day)).toString();
    }

    public Time toTime() {
        return new Time(this.toSqlLong());
    }

    private String fillZero(int value) {
        if (this.fillZeroed) {
            if (value < 10) {
                return "0" + String.valueOf(value);
            }
            return String.valueOf(value);
        }
        return String.valueOf(value);
    }

    private String fillZero(int value, int len) {
        int tmpLen = String.valueOf(value).length();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < len - tmpLen; ++i) {
            result.append("0");
        }
        return result.append(value).toString();
    }

    public String toString() {
        return this.toDateString();
    }

    public String toTimeString() {
        return new StringBuffer().append(this.fillZero(this.hour)).append(":").append(this.fillZero(this.minute)).append(":").append(this.fillZero(this.second)).append(".").append(this.fillZero(this.millisecond, 3)).toString();
    }

    public String toTimeNoMilliString() {
        return new StringBuffer().append(this.fillZero(this.hour)).append(":").append(this.fillZero(this.minute)).append(":").append(this.fillZero(this.second)).toString();
    }

    public Calendar toCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.toDate());
        return cal;
    }

    public Timestamp toTimestamp() {
        return new Timestamp(this.toSqlLong());
    }

    public String toTimestampString() {
        return new StringBuffer().append(this.year).append(this.dateSeparate).append(this.fillZero(this.month)).append(this.dateSeparate).append(this.fillZero(this.day)).append(" ").append(this.fillZero(this.hour)).append(":").append(this.fillZero(this.minute)).append(":").append(this.fillZero(this.second)).append(".").append(this.fillZero(this.millisecond, 3)).toString();
    }

    public String toTimestampNoMilliString() {
        return new StringBuffer().append(this.year).append(this.dateSeparate).append(this.fillZero(this.month)).append(this.dateSeparate).append(this.fillZero(this.day)).append(" ").append(this.fillZero(this.hour)).append(":").append(this.fillZero(this.minute)).append(":").append(this.fillZero(this.second)).toString();
    }

    public long toSqlLong() {
        return this.internalEncodeSqlLong(this.toDouble());
    }

    public long toMillisecond() {
        return this.internalEncodeMillLong(this.toDouble());
    }

    public void add(double dt) {
        double tmpdt = this.toDouble() + dt;
        int[] date = this.internalDecodeDate(this.getDate(tmpdt));
        int[] time = this.internalDecodeTime(this.getTime(tmpdt));
        this.initDate(date[0], date[1], date[2], time[0], time[1], time[2], time[3]);
    }

    public void add(EcpDate dt) {
        this.add(dt.toDouble());
    }

    public double toDouble() {
        return this.internalEncodeDateTime(this.year, this.month, this.day, this.hour, this.minute, this.second, this.millisecond);
    }

    public long toOnlyDays() {
        return (long)this.internalEncodeDateTime(this.year, this.month, this.day, 0, 0, 0, 0);
    }

    public final void addYear(int iyear) throws Exception {
        Calendar calendar = this.toCalendar();
        calendar.add(1, iyear);
        this.year = calendar.get(1);
        if (this.year < 1899 || this.year > 9999) {
            throw new RuntimeException("\u975e\u6cd5\u65e5\u671f");
        }
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
    }

    public final void addMonth(int imonth) {
        Calendar calendar = this.toCalendar();
        calendar.add(2, imonth);
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
    }

    public final void addDay(int iday) {
        Calendar calendar = this.toCalendar();
        calendar.add(5, iday);
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
    }

    public static int getMonthDays(EcpDate dt) {
        int iYear = dt.getYear();
        int iMonth = dt.getMonth();
        return MONTHDAY[EcpDate.isLeapYear(iYear) ? 1 : 0][iMonth - 1];
    }

    public static int getMonthDays(int iYear, int iMonth) {
        return MONTHDAY[EcpDate.isLeapYear(iYear) ? 1 : 0][iMonth - 1];
    }

    private double getDate(double dt) {
        String str = Double.toString(dt);
        int iIndex = str.indexOf(".");
        return Double.parseDouble(str.substring(0, iIndex));
    }

    private double getTime(double dt) {
        String str = Double.toString(dt);
        int iIndex = str.indexOf(".");
        return Double.parseDouble("0." + str.substring(iIndex + 1, str.length()));
    }

    private void checkDate(int iyear, int imonth, int iday) {
        short[] dayTable = MONTHDAY[EcpDate.isLeapYear(iyear) ? 1 : 0];
        if (iyear >= 1 && iyear <= 9999 && imonth >= 1 && imonth <= 12 && iday >= 1 && iday <= dayTable[imonth - 1]) {
            return;
        }
        EcpDateException.fire();
    }

    private void checkTime(int ihour, int imin, int isec, int imSec) {
        if (ihour < 24 && imin < 60 && isec < 60 && imSec < 1000) {
            return;
        }
        EcpDateException.fire("\u65e0\u6548\u7684\u65f6\u95f4");
    }

    private long internalEncodeSqlLong(double dt) {
        return this.internalEncodeMillLong(dt) - SQLSTARTMILLSECOND;
    }

    private long internalEncodeMillLong(double dt) {
        long ld = (long)(this.getDate(dt) * 24.0 * 3600.0 * 1000.0);
        long lt = Math.round(this.getTime(dt) * 8.64E7);
        return ld + lt;
    }

    private double internalEncodeDate(int iyear, int imonth, int iday) {
        int i = 0;
        short[] dayTable = MONTHDAY[EcpDate.isLeapYear(iyear) ? 1 : 0];
        if (iyear >= 1 && iyear <= 9999 && imonth >= 1 && imonth <= 12 && iday >= 1 && iday <= dayTable[imonth - 1]) {
            for (i = 0; i < imonth - 1; ++i) {
                iday += dayTable[i];
            }
            i = iyear - 1;
            return i * 365 + i / 4 - i / 100 + i / 400 + iday - 693594;
        }
        EcpDateException.fire();
        return 0.0;
    }

    private double internalEncodeTime(int ihour, int imin, int isec, int imSec) {
        if (ihour < 24 && imin < 60 && isec < 60 && imSec < 1000) {
            double ret = new BigDecimal(ihour * 3600000 + imin * 60000 + isec * 1000 + imSec).divide(new BigDecimal(86400000), 12, 4).doubleValue();
            return ret;
        }
        EcpDateException.fire("\u65e0\u6548\u7684\u65f6\u95f4");
        return 0.0;
    }

    private double internalEncodeDateTime(int iyear, int imonth, int iday, int ihour, int imin, int isec, int imSec) {
        double dt = this.internalEncodeDate(iyear, imonth, iday);
        double tm = this.internalEncodeTime(ihour, imin, isec, imSec);
        if (tm >= 0.0) {
            return dt + tm;
        }
        EcpDateException.fire();
        return 0.0;
    }

    private int[] internalDecodeDate(double dt) {
        int d1 = 365;
        int d4 = 1461;
        int d100 = 36524;
        int d400 = 146097;
        int y = 0;
        int m = 0;
        int d = 0;
        int i = 0;
        int year = 0;
        int month = 0;
        int day = 0;
        int dow = 0;
        int t = Double.valueOf(dt).intValue() + 693594;
        if (t <= 0) {
            int[] ret = new int[]{0, 0, 0, 0};
            return ret;
        }
        dow = t % 7;
        --t;
        y = 1;
        while (t >= 146097) {
            t -= 146097;
            y += 400;
        }
        i = t / 36524;
        d = t % 36524;
        if (i == 4) {
            --i;
            d += 36524;
        }
        y += i * 100;
        i = d / 1461;
        y += i * 4;
        i = (d %= 1461) / 365;
        d %= 365;
        if (i == 4) {
            --i;
            d += 365;
        }
        short[] dayTable = MONTHDAY[EcpDate.isLeapYear(y += i) ? 1 : 0];
        m = 1;
        while (d >= (i = dayTable[m - 1])) {
            d -= i;
            ++m;
        }
        year = y;
        month = m;
        day = d + 1;
        int[] ret = new int[]{year, month, day, dow};
        return ret;
    }

    private int[] internalDecodeTime(double tt) {
        double t = this.getTime(tt) * 8.64E7;
        int minCount = 0;
        int mSecCount = 0;
        minCount = Double.valueOf(t / 60000.0).intValue();
        mSecCount = (int)Math.round(t - (double)(minCount * 60000));
        int[] ret = new int[]{minCount / 60, minCount % 60, mSecCount / 1000, mSecCount % 1000};
        return ret;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public int compareTo(EcpDate date) {
        double f2;
        double f1 = this.toDouble();
        if (f1 < (f2 = date.toDouble())) {
            return -1;
        }
        if (Math.abs(f1 - f2) < 5.0E-11) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((EcpDate)obj) == 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public int getQuarter() {
        return (this.month - 1) / 3 + 1;
    }

    public int getDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.toTime());
        int dayOfWeek = cal.get(7) - 1;
        if (dayOfWeek < 0) {
            dayOfWeek = 0;
        }
        return dayOfWeek;
    }
}

