/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.cons;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;

public class ServerProps {
    private static volatile ServletContext servletContext = null;
    private static final String ORI_SYS_PROPS_KEY = "ygsoft.necp.orignal_Sys_Props";
    private static final String LINE = "\n\r\n";
    private static final char EQUAL = '=';
    private static final boolean ENABLE_SYSPROP = Boolean.parseBoolean(System.getProperty("necp.sysprop.enabled", "true"));

    private static String serializeAndSetProperties(Properties sysProps) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : sysProps.entrySet()) {
            if (!(entry.getKey() instanceof String) || entry.getValue() == null) continue;
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(entry.getValue());
            builder.append(LINE);
            ServerProps.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copySysPropToServProp() {
        String orignalSysProps = System.getProperty(ORI_SYS_PROPS_KEY);
        if (orignalSysProps == null || orignalSysProps.length() == 0) {
            Properties sysProps;
            Properties properties = sysProps = System.getProperties();
            synchronized (properties) {
                orignalSysProps = System.getProperty(ORI_SYS_PROPS_KEY);
                if (orignalSysProps == null || orignalSysProps.length() == 0) {
                    orignalSysProps = ServerProps.serializeAndSetProperties(sysProps);
                    System.setProperty(ORI_SYS_PROPS_KEY, orignalSysProps);
                    return;
                }
            }
        }
        try {
            int end;
            int start = 0;
            while ((end = orignalSysProps.indexOf(LINE, start)) > 0) {
                String piece = orignalSysProps.substring(start, end);
                int pos = piece.indexOf(61);
                if (pos > 0) {
                    String key = piece.substring(0, pos);
                    String value = piece.substring(pos + 1);
                    ServerProps.setProperty(key, value);
                }
                start = end + LINE.length();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setServletContext(ServletContext context) {
        if (servletContext != null) {
            throw new RuntimeException("servletContext can not be overrided!");
        }
        servletContext = context;
        if ("true".equals(System.getProperty("necp.sysprop.debug", "false"))) {
            new RuntimeException("\u663e\u793asetServletContext\u8c03\u7528\u6808").printStackTrace();
        }
        if (!ENABLE_SYSPROP) {
            ServerProps.copySysPropToServProp();
        }
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public String getContextPath() {
        return ServerProps.getProperty("server.contextpath");
    }

    public String getVipAddress() {
        return ServerProps.getProperty("server.vipaddress");
    }

    public static String getProperty(String key) {
        if (servletContext == null || ENABLE_SYSPROP) {
            return System.getProperty(key);
        }
        return (String)servletContext.getAttribute(key);
    }

    public static String getProperty(String key, String def) {
        if (servletContext == null || ENABLE_SYSPROP) {
            return System.getProperty(key, def);
        }
        String value = (String)servletContext.getAttribute(key);
        if (value == null) {
            return def;
        }
        return value;
    }

    public static String setProperty(String key, String value) {
        if (servletContext == null || ENABLE_SYSPROP) {
            return System.setProperty(key, value);
        }
        String prevValue = (String)servletContext.getAttribute(key);
        servletContext.setAttribute(key, (Object)value);
        return prevValue;
    }

    public static String[] getPropertyNames() {
        if (servletContext == null || ENABLE_SYSPROP) {
            String[] names = new String[System.getProperties().size()];
            return System.getProperties().keySet().toArray(names);
        }
        Enumeration attributes = servletContext.getAttributeNames();
        ArrayList names = new ArrayList(System.getProperties().size());
        while (attributes.hasMoreElements()) {
            names.add(attributes.nextElement());
        }
        return names.toArray(new String[names.size()]);
    }
}

