/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.sign.signContainer;

import com.ygsoft.abc.mapp.ygca.gwcw.util.IOUtil;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.SigType;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v1.SES_Header;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v4.SES_Signature;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v4.SESeal;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v4.TBS_Sign;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.ExtendSignatureContainer;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.timestamp.TimeStampHook;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Locale;
import org.bouncycastle162.asn1.ASN1BitString;
import org.bouncycastle162.asn1.ASN1GeneralizedTime;
import org.bouncycastle162.asn1.ASN1ObjectIdentifier;
import org.bouncycastle162.asn1.DERBitString;
import org.bouncycastle162.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle162.jcajce.provider.digest.SM3;
import org.bouncycastle162.jce.provider.BouncyCastleProvider;

public class SESV4Container
implements ExtendSignatureContainer {
    private final PrivateKey privateKey;
    private final SESeal seal;
    private final Certificate certificate;
    private TimeStampHook timeStampHook;

    public SESV4Container(PrivateKey privateKey, SESeal seal, Certificate signCert) {
        this.privateKey = privateKey;
        this.seal = seal;
        this.certificate = signCert;
    }

    public SESV4Container(PrivateKey privateKey, SESeal seal, Certificate signCert, TimeStampHook timeStampHook) {
        this.privateKey = privateKey;
        this.seal = seal;
        this.certificate = signCert;
        this.timeStampHook = timeStampHook;
    }

    @Override
    public MessageDigest getDigestFnc() {
        return new SM3.Digest();
    }

    @Override
    public ASN1ObjectIdentifier getSignAlgOID() {
        return GMObjectIdentifiers.sm2sign_with_sm3;
    }

    public void setTimeStampHook(TimeStampHook timeStampHook) {
        this.timeStampHook = timeStampHook;
    }

    @Override
    public byte[] sign(InputStream inData, String propertyInfo) throws IOException, GeneralSecurityException {
        byte[] timeStamp;
        MessageDigest md = this.getDigestFnc();
        byte[] dataHash = md.digest(IOUtil.toByteArray(inData));
        TBS_Sign toSign = new TBS_Sign().setVersion(SES_Header.V4).setEseal(this.seal).setTimeInfo(new ASN1GeneralizedTime(new Date(), Locale.CHINA)).setDataHash(dataHash).setPropertyInfo(propertyInfo);
        Signature sg = Signature.getInstance("SM3WithSM2", (Provider)new BouncyCastleProvider());
        sg.initSign(this.privateKey);
        sg.update(toSign.getEncoded("DER"));
        byte[] sigVal = sg.sign();
        SES_Signature signature = new SES_Signature().setToSign(toSign).setCert(this.certificate).setSignatureAlgID(GMObjectIdentifiers.sm2sign_with_sm3).setSignature(sigVal);
        if (this.timeStampHook != null && (timeStamp = this.timeStampHook.apply(sigVal)) != null) {
            signature.setTimeStamp((ASN1BitString)new DERBitString(timeStamp));
        }
        return signature.getEncoded("DER");
    }

    public void setTimestampHook(TimeStampHook timeStampHook) {
        this.timeStampHook = timeStampHook;
    }

    @Override
    public byte[] getSeal() throws IOException {
        return this.seal.getEncoded("DER");
    }

    @Override
    public SigType getSignType() {
        return SigType.Seal;
    }
}

