/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.reader;

import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FilePath;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FileUtil;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.PathUtil;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.annotation.Annotations;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.annotation.pageannot.AnnPage;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.annotation.pageannot.PageAnnot;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.attachment.Attachments;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.attachment.CT_Attachment;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.doc.CT_CommonData;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.doc.CT_PageArea;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.doc.Document;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.ofd.DocBody;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.pageObj.CT_TemplatePage;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.pageObj.Page;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.pageObj.Template;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.pageObj.layer.Type;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.pageTree.Pages;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.ST_Box;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.ST_ID;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.ST_Loc;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.Signatures;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.sig.Signature;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.parse.SESVersionHolder;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.parse.VersionParser;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.DocDir;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.OFDDir;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.BadOFDException;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.PageInfo;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.ResourceLocator;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.ResourceManage;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.ZipUtil2;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.model.AnnotionEntity;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.model.StampAnnotEntity;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.model.TemplatePageEntity;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dom4j.DocumentException;

public class OFDReader
implements Closeable {
    private FilePath workDir;
    private OFDDir ofdDir;
    protected ResourceLocator rl;
    private boolean closed = false;
    private ResourceManage resMgt;

    private OFDReader() {
    }

    public FilePath getWorkDir() {
        return this.workDir;
    }

    public static void setZipFileMaxSize(long size) {
    }

    public OFDReader(FilePath ofdFile) throws IOException {
        if (ofdFile == null || FileUtil.notExists(ofdFile)) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4f4d\u7f6e(ofdFile)\u4e0d\u6b63\u786e");
        }
        this.workDir = FileUtil.createTempDirectory("ofd-tmp-");
        ZipUtil2.unzip(ofdFile.toFile(), this.workDir.toAbsolutePath().toString() + File.separator);
        this.ofdDir = new OFDDir(this.workDir);
        this.rl = new ResourceLocator(this.ofdDir);
        this.resMgt = new ResourceManage(this);
    }

    public OFDReader(String ofdFileLoc) throws IOException {
        this(PathUtil.get(ofdFileLoc, new String[0]));
    }

    public OFDReader(InputStream stream) throws Exception {
        if (stream == null) {
            throw new IllegalArgumentException("\u6587\u4ef6\u8f93\u5165\u6d41(stream)\u4e0d\u6b63\u786e");
        }
        this.workDir = FileUtil.createTempDirectory("ofd-tmp-");
        ZipUtil2.unzip(stream, this.workDir.toAbsolutePath().toString() + File.separator);
        this.ofdDir = new OFDDir(this.workDir);
        this.rl = new ResourceLocator(this.ofdDir);
        this.resMgt = new ResourceManage(this);
    }

    public OFDReader(String unzippedPathRoot, boolean deleteOnClose) {
        this.workDir = PathUtil.get(unzippedPathRoot, new String[0]);
        if (FileUtil.notExists(this.workDir) || !FileUtil.isDirectory(this.workDir)) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4f4d\u7f6e(unzippedPathRoot)\u4e0d\u6b63\u786e");
        }
        this.ofdDir = new OFDDir(this.workDir);
        this.rl = new ResourceLocator(this.ofdDir);
        if (!deleteOnClose) {
            this.closed = true;
        }
        this.resMgt = new ResourceManage(this);
    }

    public OFDDir getOFDDir() {
        return this.ofdDir;
    }

    public ST_Loc getDefaultDocSignaturesPath() {
        try {
            this.rl.save();
            this.rl.cd("/");
            DocBody docBody = this.ofdDir.getOfd().getDocBody();
            ST_Loc loc = docBody.getSignatures();
            if (loc == null) {
                ST_Loc sT_Loc = null;
                return sT_Loc;
            }
            String signListFileAbsPath = this.rl.toAbsolutePath(loc);
            ST_Loc sT_Loc = ST_Loc.getInstance(signListFileAbsPath);
            return sT_Loc;
        }
        catch (Exception e) {
            throw new BadOFDException("\u9519\u8befOFD\u7ed3\u6784\u548c\u6587\u4ef6\u683c\u5f0f", e);
        }
        finally {
            this.rl.restore();
        }
    }

    public Signatures getDefaultSignatures() {
        ST_Loc signaturesLoc = this.getDefaultDocSignaturesPath();
        if (signaturesLoc == null || !this.rl.exist(signaturesLoc.toString())) {
            return null;
        }
        try {
            return this.rl.get(signaturesLoc, Signatures.newFunc());
        }
        catch (Exception e) {
            throw new BadOFDException("\u9519\u8befOFD\u7ed3\u6784\u548c\u6587\u4ef6\u683c\u5f0f", e);
        }
    }

    public boolean hasSignature() {
        DocBody docBody = null;
        try {
            docBody = this.ofdDir.getOfd().getDocBody();
            ST_Loc signaturesLoc = docBody.getSignatures();
            return signaturesLoc != null;
        }
        catch (Exception e) {
            throw new BadOFDException("\u9519\u8befOFD\u7ed3\u6784\u548c\u6587\u4ef6\u683c\u5f0f", e);
        }
    }

    public Annotations getAnnotations() {
        try {
            Document document = this.cdDefaultDoc();
            ST_Loc annotations = document.getAnnotations();
            if (annotations == null || !this.rl.exist(annotations.toString())) {
                Annotations annotations2 = null;
                return annotations2;
            }
            Annotations annotations3 = this.rl.get(annotations, Annotations.newFunc());
            return annotations3;
        }
        catch (Exception e) {
            throw new BadOFDException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage(), e);
        }
        finally {
            this.rl.restore();
        }
    }

    public int getNumberOfPages() {
        try {
            Document document = this.cdDefaultDoc();
            Pages pages = document.getPages();
            int n = pages.getSize();
            return n;
        }
        catch (Exception e) {
            throw new BadOFDException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage(), e);
        }
        finally {
            this.rl.restore();
        }
    }

    public PageInfo getPageInfo(int pageNum) {
        if (pageNum <= 0) {
            throw new NumberFormatException("\u9875\u7801(pageNum)\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        try {
            this.rl.save();
            int index = pageNum - 1;
            Document document = this.cdDefaultDoc();
            Pages pages = document.getPages();
            List<com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.pageTree.Page> pageList = pages.getPages();
            if (index >= pageList.size()) {
                throw new NumberFormatException(pageNum + "\u8d85\u8fc7\u6700\u5927\u9875\u7801:" + pageList.size());
            }
            ST_Loc pageLoc = pageList.get(index).getBaseLoc();
            Page obj = this.rl.get(pageLoc, Page.newFunc());
            pageLoc = this.rl.getAbsTo(pageLoc);
            ST_Box pageSize = this.getPageSize(obj);
            ArrayList<TemplatePageEntity> templatePages = new ArrayList<TemplatePageEntity>();
            for (Template item : obj.getTemplates()) {
                TemplatePageEntity template = this.getTemplate(item.getTemplateID().toString());
                Type type = Type.getInstance(item.attributeValue("ZOrder"));
                template.setOrder(type);
                templatePages.add(template);
            }
            int n = index;
            String pageNName = new ST_Loc(pageLoc.parent()).getFileName().toLowerCase();
            if (pageNName.matches("page_\\d+")) {
                try {
                    n = Integer.parseInt(pageNName.replace("page_", ""));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            PageInfo pageInfo = new PageInfo().setIndex(pageNum).setId(pageList.get(index).getID()).setObj(obj).setSize(pageSize.clone()).setPageAbsLoc(pageLoc).setTemplates(templatePages).setPageN(n);
            return pageInfo;
        }
        catch (Exception e) {
            throw new RuntimeException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage(), e);
        }
        finally {
            this.rl.restore();
        }
    }

    public List<PageInfo> getPageList() {
        int numberOfPages = this.getNumberOfPages();
        ArrayList<PageInfo> res = new ArrayList<PageInfo>(numberOfPages);
        for (int i = 0; i < numberOfPages; ++i) {
            PageInfo pageInfo = this.getPageInfo(i + 1);
            res.add(pageInfo);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplatePageEntity getTemplate(String id) {
        if (id == null || id.trim().length() == 0) {
            return null;
        }
        try {
            Document document = this.cdDefaultDoc();
            CT_CommonData commonData = document.getCommonData();
            TemplatePageEntity res = null;
            for (CT_TemplatePage item : commonData.getTemplatePages()) {
                String itemId = item.getID().toString();
                if (!id.equals(itemId)) continue;
                ST_Loc loc = item.getBaseLoc();
                if (loc == null) break;
                Page page = this.rl.get(loc, Page.newFunc());
                res = new TemplatePageEntity(item, page);
                break;
            }
            Iterator<CT_TemplatePage> iterator = res;
            return iterator;
        }
        catch (Exception e) {
            TemplatePageEntity templatePageEntity = null;
            return templatePageEntity;
        }
        finally {
            this.rl.restore();
        }
    }

    public Document cdDoc(int numOfDoc) throws DocumentException, FileNotFoundException {
        this.rl.save();
        this.rl.cd("/");
        DocBody docBody = this.ofdDir.getOfd().getDocBody(numOfDoc);
        ST_Loc docRoot = docBody.getDocRoot();
        Document document = this.rl.get(docRoot, Document.newFunc());
        this.rl.cd(docRoot.parent());
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDoc(int numOfDoc) throws DocumentException, FileNotFoundException {
        this.rl.save();
        try {
            this.rl.cd("/");
            DocBody docBody = this.ofdDir.getOfd().getDocBody(numOfDoc);
            ST_Loc docRoot = docBody.getDocRoot();
            Document document = this.rl.get(docRoot, Document.newFunc());
            return document;
        }
        finally {
            this.rl.restore();
        }
    }

    public Document cdDefaultDoc() throws DocumentException, FileNotFoundException {
        return this.cdDoc(0);
    }

    public ST_Box getPageSize(Page page) {
        if (page == null) {
            return null;
        }
        CT_PageArea pageArea = page.getArea();
        if (pageArea == null || pageArea.getBox() == null) {
            CT_PageArea tplArea = null;
            int biggestOrder = -1;
            for (Template item : page.getTemplates()) {
                TemplatePageEntity template = this.getTemplate(item.getTemplateID().toString());
                if (template == null || template.getPage() == null) continue;
                CT_PageArea area = template.getPage().getArea();
                int order = template.getZOrder().order();
                if (area == null || order <= biggestOrder || area.getBox() == null) continue;
                tplArea = area;
                biggestOrder = order;
            }
            pageArea = tplArea;
            if (pageArea == null) {
                Document document;
                try {
                    document = this.ofdDir.obtainDocDefault().getDocument();
                }
                catch (Exception e) {
                    throw new BadOFDException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage(), e);
                }
                CT_CommonData commonData = document.getCommonData();
                pageArea = commonData.getPageArea();
            }
        }
        if (pageArea == null) {
            return null;
        }
        return pageArea.getBox();
    }

    public Page getPage(int pageNum) {
        if (pageNum <= 0) {
            throw new NumberFormatException("\u9875\u7801(pageNum)\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        try {
            this.rl.save();
            int index = pageNum - 1;
            Document document = this.cdDefaultDoc();
            Pages pages = document.getPages();
            List<com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.pageTree.Page> pageList = pages.getPages();
            if (index >= pageList.size()) {
                throw new NumberFormatException(pageNum + "\u8d85\u8fc7\u6700\u5927\u9875\u7801:" + pageList.size());
            }
            ST_Loc pageLoc = pageList.get(index).getBaseLoc();
            Page page = this.rl.get(pageLoc, Page.newFunc());
            return page;
        }
        catch (Exception e) {
            throw new RuntimeException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage(), e);
        }
        finally {
            this.rl.restore();
        }
    }

    public ST_ID getPageObjectId(int pageNum) {
        return this.getPageInfo(pageNum).getId();
    }

    public ResourceLocator getResourceLocator() {
        return this.rl;
    }

    public CT_Attachment getAttachment(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        this.rl.save();
        try {
            CT_Attachment cT_Attachment = this.getAttachment(name, this.rl);
            return cT_Attachment;
        }
        finally {
            this.rl.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilePath getAttachmentFile(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        this.rl.save();
        try {
            CT_Attachment attachment = this.getAttachment(name, this.rl);
            if (attachment == null) {
                FilePath filePath = null;
                return filePath;
            }
            ST_Loc fileLoc = attachment.getFileLoc();
            try {
                FilePath filePath = this.rl.getFile(fileLoc);
                return filePath;
            }
            catch (FileNotFoundException e) {
                System.err.println(">> \u65e0\u6cd5\u6839\u636e\u9644\u4ef6\u5bf9\u8c61\u7684\u63cf\u8ff0\u83b7\u53d6\u5230\u9644\u4ef6: " + fileLoc.toString());
                FilePath filePath = null;
                this.rl.restore();
                return filePath;
            }
        }
        finally {
            this.rl.restore();
        }
    }

    private CT_Attachment getAttachment(String name, ResourceLocator rl) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        DocDir docDir = this.ofdDir.obtainDocDefault();
        rl.cd(docDir);
        Document document = null;
        Attachments attachments = null;
        try {
            document = docDir.getDocument();
        }
        catch (Exception e) {
            throw new BadOFDException(e);
        }
        ST_Loc attachmentsLoc = document.getAttachments();
        if (attachmentsLoc == null || !rl.exist(attachmentsLoc.toString())) {
            return null;
        }
        try {
            attachments = rl.get(attachmentsLoc, Attachments.newFunc());
        }
        catch (Exception e) {
            System.err.println(">> \u65e0\u6cd5\u83b7\u53d6\u6216\u89e3\u6790Attachments.xml: " + e.getMessage());
            return null;
        }
        String parent = attachmentsLoc.parent();
        if (parent != null) {
            rl.cd(parent);
        }
        for (CT_Attachment attachment : attachments.getAttachments()) {
            if (!attachment.getAttachmentName().equals(name)) continue;
            return attachment;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StampAnnotEntity> getStampAnnots() {
        if (!this.hasSignature()) {
            return Collections.emptyList();
        }
        try {
            this.rl.save();
            Signatures sigFileList = this.getDefaultSignatures();
            if (sigFileList == null) {
                List<StampAnnotEntity> list = Collections.emptyList();
                return list;
            }
            ST_Loc signaturesLoc = this.getDefaultDocSignaturesPath();
            this.rl.cd(signaturesLoc.parent());
            List<com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.Signature> sigInfoList = sigFileList.getSignatures();
            ArrayList<StampAnnotEntity> res = new ArrayList<StampAnnotEntity>(sigInfoList.size());
            for (com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.Signature sigInfoItem : sigInfoList) {
                ST_Loc signatureBaseLoc = sigInfoItem.getBaseLoc();
                this.rl.save();
                try {
                    Signature sigDesp = this.rl.get(signatureBaseLoc, Signature.newFunc());
                    try {
                        this.rl.cd(signatureBaseLoc.parent());
                        ST_Loc signedValueLoc = sigDesp.getSignedValue();
                        this.rl.cd(signedValueLoc.parent());
                        FilePath signedValueFile = this.rl.getFile(signedValueLoc);
                        SESVersionHolder v = VersionParser.parseSES_SignatureVersion(FileUtil.readAllBytes(signedValueFile));
                        res.add(new StampAnnotEntity(v, sigDesp.getSignedInfo()));
                    }
                    finally {
                        this.rl.restore();
                    }
                }
                catch (Exception exception) {}
            }
            ArrayList<StampAnnotEntity> arrayList = res;
            return arrayList;
        }
        finally {
            this.rl.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AnnotionEntity> getAnnotationEntities() {
        ArrayList<AnnotionEntity> arrayList;
        Document document = this.cdDefaultDoc();
        ST_Loc annInfosLoc = document.getAnnotations();
        if (annInfosLoc == null || !this.rl.exist(annInfosLoc.toString())) {
            return Collections.emptyList();
        }
        Annotations annotations = this.rl.get(annInfosLoc, Annotations.newFunc());
        if (annotations == null) {
            return Collections.emptyList();
        }
        this.rl.cd(annInfosLoc.parent());
        try {
            List<AnnPage> annPages = annotations.getPages();
            ArrayList<AnnotionEntity> res = new ArrayList<AnnotionEntity>(annPages.size());
            for (AnnPage annPage : annPages) {
                try {
                    ST_Loc fileLoc = annPage.getFileLoc();
                    PageAnnot pageAnnot = this.rl.get(fileLoc, PageAnnot.newFunc());
                    res.add(new AnnotionEntity(annPage.getPageID().toString(), pageAnnot.getAnnots()));
                }
                catch (Exception exception) {}
            }
            arrayList = res;
            this.rl.restore();
        }
        catch (Throwable throwable) {
            try {
                this.rl.restore();
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage(), e);
            }
        }
        return arrayList;
    }

    public ResourceManage getResMgt() {
        return this.resMgt;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.workDir != null && FileUtil.exists(this.workDir)) {
            try {
                FileUtil.deleteDirectory(this.workDir.toFile());
            }
            catch (Exception e) {
                throw new IOException("\u65e0\u6cd5\u5220\u9664Reader\u7684\u5de5\u4f5c\u7a7a\u95f4");
            }
        }
    }
}

