/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container;

import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FilePath;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FileUtil;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.Holder;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.pageObj.Page;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.ST_Loc;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.VirtualContainer;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.regex.Pattern;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class TempsDir
extends VirtualContainer {
    public static final String TempFilePrefix = "Temp_";
    public static final Pattern TempFileNameRegex = Pattern.compile("Temp_(\\d+).xml");
    private int maxTempIndex = -1;

    public TempsDir(FilePath fullDir) throws IllegalArgumentException {
        super(fullDir);
    }

    public TempsDir add(FilePath res) throws IOException {
        if (FileUtil.notExists(res)) {
            return this;
        }
        this.putFile(res);
        return this;
    }

    public ST_Loc add(String fileName, Page page) {
        this.putObj(fileName, page);
        return this.getAbsLoc().cat(fileName);
    }

    public ST_Loc add(Page page) throws IOException {
        if (page == null) {
            return null;
        }
        this.maxTempIndex = this.getMaxTempIndex() + 1;
        String fileName = String.format("%s%d.xml", TempFilePrefix, this.maxTempIndex);
        return this.add(fileName, page);
    }

    public Page get(String fileName) throws DocumentException, FileNotFoundException {
        Element element = this.getObj(fileName);
        return new Page(element);
    }

    public Integer getMaxTempIndex() throws IOException {
        if (this.maxTempIndex < 0) {
            Holder<Integer> maxIndexHolder = new Holder<Integer>(-1);
            FilePath filePath = this.getContainerPath();
            File path2 = new File(filePath.getPath());
            File[] fileArray = path2.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().startsWith(TempsDir.TempFilePrefix.toLowerCase());
                }
            });
            if (fileArray.length > 0) {
                for (File file : fileArray) {
                    String numStr = file.getName().replace(TempFilePrefix.toLowerCase(), "").split("\\.")[0];
                    try {
                        int n = Integer.parseInt(numStr);
                        if (n <= (Integer)maxIndexHolder.value) continue;
                        maxIndexHolder.value = n;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            this.maxTempIndex = (Integer)maxIndexHolder.value;
        }
        return this.maxTempIndex;
    }
}

