/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container;

import com.ygsoft.abc.mapp.ygca.jdk.function.Function;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FilePath;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.annotation.Annotations;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.doc.Document;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.res.Res;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.AnnotsDir;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.PagesDir;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.ResDir;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.SignsDir;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.TempsDir;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.VirtualContainer;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class DocDir
extends VirtualContainer {
    public static final String DocContainerPrefix = "Doc_";
    public static final String DocumentFileName = "Document.xml";
    public static final String PublicResFileName = "PublicRes.xml";
    public static final String DocumentResFileName = "DocumentRes.xml";
    public static final String SignsDir = "Signs";
    public static final String SignContainerPrefix = "Sign_";
    public static final String TagsDir = "Tags";
    public static final String TempsDir = "Temps";
    public static final String PagesDir = "Pages";
    public static final String PageContainerPrefix = "Page_";
    public static final String ResDir = "Res";
    public static final String AnnotsDir = "Annots";
    public static final String AnnotationsFileName = "Annotations.xml";
    public static final String Attachments = "Attachments.xml";
    private int index = 0;

    public DocDir(FilePath fullDir) throws IllegalArgumentException {
        super(fullDir);
        String indexStr = this.getContainerName().replace(DocContainerPrefix, "");
        try {
            this.index = Integer.parseInt(indexStr);
        }
        catch (NumberFormatException e) {
            this.clean();
            throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u6587\u4ef6\u76ee\u5f55\u540d\u79f0\uff1a" + this.getContainerName() + "\uff0c\u76ee\u5f55\u540d\u79f0\u5e94\u4e3a Doc_N");
        }
    }

    public static Function<FilePath, DocDir> newFunc() {
        Function<FilePath, DocDir> creater = new Function<FilePath, DocDir>(){

            @Override
            public DocDir apply(FilePath path) {
                return new DocDir(path);
            }
        };
        return creater;
    }

    public Integer getIndex() {
        return this.index;
    }

    public Document getDocument() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(DocumentFileName);
        return new Document(obj);
    }

    public DocDir setDocument(Document document) {
        this.putObj(DocumentFileName, document);
        return this;
    }

    public Res getPublicRes() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(PublicResFileName);
        return new Res(obj);
    }

    public DocDir setPublicRes(Res publicRes) {
        this.putObj(PublicResFileName, publicRes);
        return this;
    }

    public Res getDocumentRes() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(DocumentResFileName);
        return new Res(obj);
    }

    public Annotations getAnnotations() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(AnnotationsFileName);
        return new Annotations(obj);
    }

    public DocDir setAnnotations(Annotations annotations) {
        this.putObj(AnnotationsFileName, annotations);
        return this;
    }

    public DocDir setDocumentRes(Res documentRes) {
        this.putObj(DocumentResFileName, documentRes);
        return this;
    }

    public ResDir getRes() throws FileNotFoundException {
        Function<FilePath, ResDir> creater = new Function<FilePath, ResDir>(){

            @Override
            public ResDir apply(FilePath path) {
                return new ResDir(path);
            }
        };
        return this.getContainer(ResDir, creater);
    }

    public ResDir obtainRes() {
        Function<FilePath, ResDir> creater = new Function<FilePath, ResDir>(){

            @Override
            public ResDir apply(FilePath path) {
                return new ResDir(path);
            }
        };
        return this.obtainContainer(ResDir, creater);
    }

    public SignsDir getSigns() throws FileNotFoundException {
        Function<FilePath, SignsDir> creater = new Function<FilePath, SignsDir>(){

            @Override
            public SignsDir apply(FilePath path) {
                return new SignsDir(path);
            }
        };
        return this.getContainer(SignsDir, creater);
    }

    public SignsDir obtainSigns() {
        Function<FilePath, SignsDir> creater = new Function<FilePath, SignsDir>(){

            @Override
            public SignsDir apply(FilePath path) {
                return new SignsDir(path);
            }
        };
        return this.obtainContainer(SignsDir, creater);
    }

    public PagesDir getPages() throws FileNotFoundException {
        Function<FilePath, PagesDir> creater = new Function<FilePath, PagesDir>(){

            @Override
            public PagesDir apply(FilePath path) {
                return new PagesDir(path);
            }
        };
        return this.getContainer(PagesDir, creater);
    }

    public PagesDir obtainPages() {
        Function<FilePath, PagesDir> creater = new Function<FilePath, PagesDir>(){

            @Override
            public PagesDir apply(FilePath path) {
                return new PagesDir(path);
            }
        };
        return this.obtainContainer(PagesDir, creater);
    }

    public VirtualContainer obtainTags() {
        Function<FilePath, VirtualContainer> creater = new Function<FilePath, VirtualContainer>(){

            @Override
            public VirtualContainer apply(FilePath path) {
                return new VirtualContainer(path);
            }
        };
        return this.obtainContainer(TagsDir, creater);
    }

    public VirtualContainer getTags() throws FileNotFoundException {
        Function<FilePath, VirtualContainer> creater = new Function<FilePath, VirtualContainer>(){

            @Override
            public VirtualContainer apply(FilePath path) {
                return new VirtualContainer(path);
            }
        };
        return this.getContainer(TagsDir, creater);
    }

    public TempsDir obtainTemps() {
        Function<FilePath, TempsDir> creater = new Function<FilePath, TempsDir>(){

            @Override
            public TempsDir apply(FilePath path) {
                return new TempsDir(path);
            }
        };
        return this.obtainContainer(TempsDir, creater);
    }

    public TempsDir getTemps() throws FileNotFoundException {
        Function<FilePath, TempsDir> creater = new Function<FilePath, TempsDir>(){

            @Override
            public TempsDir apply(FilePath path) {
                return new TempsDir(path);
            }
        };
        return this.getContainer(TempsDir, creater);
    }

    public AnnotsDir obtainAnnots() {
        Function<FilePath, AnnotsDir> creater = new Function<FilePath, AnnotsDir>(){

            @Override
            public AnnotsDir apply(FilePath path) {
                return new AnnotsDir(path);
            }
        };
        return this.obtainContainer(AnnotsDir, creater);
    }

    public AnnotsDir getAnnots() throws FileNotFoundException {
        Function<FilePath, AnnotsDir> creater = new Function<FilePath, AnnotsDir>(){

            @Override
            public AnnotsDir apply(FilePath path) {
                return new AnnotsDir(path);
            }
        };
        return this.getContainer(AnnotsDir, creater);
    }

    public DocDir addResource(FilePath resource) throws IOException {
        this.obtainRes().add(resource);
        return this;
    }

    public FilePath getResource(String name) throws FileNotFoundException {
        return this.obtainRes().get(name);
    }
}

