/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.builder;

import com.ygsoft.abc.mapp.ygca.ofdrw.gm.cert.CertTools;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.ContentInfo;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.IssuerAndSerialNumber;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.OIDs;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.SignedData;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.SignerInfo;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.builder.CertSigHolder;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle162.asn1.ASN1Encodable;
import org.bouncycastle162.asn1.ASN1OctetString;
import org.bouncycastle162.asn1.ASN1Set;
import org.bouncycastle162.asn1.DEROctetString;
import org.bouncycastle162.asn1.DERSet;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;

public final class SignedDataBuilder {
    public static SignedData signedData(byte[] plaintext, byte[] signature, Certificate certificate) throws GeneralSecurityException, IOException {
        if (plaintext == null || plaintext.length == 0) {
            throw new IllegalArgumentException("\u7b7e\u540d\u539f\u6587(plaintext)\u4e3a\u7a7a");
        }
        if (signature == null || signature.length == 0) {
            throw new IllegalArgumentException("\u7b7e\u540d\u503c(signature)\u4e3a\u7a7a");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("\u8bc1\u4e66(certificate)\u4e3a\u7a7a");
        }
        ArrayList<CertSigHolder> certSigArr = new ArrayList<CertSigHolder>(1);
        certSigArr.add(new CertSigHolder(signature, certificate));
        return SignedDataBuilder.signedData(plaintext, certSigArr, null);
    }

    public static SignedData signedData(byte[] plaintext, List<CertSigHolder> certSigArr, List<Certificate> extCertArr) throws GeneralSecurityException, IOException {
        if (plaintext == null || plaintext.length == 0) {
            throw new IllegalArgumentException("\u7b7e\u540d\u539f\u6587(plaintext)\u4e3a\u7a7a");
        }
        if (certSigArr == null || certSigArr.isEmpty()) {
            throw new IllegalArgumentException("\u8bc1\u4e66\u3001\u7b7e\u540d\u503c\u5217\u8868(signature)\u4e3a\u7a7a");
        }
        DERSet digestAlgorithms = new DERSet((ASN1Encodable)new AlgorithmIdentifier(OIDs.sm3));
        ContentInfo contentInfo = new ContentInfo(OIDs.data, (ASN1Encodable)new DEROctetString(plaintext));
        int len = certSigArr.size();
        int i = 0;
        if (extCertArr != null) {
            len += extCertArr.size();
        }
        ASN1Encodable[] certArr = new ASN1Encodable[len];
        for (CertSigHolder holder : certSigArr) {
            certArr[i] = holder.getAsn1Cert();
            ++i;
        }
        if (extCertArr != null && !extCertArr.isEmpty()) {
            for (Certificate c : extCertArr) {
                certArr[i] = CertTools.asn1(c);
                ++i;
            }
        }
        DERSet certificates = new DERSet(certArr);
        ASN1Encodable[] signers = new ASN1Encodable[certSigArr.size()];
        for (int j = 0; j < certSigArr.size(); ++j) {
            CertSigHolder item = certSigArr.get(j);
            signers[j] = SignedDataBuilder.sm2Signer(item.signature, item.getAsn1Cert());
        }
        DERSet signerInfos = new DERSet(signers);
        return new SignedData((ASN1Set)digestAlgorithms, contentInfo, (ASN1Set)certificates, (ASN1Set)signerInfos);
    }

    public static SignerInfo sm2Signer(byte[] signature, org.bouncycastle162.asn1.x509.Certificate certificate) {
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(certificate.getIssuer(), certificate.getSerialNumber());
        return new SignerInfo(issuerAndSerialNumber, new AlgorithmIdentifier(OIDs.sm3), new AlgorithmIdentifier(OIDs.sm2Sign), (ASN1OctetString)new DEROctetString(signature));
    }
}

