/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.validator;

import com.ygsoft.abc.mapp.ygca.exception.VerifyRuntimeException;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.VerifyResult;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v4.SES_Signature;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v4.TBS_Sign;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify.exceptions.InvalidSignedValueException;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify.exceptions.OFDVerifyException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Date;
import org.bouncycastle162.asn1.ASN1GeneralizedTime;
import org.bouncycastle162.jcajce.provider.asymmetric.x509.CertificateFactory;
import org.bouncycastle162.jcajce.provider.digest.SM3;
import org.bouncycastle162.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfdSealValidate {
    private static final Logger LOG = LoggerFactory.getLogger(OfdSealValidate.class);

    public static VerifyResult validate(String alg, byte[] tbsContent, byte[] signedValue) {
        VerifyResult result = new VerifyResult();
        try {
            SM3.Digest md = new SM3.Digest();
            byte[] actualDataHash = md.digest(tbsContent);
            SES_Signature sesSignature = SES_Signature.getInstance(signedValue);
            TBS_Sign toSign = sesSignature.getToSign();
            byte[] expectDataHash = toSign.getDataHash().getBytes();
            if (!Arrays.equals(actualDataHash, expectDataHash)) {
                throw new InvalidSignedValueException("Signature.xml \u6587\u4ef6\u88ab\u7be1\u6539\uff0c\u7535\u5b50\u7b7e\u7ae0\u5931\u6548\u3002(" + toSign.getPropertyInfo().getString() + ")");
            }
            Signature sg = Signature.getInstance(sesSignature.getSignatureAlgID().getId(), (Provider)new BouncyCastleProvider());
            byte[] certDER = sesSignature.getCert().getOctets();
            Certificate signCert = new CertificateFactory().engineGenerateCertificate((InputStream)new ByteArrayInputStream(certDER));
            sg.initVerify(signCert);
            sg.update(toSign.getEncoded("DER"));
            byte[] expSigVal = sesSignature.getSignature().getBytes();
            if (!sg.verify(expSigVal)) {
                throw new InvalidSignedValueException("\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u7b7e\u540d\u503c\u4e0d\u5339\u914d\uff0c\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u5931\u6548\u3002");
            }
            result.setSignTime(OfdSealValidate.parseSignTime(toSign));
            result.setCert(signCert);
            result.setVerifyResult(true);
            return result;
        }
        catch (Exception e) {
            if (e instanceof OFDVerifyException) {
                throw new VerifyRuntimeException(e.getMessage(), e);
            }
            throw new VerifyRuntimeException("\u9a8c\u7b7e\u5931\u8d25", e);
        }
    }

    private static Date parseSignTime(TBS_Sign toSign) {
        if (null == toSign) {
            return null;
        }
        try {
            byte[] timeInfo = toSign.getTimeInfo().getEncoded();
            return ASN1GeneralizedTime.getInstance((Object)timeInfo).getDate();
        }
        catch (Exception e) {
            System.err.println("\u83b7\u53d6\u7b7e\u540d\u65f6\u95f4\u5931\u8d25\uff1a" + e.getMessage());
            return null;
        }
    }
}

