/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Decompression {
    private static final Logger LOG = LoggerFactory.getLogger(Decompression.class);
    private static final int BUFFER = 512;
    private static final int TOO_BIG = 0x6400000;
    private static final int TOO_MANY = 1024;

    private Decompression() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipUncompress(String inputFile, String destDirPath) {
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        ZipFile zipFile = null;
        try {
            File srcFile = new File(inputFile);
            if (!srcFile.exists()) {
                throw new IOException(srcFile.getPath());
            }
            zipFile = new ZipFile(srcFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            int total = 0;
            int entriesNumber = 0;
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = entries.nextElement();
                Decompression.checkFileName(entry.getName(), destDirPath);
                int count = 0;
                if (entry.isDirectory()) {
                    if (srcFile.mkdir()) continue;
                    throw new IOException();
                }
                String fileName = entry.getName();
                File targetFile = new File(destDirPath + File.separator + fileName);
                if (!targetFile.getParentFile().exists() && targetFile.getParentFile().mkdirs()) {
                    throw new IOException();
                }
                if (!targetFile.createNewFile()) {
                    throw new IOException();
                }
                inputStream = zipFile.getInputStream(entry);
                fileOutputStream = new FileOutputStream(targetFile);
                byte[] buf = new byte[512];
                while ((len = inputStream.read(buf)) != -1) {
                    if ((total += count) > 0x6400000) {
                        LOG.warn("Zip file is too big.");
                        break;
                    }
                    fileOutputStream.write(buf, 0, len);
                }
                ++entriesNumber;
                if (total > 0x6400000) {
                    LOG.warn("Zip file is too big.");
                    break;
                }
                if (entriesNumber <= 1024) continue;
                LOG.warn("Zip file is too many.");
                break;
            }
            Decompression.closeProcess(inputFile, fileOutputStream, inputStream, zipFile);
        }
        catch (IOException e) {
            LOG.warn("IOException error.");
        }
        finally {
            Decompression.closeProcess(inputFile, fileOutputStream, inputStream, zipFile);
        }
    }

    private static String checkFileName(String entryName, String intendedDir) throws IOException {
        File intendedFile;
        String canonicalPath2;
        File file = new File(intendedDir, entryName);
        String canonicalPath1 = file.getCanonicalPath();
        if (canonicalPath1.startsWith(canonicalPath2 = (intendedFile = new File(intendedDir)).getCanonicalPath())) {
            return canonicalPath1;
        }
        throw new IllegalStateException();
    }

    private static void closeProcess(String inputFile, FileOutputStream fileOutputStream, InputStream inputStream, ZipFile zipFile) {
        try {
            if (zipFile != null) {
                zipFile.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (inputFile != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            LOG.error("Close error.");
        }
    }

    public static void main(String[] args) {
    }
}

