/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.impl.service;

import com.ygsoft.abc.mapp.ygca.gwcw.common.types.YesnoEnum;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.FileVerifyCommandVO;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.VerifyResultVO;
import com.ygsoft.abc.mapp.ygca.gwcw.impl.service.http.RemoteClient;
import com.ygsoft.abc.mapp.ygca.gwcw.impl.service.http.RemoteHttpClient;
import com.ygsoft.abc.mapp.ygca.gwcw.impl.service.http.RemoteRegisterClient;
import com.ygsoft.abc.mapp.ygca.gwcw.service.IBizSignatureService;
import com.ygsoft.abc.mapp.ygca.gwcw.util.IOUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.util.StringUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.util.VerifyResultParseUtils;
import java.io.File;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xjyb.com.alibaba.fastjson.JSONObject;

public class HttpSignatureService
implements IBizSignatureService {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSignatureService.class);
    public static final RemoteClient httpRemoteClient = new RemoteHttpClient();
    public static final RemoteClient mappRemoteClient = new RemoteRegisterClient();
    private final String serverUrl;
    private final RemoteClient remoteClient;

    public HttpSignatureService(String newServerUrl, RemoteClient remoteClient) {
        this.serverUrl = newServerUrl;
        this.remoteClient = remoteClient;
    }

    @Override
    public VerifyResultVO verify(String fileBase64, String fileType, Map<String, String> optionalParam) {
        if (StringUtil.isBlank(fileBase64)) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff1afileBase64\u4e3a\u7a7a\u3002");
        }
        FileVerifyCommandVO commandVO = new FileVerifyCommandVO();
        commandVO.setFileData(fileBase64);
        commandVO.setFileType(fileType);
        commandVO.setOptionalParam(optionalParam);
        LOG.info(String.format("\u9a8c\u7b7e\u8bf7\u6c42 type: %s, url:%s, fileDataLength: %d, fileDataType: %s, optionalParam: %s", this.remoteClient.getClass().getSimpleName(), this.getServerUrl(), commandVO.getFileData().length(), commandVO.getFileType(), JSONObject.toJSONString(commandVO.getOptionalParam())));
        String respText = null;
        try {
            respText = this.remoteClient.verifyAll(this.getServerUrl(), commandVO);
        }
        catch (Exception e) {
            LOG.error("\u8bf7\u6c42\u8fdc\u7a0b\u9a8c\u7b7e\u670d\u52a1\u5931\u8d25", (Throwable)e);
            return new VerifyResultVO(YesnoEnum.NSP, "\u8bf7\u6c42\u8fdc\u7a0b\u9a8c\u7b7e\u670d\u52a1\u5931\u8d25", null);
        }
        VerifyResultVO stdResp = VerifyResultParseUtils.parseObject2(respText);
        LOG.info("\u9a8c\u7b7e\u7ed3\u679c:" + stdResp.toString());
        return stdResp;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    @Override
    public VerifyResultVO verify(byte[] fileData, String fileType, Map<String, String> optionalParam) {
        if (null == fileData) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff1afileData\u4e3a\u7a7a\u3002");
        }
        String zipBase64 = new String(Base64.encodeBase64((byte[])fileData));
        return this.verify(zipBase64, fileType, optionalParam);
    }

    @Override
    public VerifyResultVO verify(File file, String fileType, Map<String, String> optionalParam) {
        if (null == file) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff1afile\u4e3a\u7a7a\u3002");
        }
        if (!file.exists()) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff1afile\u4e0d\u5b58\u5728\u3002");
        }
        byte[] zipData = IOUtil.readFile(file.getAbsolutePath());
        return this.verify(zipData, fileType, optionalParam);
    }

    @Override
    public VerifyResultVO verify(String fileBase64, String fileType) {
        return this.verify(fileBase64, fileType, null);
    }

    @Override
    public VerifyResultVO verify(byte[] fileData, String fileType) {
        return this.verify(fileData, fileType, null);
    }

    @Override
    public VerifyResultVO verify(File file, String fileType) {
        return this.verify(file, fileType, null);
    }
}

