/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.crypto;

import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.math.ec.ECPoint;
import com.ygsoft.abc.mapp.ygca.algorithm.common.ASN1SM2Signature;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2DSASigner;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2Result;
import com.ygsoft.abc.mapp.ygca.algorithm.util.BigIntegerKit;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;

public class BCSoftSM2 {
    public static final byte[] sign(byte[] hash, BigInteger userD) {
        return BCSoftSM2.sign(hash, userD, false);
    }

    public static final byte[] sign(byte[] hash, BigInteger userD, boolean asn1Flag) {
        BigInteger[] signature = BCSoftSM2.generateSignature(hash, userD);
        byte[] signValue = null;
        if (asn1Flag) {
            try {
                ASN1SM2Signature asn1SignResult = new ASN1SM2Signature(signature[0], signature[1]);
                signValue = asn1SignResult.getEncoded("DER");
            }
            catch (IOException var6) {
                throw new RuntimeException("signed failure", var6);
            }
        } else {
            signValue = new byte[64];
            System.arraycopy(BigIntegerKit.asUnsignedByteArray(32, signature[0]), 0, signValue, 0, 32);
            System.arraycopy(BigIntegerKit.asUnsignedByteArray(32, signature[1]), 0, signValue, 32, 32);
        }
        return signValue;
    }

    public void sign(byte[] hash, BigInteger userD, SM2Result sm2Ret) {
        if (sm2Ret == null) {
            throw new SecurityException("null not allowed for sm2Ret");
        }
        try {
            BigInteger[] signature = BCSoftSM2.generateSignature(hash, userD);
            sm2Ret.r = signature[0];
            sm2Ret.s = signature[1];
        }
        catch (RuntimeException var5) {
            throw new SecurityException(var5.getMessage());
        }
    }

    private static BigInteger[] generateSignature(byte[] hash, BigInteger userD) {
        if (hash != null && hash.length == 32) {
            if (userD == null) {
                throw new SecurityException("null not allowed for userD");
            }
            try {
                SM2DSASigner engine = new SM2DSASigner();
                engine.initSign(userD, new SecureRandom());
                return engine.generateSignature(hash);
            }
            catch (Exception var3) {
                throw new RuntimeException("signed failure", var3);
            }
        }
        throw new SecurityException("null/length not allowed for hash");
    }

    public static final boolean verify(byte[] hash, byte[] signature, ECPoint userKey) {
        if (userKey == null) {
            throw new SecurityException("null not allowed for userKey");
        }
        if (hash != null && hash.length == 32) {
            if (signature == null) {
                return false;
            }
            BigInteger r = null;
            BigInteger s = null;
            if (signature.length == 64) {
                r = BigIntegerKit.fromUnsignedByteArray(signature, 0, 32);
                s = BigIntegerKit.fromUnsignedByteArray(signature, 32, 32);
            } else {
                if (signature.length <= 64) {
                    return false;
                }
                try {
                    ASN1Sequence sequence = ASN1Sequence.getInstance((Object)signature);
                    ASN1Integer R = (ASN1Integer)sequence.getObjectAt(0);
                    ASN1Integer S = (ASN1Integer)sequence.getObjectAt(1);
                    r = R.getPositiveValue();
                    s = S.getPositiveValue();
                }
                catch (Exception var8) {
                    return false;
                }
            }
            return BCSoftSM2.verify(hash, userKey, r, s);
        }
        return false;
    }

    public boolean verify(byte[] hash, ECPoint userKey, SM2Result sm2Ret) {
        boolean passed = false;
        passed = sm2Ret == null ? false : BCSoftSM2.verify(hash, userKey, sm2Ret.r, sm2Ret.s);
        return passed;
    }

    private static final boolean verify(byte[] hash, ECPoint userKey, BigInteger r, BigInteger s) {
        boolean passed = false;
        if (hash != null && hash.length == 32 && userKey != null && r != null && s != null) {
            SM2DSASigner engine = new SM2DSASigner();
            engine.initVerify(userKey);
            passed = engine.verifySignature(hash, r, s);
        } else {
            passed = false;
        }
        return passed;
    }
}

