/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.algorithm.util;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.x500.X500Name;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.asn1.x509.Certificate;
import cn.org.bjca.gaia.asn1.x509.SubjectKeyIdentifier;
import cn.org.bjca.gaia.asn1.x509.SubjectPublicKeyInfo;
import cn.org.bjca.gaia.util.Strings;
import com.ygsoft.abc.mapp.ygca.algorithm.common.Mechanism;
import com.ygsoft.abc.mapp.ygca.algorithm.common.Mechanisms;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2PublicKey;
import com.ygsoft.abc.mapp.ygca.algorithm.util.GMTObjectIdentifiers;
import com.ygsoft.abc.mapp.ygca.algorithm.util.GMTPKCSObjectIdentifiers;
import com.ygsoft.abc.mapp.ygca.algorithm.util.GMTX9ObjectIdentifiers;
import com.ygsoft.abc.mapp.ygca.asn1.parser.ASN1Parser;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Arrays;
import org.bouncycastle162.asn1.cms.IssuerAndSerialNumber;

public class X509CertKit {
    public static final String DIGITS = "0123456789ABCDEF";
    private static final byte[] headBytes = Strings.toByteArray((String)"-----BEGIN CERTIFICATE-----");
    private static int headLength = headBytes.length;
    private static byte[] endBytes = Strings.toByteArray((String)"-----END CERTIFICATE-----");
    private static int endLength = endBytes.length;
    public static final int CERT_TYPE_SM2CERT = 1;
    public static final int CERT_TYPE_RSACERT = 2;
    public static final int CERT_TYPE_ECCCERT = 3;
    private final Certificate cert;
    private final int certType;
    private byte[] derEncoding;
    private PublicKey publicKey;
    private SubjectKeyIdentifier recipientKeyIdentifier = null;
    private IssuerAndSerialNumber recipientIssuerAndSerialNumber = null;

    public X509CertKit(byte[] certData) {
        this(X509CertKit.certFrom(certData), 0);
    }

    public final int getCertType() {
        return this.certType;
    }

    public final boolean isSM2Cert() {
        return this.certType == 1;
    }

    public final boolean isRSACert() {
        return this.certType == 2;
    }

    public final boolean isECCCert() {
        return this.certType == 3;
    }

    public X500Name getIssuerX500Name() {
        return this.cert.getIssuer();
    }

    public final BigInteger getSerialNumber() {
        return this.cert.getSerialNumber().getPositiveValue();
    }

    public X509CertKit(Certificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException("null not allowed for parameters@certificate");
        }
        this.cert = certificate;
        this.certType = X509CertKit.buildCertType(this.cert);
    }

    X509CertKit(Certificate certificate, int certType) {
        if (certificate == null) {
            throw new RuntimeException("null not allowed for parameters@certificate");
        }
        this.cert = certificate;
        this.certType = X509CertKit.buildCertType(this.cert);
    }

    public PublicKey getPublicKey() {
        if (this.publicKey == null) {
            PublicKey publicKey;
            this.publicKey = publicKey = X509CertKit.buildPublicKey(this.cert);
        }
        return this.publicKey;
    }

    private static final PublicKey buildPublicKey(Certificate cert) {
        int certType = X509CertKit.buildCertType(cert);
        SM2PublicKey publicKey = null;
        switch (certType) {
            case 1: {
                try {
                    SubjectPublicKeyInfo subjectPublicKeyInfo = cert.getSubjectPublicKeyInfo();
                    byte[] pubData = subjectPublicKeyInfo.getPublicKeyData().getBytes();
                    if (pubData == null || pubData.length != 64 && pubData.length != 65) {
                        throw new RuntimeException("\u516c\u94a5\u683c\u5f0f\u9519\u8bef\u3002");
                    }
                    int starter = pubData.length == 65 ? 1 : 0;
                    byte[] pubX = new byte[32];
                    byte[] pubY = new byte[32];
                    System.arraycopy(pubData, starter, pubX, 0, 32);
                    System.arraycopy(pubData, starter + 32, pubY, 0, 32);
                    publicKey = new SM2PublicKey(pubX, pubY);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("\u516c\u94a5\u683c\u5f0f\u9519\u8bef\u3002", e);
                }
            }
            default: {
                throw new RuntimeException("\u516c\u94a5\u683c\u5f0f\u9519\u8bef\u3002");
            }
        }
        return publicKey;
    }

    private static Certificate certFrom(byte[] certData) {
        Certificate cert = null;
        try {
            byte[] certBytes = X509CertKit.filterPEMText(certData);
            ASN1Sequence seq = ASN1Parser.getDERSequenceFrom(certBytes);
            cert = Certificate.getInstance((Object)seq);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (cert == null) {
            throw new RuntimeException("\u8bc1\u4e66\u6570\u636e\u4e3a\u7a7a\u3002");
        }
        return cert;
    }

    private static byte[] filterPEMText(byte[] certData) {
        byte[] certHead = new byte[headLength];
        byte[] certEnd = new byte[endLength];
        System.arraycopy(certData, 0, certHead, 0, headLength);
        boolean hasHead = Arrays.equals(certHead, headBytes);
        if (hasHead) {
            certData = ASN1Parser.deleteCRLF(certData);
        }
        int certDataLength = certData.length;
        System.arraycopy(certData, certDataLength - endLength, certEnd, 0, endLength);
        boolean hasEnd = Arrays.equals(certEnd, endBytes);
        int datStarter = 0;
        int datLength = 0;
        byte[] certBytes = null;
        if (hasHead && hasEnd) {
            datStarter = headLength;
            datLength = certDataLength - headLength - endLength;
        } else if (!hasHead && hasEnd) {
            datStarter = 0;
            datLength = certDataLength - endLength;
        } else if (hasHead && !hasEnd) {
            datStarter = headLength;
            datLength = certDataLength - headLength;
        } else {
            certBytes = certData;
        }
        if (certBytes == null) {
            certBytes = new byte[datLength];
            System.arraycopy(certData, datStarter, certBytes, 0, certBytes.length);
        }
        return certBytes;
    }

    private static int buildCertType(Certificate cert) {
        int certType = 0;
        if (cert != null) {
            SubjectPublicKeyInfo subjectPublicKeyInfo = cert.getSubjectPublicKeyInfo();
            AlgorithmIdentifier algorithm = subjectPublicKeyInfo.getAlgorithm();
            String keyTypeAlgorithmId = algorithm.getAlgorithm().getId();
            if (keyTypeAlgorithmId.equals(GMTPKCSObjectIdentifiers.rsaEncryption.getId())) {
                certType = 2;
            } else if (keyTypeAlgorithmId.equals(GMTObjectIdentifiers.ecPubKey.getId())) {
                boolean issm2 = X509CertKit.isSM2SigAlg(cert);
                if (issm2) {
                    ASN1Encodable parameters = algorithm.getParameters();
                    if (parameters != null && parameters instanceof ASN1ObjectIdentifier) {
                        ASN1ObjectIdentifier param = (ASN1ObjectIdentifier)parameters;
                        if (param.equals((Object)GMTObjectIdentifiers.sm2_old)) {
                            certType = 1;
                        } else if (param.equals((Object)GMTObjectIdentifiers.sm2PubKey)) {
                            certType = 1;
                        }
                    }
                    if (certType != 1) {
                        String signAlgorithmId = cert.getSignatureAlgorithm().getAlgorithm().getId();
                        if (signAlgorithmId.equals(GMTX9ObjectIdentifiers.sm3WithSM2Encryption.getId())) {
                            certType = 1;
                        } else if (signAlgorithmId.equals(GMTX9ObjectIdentifiers.sm3WithSM2Encryption_OLD.getId())) {
                            certType = 1;
                        }
                    }
                } else {
                    ASN1Encodable parameters = algorithm.getParameters();
                    certType = 3;
                }
            }
        }
        return certType;
    }

    private static boolean isSM2SigAlg(Certificate cert) {
        String sigAlg = Mechanism.getSignatureAlgName(cert.getSignatureAlgorithm());
        return Mechanisms.isSM2WithSM3(sigAlg);
    }
}

