/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.algorithm.util;

import com.ygsoft.abc.mapp.ygca.algorithm.common.PKCS7SignedData;
import com.ygsoft.abc.mapp.ygca.algorithm.util.X509CertKit;

public class SignatureKit {
    static final int sourceFileLoadLimitedLength = 10240;
    private X509CertKit signCert = null;
    private String digestAlgorithm = null;
    private byte[] signature = null;
    private byte[] sourceData = null;
    private PKCS7SignedData pkcs7SignedData;

    public boolean p7VerifyMessageDetach(byte[] sourceData, byte[] base64P7SignedData) {
        boolean isFailed = false;
        try {
            PKCS7SignedData pkcs7SignedData = this.GetPKCS7From(base64P7SignedData);
            this.GetDataFrom(pkcs7SignedData, false);
            boolean verifyResult = pkcs7SignedData.verifyP7SignedData(sourceData);
            if (!verifyResult) {
                isFailed = true;
            }
            return verifyResult;
        }
        catch (Exception e) {
            isFailed = true;
            throw new RuntimeException("\u9a8c\u7b7e\u5931\u8d25\u3002", e);
        }
    }

    private PKCS7SignedData GetPKCS7From(byte[] p7SignedData) {
        boolean isFailed = false;
        try {
            PKCS7SignedData pkcs7SignedData = new PKCS7SignedData();
            pkcs7SignedData.loadBase64(p7SignedData);
            this.pkcs7SignedData = pkcs7SignedData;
            return pkcs7SignedData;
        }
        catch (Exception e) {
            isFailed = true;
            throw new RuntimeException(e);
        }
    }

    private void GetDataFrom(PKCS7SignedData pkcs7SignedData, boolean readSourceFlag) {
        this.signCert = pkcs7SignedData.getSignerX509Cert();
        System.out.println(">>>signCert=" + this.signCert);
        this.digestAlgorithm = pkcs7SignedData.getDigestAlgorithm();
        System.out.println(">>>digestAlgorithm=" + this.digestAlgorithm);
        this.signature = pkcs7SignedData.getSignature();
        System.out.println(">>>signature=" + this.signature);
        if (readSourceFlag) {
            this.sourceData = pkcs7SignedData.getSourceData();
            System.out.println(">>>sourceData=" + this.sourceData);
        }
    }

    public X509CertKit getSignerCert() {
        return this.signCert;
    }

    public PKCS7SignedData getPKCS7SignedData() {
        return this.pkcs7SignedData;
    }
}

