/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.algorithm.common;

import cn.org.bjca.gaia.crypto.params.ECPrivateKeyParameters;
import cn.org.bjca.gaia.crypto.params.ECPublicKeyParameters;
import com.ygsoft.abc.mapp.ygca.algorithm.common.GMTPrivateKey;
import com.ygsoft.abc.mapp.ygca.algorithm.common.GMTPublicKey;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2Key;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2PublicKey;
import java.math.BigInteger;

public class SM2PrivateKey
extends GMTPrivateKey
implements SM2Key {
    private static final long serialVersionUID = -1463950776387286774L;
    private SM2PublicKey sm2PubKey;

    public static SM2PrivateKey getInstance(byte[] encoded) {
        return new SM2PrivateKey(encoded);
    }

    public SM2PrivateKey(ECPrivateKeyParameters ecPrivateKeyParameters, ECPublicKeyParameters ecPublicKeyParameters) {
        super(ecPrivateKeyParameters, ecPublicKeyParameters);
        this.resetSM2PublicKey();
    }

    public SM2PrivateKey(ECPrivateKeyParameters ecPrivateKeyParameters) {
        super(ecPrivateKeyParameters);
        this.resetSM2PublicKey();
    }

    public SM2PrivateKey(byte[] dBytes, byte[] bPubX, byte[] bPubY) {
        super(dBytes, bPubX, bPubY);
        this.resetSM2PublicKey();
    }

    public SM2PrivateKey(byte[] encoding) {
        super(encoding);
        this.resetSM2PublicKey();
    }

    public SM2PrivateKey(BigInteger d, BigInteger iPubX, BigInteger iPubY) {
        super(d, iPubX, iPubY);
        this.resetSM2PublicKey();
    }

    private final void resetSM2PublicKey() {
        GMTPublicKey pubKey = super.getSM2PublicKey();
        this.sm2PubKey = new SM2PublicKey(pubKey.getPubX_Int(), pubKey.getPubY_Int());
    }

    @Override
    public SM2PublicKey getSM2PublicKey() {
        return this.sm2PubKey;
    }
}

