/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.algorithm.common;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.ASN1OctetString;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.ASN1Set;
import cn.org.bjca.gaia.asn1.cms.Attribute;
import cn.org.bjca.gaia.asn1.cms.AttributeTable;
import cn.org.bjca.gaia.asn1.cms.CMSAttributes;
import cn.org.bjca.gaia.asn1.cms.Time;
import cn.org.bjca.gaia.asn1.pkcs.ContentInfo;
import cn.org.bjca.gaia.asn1.pkcs.IssuerAndSerialNumber;
import cn.org.bjca.gaia.asn1.pkcs.SignedData;
import cn.org.bjca.gaia.asn1.pkcs.SignerInfo;
import cn.org.bjca.gaia.asn1.x500.X500Name;
import cn.org.bjca.gaia.asn1.x509.Certificate;
import com.ygsoft.abc.mapp.ygca.algorithm.common.Mechanisms;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2SignerInfo;
import com.ygsoft.abc.mapp.ygca.algorithm.util.Base64;
import com.ygsoft.abc.mapp.ygca.algorithm.util.BigIntegerKit;
import com.ygsoft.abc.mapp.ygca.algorithm.util.PKCSObjectIdentifiers;
import com.ygsoft.abc.mapp.ygca.algorithm.util.X509CertKit;
import com.ygsoft.abc.mapp.ygca.asn1.parser.ASN1Parser;
import com.ygsoft.abc.mapp.ygca.crypto.BCSoftLib;
import java.math.BigInteger;
import java.security.PublicKey;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;

public class PKCS7SignedData {
    private SignedData signedData = null;

    public void loadDERData(byte[] data) {
        ASN1Sequence seq;
        if (data != null && data.length != 0) {
            if (!ASN1Parser.isDERSequence(data)) {
                throw new RuntimeException("PKCS7SignedData encoding required DERSequence");
            }
            try {
                seq = ASN1Sequence.getInstance((Object)data);
            }
            catch (Exception var4) {
                throw new RuntimeException("PKCS7SignedData decoding failure", var4);
            }
        } else {
            throw new RuntimeException("PKCS7SignedData encoding required not  be null");
        }
        this.load(seq);
    }

    public void loadBase64(byte[] data) {
        ASN1Sequence seq;
        if (data != null && data.length != 0) {
            byte[] encoding = null;
            if (ASN1Parser.isDERSequence(data)) {
                encoding = data;
            } else {
                try {
                    encoding = Base64.decode(data);
                }
                catch (Exception var6) {
                    throw new RuntimeException("PKCS7SignedData encoding required base64", var6);
                }
            }
            try {
                seq = ASN1Sequence.getInstance((Object)encoding);
            }
            catch (Exception var5) {
                throw new RuntimeException("PKCS7SignedData decoding failure", var5);
            }
        }
        throw new RuntimeException("PKCS7SignedData encoding required not  be null");
        this.load(seq);
    }

    private final void load(ASN1Sequence seq) {
        SignedData sd = null;
        try {
            ContentInfo contentInfo = ContentInfo.getInstance((Object)seq);
            sd = SignedData.getInstance((Object)contentInfo.getContent());
        }
        catch (Exception var4) {
            throw new RuntimeException("PKCS7SignedData decoding failure", var4);
        }
        this.signedData = sd;
    }

    public SignedData getSignedData() {
        return this.signedData;
    }

    public byte[] getSourceData() {
        ContentInfo contentInfo = this.signedData.getContentInfo();
        byte[] sourceData = null;
        if (!(contentInfo.getContentType().equals((Object)PKCSObjectIdentifiers.data) || contentInfo.getContentType().equals((Object)PKCSObjectIdentifiers.id_ct_TSTInfo) || contentInfo.getContentType().equals((Object)PKCSObjectIdentifiers.sm2Data))) {
            sourceData = ASN1Parser.parseDERObj2Bytes((ASN1Encodable)contentInfo.getContent().toASN1Primitive());
        } else {
            if (contentInfo.getContent() == null) {
                throw new RuntimeException("no sourceData to be verify.");
            }
            sourceData = ((ASN1OctetString)contentInfo.getContent()).getOctets();
        }
        return (byte[])sourceData.clone();
    }

    private boolean verifySM2SignerInfo(byte[] content, boolean ifZValue, byte[] userId, ASN1Set signerInfos, X509CertKit[] certs) {
        System.out.println("content:" + Base64.toBase64String(content));
        try {
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            boolean verifyResult = false;
            if (signerEnumer.hasMoreElements()) {
                SM2SignerInfo signerInfo = SM2SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509CertKit signerCert = this.getSM2SignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new RuntimeException("\u7b7e\u540d\u8bc1\u4e66\u4e0d\u5b58\u5728\u3002");
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] r = BigIntegerKit.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
                byte[] s = BigIntegerKit.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
                byte[] signature = new byte[64];
                System.arraycopy(r, 0, signature, 0, 32);
                System.arraycopy(s, 0, signature, 32, 32);
                System.out.println("signature:" + Base64.toBase64String(signature));
                ASN1Set authAttributes = signerInfo.getAuthenticatedAttributes();
                if (authAttributes != null) {
                    System.out.println("\u5e26\u5c5e\u6027\u7684\u9a8c\u7b7e....");
                    byte[] bAuthAttries = ASN1Parser.parseDERObj2Bytes((ASN1Encodable)authAttributes);
                    verifyResult = new BCSoftLib().verify(Mechanisms.M_SM3_SM2, pubKey, bAuthAttries, signature);
                } else {
                    System.out.println("\u5185\u5bb9\u9a8c\u7b7e....");
                    verifyResult = new BCSoftLib().verify(Mechanisms.M_SM3_SM2, pubKey, content, signature);
                }
            }
            return verifyResult;
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u6790\u7b7e\u540d\u6570\u636e\u9519\u8bef\u3002", e);
        }
    }

    private boolean isSM2Cert() {
        ASN1Set certSet = this.signedData.getCertificates();
        Certificate certStru = Certificate.getInstance((Object)certSet.getObjectAt(0));
        return new X509CertKit(certStru).isSM2Cert();
    }

    private X509CertKit[] getSignerCerts() {
        ASN1Set certSet = this.signedData.getCertificates();
        X509CertKit[] signerCerts = new X509CertKit[certSet.size()];
        for (int i = 0; i < certSet.size(); ++i) {
            Certificate certStru = Certificate.getInstance((Object)certSet.getObjectAt(i));
            signerCerts[i] = new X509CertKit(certStru);
        }
        return signerCerts;
    }

    public X509CertKit getSignerX509Cert() {
        X509CertKit signerCerts = null;
        ASN1Set certSet = this.signedData.getCertificates();
        Certificate certStru = Certificate.getInstance((Object)certSet.getObjectAt(0));
        signerCerts = new X509CertKit(certStru);
        return signerCerts;
    }

    public Certificate getSignerCert() {
        ASN1Set certSet = this.signedData.getCertificates();
        Certificate certStru = Certificate.getInstance((Object)certSet.getObjectAt(0));
        return certStru;
    }

    private X509CertKit getSM2SignerCert(X509CertKit[] certs, IssuerAndSerialNumber issuerAndSN) {
        String issuer = issuerAndSN.getName().toString();
        BigInteger sn = issuerAndSN.getCertificateSerialNumber().getValue();
        for (int i = 0; i < certs.length; ++i) {
            X500Name tmpIssuer = certs[i].getIssuerX500Name();
            BigInteger tmpSN = certs[i].getSerialNumber();
            if (!tmpIssuer.toString().equals(issuer) || tmpSN.compareTo(sn) != 0) continue;
            return certs[i];
        }
        return null;
    }

    public boolean verifyP7SignedData(byte[] sourceData) {
        ASN1Set aset = this.signedData.getSignerInfos();
        if (this.isSM2Cert()) {
            return this.verifySM2SignerInfo(sourceData, true, null, aset, null);
        }
        throw new RuntimeException("\u4e0d\u652f\u6301RSA\u7b97\u6cd5\u7684\u8bc1\u4e66\u3002");
    }

    private byte[] getSM2Signature() {
        ASN1Set signerInfos = this.signedData.getSignerInfos();
        Enumeration signerEnumer = signerInfos.getObjects();
        if (signerEnumer.hasMoreElements()) {
            SM2SignerInfo signerInfo = SM2SignerInfo.getInstance(signerEnumer.nextElement());
            byte[] r = BigIntegerKit.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
            byte[] s = BigIntegerKit.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
            byte[] signature = new byte[64];
            System.arraycopy(r, 0, signature, 0, 32);
            System.arraycopy(s, 0, signature, 32, 32);
            return signature;
        }
        throw new RuntimeException("can not get SM2SignerInfo object!!!");
    }

    public byte[] getSignature() {
        if (this.isSM2Cert()) {
            return this.getSM2Signature();
        }
        ASN1Set signerInfos = this.signedData.getSignerInfos();
        Enumeration signerEnumer = signerInfos.getObjects();
        if (signerEnumer.hasMoreElements()) {
            SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
            return signerInfo.getEncryptedDigest().getOctets();
        }
        throw new RuntimeException("can not get SignerInfo object!!!");
    }

    public String getDigestAlgorithm() {
        if (this.isSM2Cert()) {
            return "SM3";
        }
        ASN1Set signerInfos = this.signedData.getSignerInfos();
        Enumeration signerEnumer = signerInfos.getObjects();
        String signM = null;
        if (signerEnumer.hasMoreElements()) {
            SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
            ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
            signM = Mechanisms.getDigestAlgorithmName(digestId);
            if (signM == null) {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u3002");
            }
            return signM;
        }
        throw new RuntimeException("can not get SignerInfo object!!!");
    }

    public final String getSignTime() {
        ASN1Set signerInfos;
        String signTimeText = null;
        if (this.signedData != null && (signerInfos = this.signedData.getSignerInfos()) != null) {
            AttributeTable attributeTable;
            Attribute signTimeAttr;
            boolean hasSignTimeAttr;
            Enumeration signerEnumer = signerInfos.getObjects();
            if (!signerEnumer.hasMoreElements()) {
                throw new RuntimeException("getSignTime failed: can not get SignerInfo");
            }
            SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
            ASN1Set signedAttributeSet = signerInfo.getAuthenticatedAttributes();
            if (signedAttributeSet != null && (hasSignTimeAttr = this.hasSignTime(signTimeAttr = (attributeTable = new AttributeTable(signedAttributeSet)).get(CMSAttributes.signingTime)))) {
                Time time = Time.getInstance((Object)signTimeAttr.getAttrValues().getObjectAt(0).toASN1Primitive());
                Date signTimeDate = time.getDate();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                signTimeText = format.format(signTimeDate);
            }
        }
        return signTimeText;
    }

    private final boolean hasSignTime(Attribute signTimeAttr) {
        boolean hasSignTime = false;
        if (signTimeAttr != null) {
            hasSignTime = signTimeAttr.getAttrValues() != null && signTimeAttr.getAttrValues().size() > 0;
        }
        return hasSignTime;
    }
}

