/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.xml;

import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.config.AppServerType;
import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.internal.crypto.BASE64Decoder;
import com.ygsoft.ecp.service.internal.crypto.BASE64Encoder;
import com.ygsoft.ecp.service.internal.xml.StringList;
import com.ygsoft.ecp.service.internal.xml.XmlParse;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.XmlUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XmlDoc {
    private static IEcpLog log = EcpLogFactory.getLog(XmlDoc.class);
    private static final String XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
    private static final String ROOT_TAG_PARAM = "<{0}></{0}>";
    private String xmlParseImplClass = "com.ygsoft.ecp.service.internal.xml.XmlParseImpl";
    public static final char XPATHSEP = '/';
    public static final String CONDITIONPREFIX = "[";
    public static final String ATTRPREFIX = "@";
    private static final String REROOTPATH = "//";
    private String namespaceUri;
    private Node rootNode;
    protected Document xmlDoc;
    private String rootTag = "xmldata";
    private boolean indenting = false;
    private String encoding = EcpService.getConfigService().getApplicationConfig().getCharset().name();
    private boolean cacheNode = false;
    private boolean xpathUsedCondition = false;
    private boolean onlyQueryInCache = false;
    private XmlCache xmlCache = new XmlCache(this);
    private String rootTagPrefix;
    private boolean preserveSpace = true;

    public XmlCache getXmlCache() {
        return this.xmlCache;
    }

    public void loadFromXml(InputSource is) {
        try {
            this.xmlDoc = this.parserDocument(is);
            this.initRootNode();
        }
        catch (Exception e) {
            throw new EcpRuntimeException("service.100003", e);
        }
    }

    public void loadFromXml(InputStream istream) {
        try {
            this.xmlDoc = this.parserDocument(istream);
            this.initRootNode();
        }
        catch (Exception e) {
            throw new EcpRuntimeException("service.100003", e);
        }
    }

    public void setDocument(Document doc) {
        this.xmlDoc = doc;
        this.initRootNode();
    }

    public XmlDoc() {
        this.reset();
    }

    public XmlDoc(boolean notLoadDefault) {
        if (!notLoadDefault) {
            this.reset();
        }
    }

    public XmlDoc(String rootTag) {
        if (rootTag != null && rootTag.startsWith("<")) {
            this.loadFromXml(rootTag);
        } else {
            this.rootTag = rootTag;
            this.reset();
        }
    }

    public XmlDoc(String rootTag, String namespaceUri) {
        this.namespaceUri = namespaceUri;
        if (rootTag != null && rootTag.startsWith("<")) {
            this.loadFromXml(rootTag);
        } else {
            this.rootTag = rootTag;
            this.reset();
        }
    }

    public XmlDoc(Document document) {
        this.xmlDoc = document;
        this.initRootNode();
    }

    public void reset() {
        String str = XML + MessageFormat.format(ROOT_TAG_PARAM, this.rootTag);
        InputSource is = new InputSource(new StringReader(str));
        this.loadFromXml(is);
    }

    public void loadFromXml(String strXml) {
        InputSource is = new InputSource(new StringReader(strXml));
        this.loadFromXml(is);
    }

    public void loadFromBase64Xml(String encodeXml) throws Exception {
        BASE64Decoder decoder = new BASE64Decoder();
        String xml = new String(decoder.decodeBuffer(encodeXml), "UTF-8");
        this.loadFromXml(xml);
    }

    public void loadFromFile(String strFileName) throws Exception {
        XmlParse parser = (XmlParse)Class.forName(this.xmlParseImplClass).newInstance();
        this.xmlDoc = parser.parse(new File(strFileName));
        this.initRootNode();
    }

    public Node createNode(String nodeName) {
        if (XmlUtil.isAttrPath(nodeName)) {
            return this.createAttribute(nodeName.substring(1));
        }
        Element node = this.xmlDoc.createElement(nodeName);
        this.xmlDoc.getDocumentElement().appendChild(node);
        return node;
    }

    public Node createAttribute(String attrName) {
        Attr attr = this.xmlDoc.createAttribute(attrName);
        return attr;
    }

    public String getXml() {
        return this.exportXml(this.xmlDoc.getDocumentElement());
    }

    public String getXml(Node node) {
        if (XmlUtil.isTextNode(node)) {
            return node.getNodeValue();
        }
        return XmlUtil.deleteXmlHeader(this.exportXml(node));
    }

    private String exportXml(Node node) {
        if (XmlUtil.isAttributeNode(node)) {
            String name = node.getNodeName();
            return new StringBuffer("<").append(name).append(">").append(node.getNodeValue()).append("</").append(name).append(">").toString();
        }
        if (XmlUtil.isTextNode(node)) {
            return node.getNodeValue();
        }
        StringBuffer buffer = new StringBuffer();
        OutputFormat format = new OutputFormat(this.xmlDoc);
        format.setEncoding(this.encoding);
        format.setIndenting(this.indenting);
        format.setPreserveSpace(this.preserveSpace);
        StringWriter stringOut = new StringWriter();
        XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
        try {
            serial.asDOMSerializer();
            serial.serialize((Element)node);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u5e8f\u5217\u5316XML\u5931\u8d25", e);
            }
            throw new EcpRuntimeException("service.XmlUtil_SERIALIZE_FAIL", EcpI18nUtil.localizedString("service.XmlUtil_SERIALIZE_FAIL", "\u5e8f\u5217\u5316XML\u5931\u8d25:"), e, new Object[0]);
        }
        buffer.append(stringOut.toString());
        return buffer.toString();
    }

    public String getBase64Xml() throws Exception {
        String result = this.getXml();
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(result.getBytes("UTF-8"));
    }

    public String getBase64Xml(Node node) throws Exception {
        String result = this.getXml(node);
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(result.getBytes("UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(String strFileName, boolean indent) throws Exception {
        boolean oldindent = this.indenting;
        this.indenting = indent;
        try {
            this.saveToFile(strFileName);
        }
        finally {
            this.indenting = oldindent;
        }
    }

    public void saveToFile(String strFileName) throws Exception {
        File file = new File(strFileName);
        File pFile = file.getParentFile();
        if (pFile != null && !pFile.exists()) {
            pFile.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(strFileName);
        OutputFormat format = new OutputFormat(this.xmlDoc);
        format.setEncoding(this.encoding);
        format.setIndenting(this.indenting);
        StringWriter stringOut = new StringWriter();
        XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
        serial.asDOMSerializer();
        serial.serialize(this.xmlDoc);
        out.write(stringOut.toString().getBytes("UTF-8"));
        out.flush();
        out.close();
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.xmlDoc.insertBefore(newChild, refChild);
    }

    public Node addNode(String nodeName) {
        return this.addNode(nodeName, null);
    }

    public Node addNode(String nodeName, String nodeValue) {
        return this.addNode(null, nodeName, nodeValue);
    }

    public Node addNode(Node parentNode, Node aNode) {
        if (aNode == null) {
            return null;
        }
        if (XmlUtil.isAttributeNode(aNode)) {
            if (parentNode == null) {
                return XmlUtil.addAttribute(this.rootNode, aNode);
            }
            return XmlUtil.addAttribute(parentNode, aNode);
        }
        Node result = null;
        result = parentNode == null ? this.rootNode.appendChild(aNode) : parentNode.appendChild(aNode);
        if (this.cacheNode) {
            this.xmlCache.addNodeToCache(result);
        }
        return result;
    }

    public Node addNode(Node parentNode, String nodeName, String nodeValue) {
        Node tmpNode = this.createNode(nodeName);
        if (nodeValue != null) {
            Text tmpText = this.xmlDoc.createTextNode(nodeValue);
            tmpNode.appendChild(tmpText);
        }
        return this.addNode(parentNode, tmpNode);
    }

    public Node deleteNode(Node node) {
        if (node == null) {
            return null;
        }
        if (this.cacheNode) {
            this.xmlCache.deleteNodeFromCache(node);
        }
        return this.rootNode.removeChild(node);
    }

    public Node deleteNode(Node parentNode, Node node) {
        if (parentNode == null) {
            return this.deleteNode(node);
        }
        if (node == null) {
            return null;
        }
        if (this.cacheNode) {
            this.xmlCache.deleteNodeFromCache(node);
        }
        return parentNode.removeChild(node);
    }

    public Node deleteNode(Node parentNode, String xPathString) throws Exception {
        Node tmpNode = this.getNode(parentNode, xPathString);
        return this.deleteNode(parentNode, tmpNode);
    }

    private Document parserDocument(InputStream istream) throws Exception {
        XmlParse parser = (XmlParse)Class.forName(this.xmlParseImplClass).newInstance();
        return parser.parse(istream);
    }

    private Document parserDocument(InputSource is) throws Exception {
        XmlParse parser = (XmlParse)Class.forName(this.xmlParseImplClass).newInstance();
        return parser.parse(is);
    }

    private final String[] splitXPath(String xpath, int pos) {
        String str1 = xpath.substring(0, pos);
        int xpos = str1.lastIndexOf(47);
        if (xpos > 0) {
            str1 = str1.substring(0, xpos);
            String str2 = xpath.substring(xpos + 1);
            return new String[]{str1, str2};
        }
        return new String[]{null, str1};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node getNode(String xPathStr) {
        String xPathString = xPathStr;
        try {
            xPathString = this.prepareProcessXpath(xPathString);
            Node result = null;
            if (this.cacheNode) {
                String[] splitStrs;
                int pos;
                if (this.xpathUsedCondition && (pos = xPathString.indexOf(CONDITIONPREFIX)) > 0 && (splitStrs = this.splitXPath(xPathString, pos))[0] != null) {
                    Node tempNode = this.xmlCache.getCachedNode(this.rootNode, splitStrs[0]);
                    ClassLoader origCL = null;
                    try {
                        origCL = this.changeCL(this.getClass().getClassLoader());
                        Node node = XPathAPI.selectSingleNode((Node)tempNode, (String)splitStrs[1]);
                        return node;
                    }
                    catch (Exception ex) {
                        if (log.isErrorEnabled()) {
                            log.error("\u4f7f\u7528XPATH\u67e5\u627e\u8282\u70b9\u51fa\u9519", ex);
                        }
                    }
                    finally {
                        if (origCL != null) {
                            this.changeCL(origCL);
                        }
                    }
                }
                if ((result = this.xmlCache.getCachedNode(this.rootNode, xPathString)) != null) {
                    return result;
                }
            }
            if (!this.onlyQueryInCache) {
                ClassLoader origCL = null;
                try {
                    origCL = this.changeCL(this.getClass().getClassLoader());
                    result = XPathAPI.selectSingleNode((Node)this.rootNode, (String)xPathString);
                }
                catch (Exception te) {
                    Node node;
                    if (te instanceof NullPointerException) {
                        if (log.isWarnEnabled()) {
                            log.warn("\u7a7a\u6307\u9488\u9519\u8bef\uff0c\u53ef\u80fd\u662f\u8282\u70b9\u4e0d\u5b58\u5728\uff0c\u8fd4\u56denull");
                        }
                        XmlDoc.logWarn(this.rootNode, xPathString);
                        node = null;
                        return node;
                    }
                    if (log.isErrorEnabled()) {
                        log.error("\u4f7f\u7528XPATH\u67e5\u627e\u8282\u70b9\u51fa\u9519", te);
                    }
                    node = null;
                    return node;
                }
                finally {
                    if (origCL != null) {
                        this.changeCL(origCL);
                    }
                }
            }
            if (!this.cacheNode) return result;
            if (result == null) return result;
            this.xmlCache.addNodeToCache(result);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            String path = XmlDoc.logError(null, xPathString);
            throw new EcpRuntimeException("service.XmlDoc_GETNODE_FAIL", EcpI18nUtil.localizedString("service.XmlDoc_GETNODE_FAIL", "\u53d6\u8282\u70b9\u51fa\u9519(Xpath:" + path + "):"), e, new Object[0]);
        }
    }

    public Attr getAttribute(Node node, String attrName) {
        return (Attr)node.getAttributes().getNamedItem(attrName);
    }

    public String getAttributeText(Node node, String attrName) {
        Attr attr = this.getAttribute(node, attrName);
        return attr == null ? null : attr.getNodeValue();
    }

    private String prepareProcessXpath(String xpath) {
        if (xpath != null && xpath.startsWith(String.valueOf('/')) && !xpath.startsWith(REROOTPATH)) {
            String rootPrefix = null;
            rootPrefix = this.rootTagPrefix != null ? this.rootTagPrefix : new StringBuffer().append('/').append(this.rootTag).toString();
            if ((EcpService.getConfigService().getNodeConfig().getServerType() == AppServerType.Junit || EcpService.getConfigService().getNodeConfig().getServerType() == AppServerType.Junit) && log.isInfoEnabled()) {
                log.info("\u5f53\u524dXPATH\u4f7f\u7528\u4e86\u7edd\u5bf9\u8def\u5f84\uff1a" + xpath + " \u5f53\u524d\u6839\u8282\u70b9\u4e3a\uff1a" + rootPrefix + " \u5efa\u8bae\u4f7f\u7528\u76f8\u5bf9\u8def\u5f84\u4ee5\u63d0\u9ad8\u6027\u80fd");
            }
            if (!xpath.startsWith(rootPrefix)) {
                if ((EcpService.getConfigService().getNodeConfig().getServerType() == AppServerType.Junit || EcpService.getConfigService().getNodeConfig().getServerType() == AppServerType.Junit) && log.isWarnEnabled()) {
                    log.warn("\u4f7f\u7528\u4e86\u7edd\u5bf9\u8def\u5f84\u4f46\u6839\u8282\u70b9\u548c\u5f53\u524d\u6587\u6863\u7684\u6839\u8282\u70b9\u4e0d\u5339\u914d[XPath:" + xpath + " \u5f53\u524d\u6839\u8282\u70b9\uff1a" + this.rootTag + "]");
                }
                xpath = xpath.substring(1);
            } else {
                xpath = xpath.substring(xpath.indexOf(47, 1) + 1);
            }
        }
        return xpath;
    }

    public Node getNodeCanNew(String xpath) {
        xpath = this.prepareProcessXpath(xpath);
        Node result = null;
        try {
            result = this.getNode(xpath);
        }
        catch (Throwable e) {
            if (log.isWarnEnabled()) {
                log.warn("\u53d6\u73b0\u6709\u8282\u70b9\u5931\u8d25\uff0c\u5c06\u521b\u5efa\u65b0\u8282\u70b9", e);
            }
            result = null;
        }
        if (result == null) {
            result = this.createNewNode(this.getRootNode(), xpath);
        }
        return result;
    }

    public Node getNodeCanNew(Node parentNode, String xpath) {
        Node result = null;
        try {
            result = this.getNode(parentNode, xpath);
        }
        catch (Throwable e) {
            if (log.isWarnEnabled()) {
                log.warn("\u53d6\u73b0\u6709\u8282\u70b9\u5931\u8d25\uff0c\u5c06\u521b\u5efa\u65b0\u8282\u70b9", e);
            }
            result = null;
        }
        if (result == null) {
            result = this.createNewNode(parentNode, xpath);
        }
        return result;
    }

    private Node createNewNode(Node parentNode, String xpath) {
        StringList list = new StringList();
        list.setText(xpath, '/');
        int count = list.getCount();
        Node newnode = null;
        Node pNode = parentNode;
        String name = null;
        try {
            for (int i = 0; i < count; ++i) {
                name = list.getString(i);
                if (name == null || name.trim().length() == 0) continue;
                newnode = this.getNode(pNode, name);
                if (newnode == null) {
                    newnode = this.createNode(name);
                    if (XmlUtil.isAttributeNode(newnode)) {
                        this.addNode(pNode, newnode);
                    } else {
                        newnode = this.addNode(pNode, newnode);
                    }
                }
                pNode = newnode;
            }
            return newnode;
        }
        catch (Exception e) {
            String path = XmlDoc.logError(parentNode, xpath);
            throw new EcpRuntimeException("service.XmlDoc_CREATENODE_FAIL", EcpI18nUtil.localizedString("service.XmlDoc_CREATENODE_FAIL", "\u521b\u5efa\u65b0\u8282\u70b9\u51fa\u9519(XPATH\uff1a" + path + ")" + e.getMessage()), e, new Object[0]);
        }
    }

    public NodeList getNodeList(String xPathStr) {
        NodeList nodeList;
        block5: {
            ClassLoader origCL = null;
            try {
                xPathStr = this.prepareProcessXpath(xPathStr);
                origCL = this.changeCL(this.getClass().getClassLoader());
                nodeList = XPathAPI.selectNodeList((Node)this.rootNode, (String)xPathStr);
                if (origCL == null) break block5;
                this.changeCL(origCL);
            }
            catch (Exception e) {
                try {
                    String path = XmlDoc.logError(null, xPathStr);
                    throw new EcpRuntimeException("service.XmlDoc_GETNODE_FAIL", EcpI18nUtil.localizedString("service.XmlDoc_GETNODE_FAIL", "\u53d6\u8282\u70b9\u5217\u8868\u51fa\u9519(Xpath:" + path + "):" + XmlUtil.getExceptionAllMessage(e)), e, new Object[0]);
                }
                catch (Throwable throwable) {
                    if (origCL != null) {
                        this.changeCL(origCL);
                    }
                    throw throwable;
                }
            }
        }
        return nodeList;
    }

    private static String logWarn(Node node, String xPathStr) {
        String path;
        block3: {
            path = "";
            path = node != null ? "nodepath:" + XmlUtil.getXPath(node) + "  subpath:" + xPathStr : "XPATH:" + xPathStr;
            if (log.isWarnEnabled()) {
                log.error("\u8bbf\u95ee\u8282\u70b9\u51fa\u9519(XPATH)\uff1a" + path);
                try {
                    log.warn("\u51fa\u9519\u65f6\u7684\u6587\u6863\u4fe1\u606f\u4e3a\uff1a" + XmlUtil.getXml(node, true, EcpService.getConfigService().getApplicationConfig().getCharset().name()));
                }
                catch (Exception e2) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn("\u8bb0\u5f55\u51fa\u9519\u65e5\u5fd7\u51fa\u9519\uff1a" + e2.getMessage(), e2);
                }
            }
        }
        return path;
    }

    private static String logError(Node node, String xPathStr) {
        String path;
        block3: {
            path = "";
            path = node != null ? "nodepath:" + XmlUtil.getXPath(node) + "  subpath:" + xPathStr : "XPATH:" + xPathStr;
            if (log.isErrorEnabled()) {
                log.error("\u8bbf\u95ee\u8282\u70b9\u51fa\u9519(XPATH)\uff1a" + path);
                try {
                    log.error("\u51fa\u9519\u65f6\u7684\u6587\u6863\u4fe1\u606f\u4e3a\uff1a" + XmlUtil.getXml(node, true, EcpService.getConfigService().getApplicationConfig().getCharset().name()));
                }
                catch (Exception e2) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn("\u8bb0\u5f55\u51fa\u9519\u65e5\u5fd7\u51fa\u9519\uff1a" + e2.getMessage(), e2);
                }
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node getNode(Node node, String xPathStr) {
        try {
            if (node == null) {
                return this.getNode(xPathStr);
            }
            xPathStr = this.prepareProcessXpath(xPathStr);
            Node result = null;
            if (this.cacheNode) {
                String[] splitStrs;
                int pos;
                if (this.xpathUsedCondition && (pos = xPathStr.indexOf(CONDITIONPREFIX)) > 0 && (splitStrs = this.splitXPath(xPathStr, pos))[0] != null) {
                    Node tempNode = this.xmlCache.getCachedNode(node, splitStrs[0]);
                    ClassLoader origCL = null;
                    try {
                        origCL = this.changeCL(this.getClass().getClassLoader());
                        Node node2 = XPathAPI.selectSingleNode((Node)tempNode, (String)splitStrs[1]);
                        return node2;
                    }
                    catch (Exception ex) {
                        if (log.isErrorEnabled()) {
                            log.error("\u4f7f\u7528XPATH\u67e5\u627e\u8282\u70b9\u51fa\u9519", ex);
                        }
                    }
                    finally {
                        if (origCL != null) {
                            this.changeCL(origCL);
                        }
                    }
                }
                if ((result = this.xmlCache.getCachedNode(node, xPathStr)) != null) {
                    return result;
                }
            }
            if (!this.onlyQueryInCache) {
                ClassLoader origCL = null;
                try {
                    origCL = this.changeCL(this.getClass().getClassLoader());
                    result = XPathAPI.selectSingleNode((Node)node, (String)xPathStr);
                }
                catch (Exception te) {
                    Node node3;
                    if (te instanceof NullPointerException) {
                        if (log.isWarnEnabled()) {
                            log.warn("\u7a7a\u6307\u9488\u9519\u8bef\uff0c\u53ef\u80fd\u662f\u8282\u70b9\u4e0d\u5b58\u5728\uff0c\u8fd4\u56denull");
                        }
                        XmlDoc.logWarn(node, xPathStr);
                        node3 = null;
                        return node3;
                    }
                    if (log.isErrorEnabled()) {
                        log.error("\u4f7f\u7528XPATH\u67e5\u627e\u8282\u70b9\u51fa\u9519", te);
                    }
                    node3 = null;
                    return node3;
                }
                finally {
                    if (origCL != null) {
                        this.changeCL(origCL);
                    }
                }
            }
            if (!this.cacheNode) return result;
            if (result == null) return result;
            this.xmlCache.addNodeToCache(result);
            return result;
        }
        catch (Exception e) {
            String path = XmlDoc.logError(node, xPathStr);
            throw new EcpRuntimeException("service.XmlDoc_GETNODE_FAIL", EcpI18nUtil.localizedString("service.XmlDoc_GETNODE_FAIL", "\u53d6\u8282\u70b9\u51fa\u9519(Xpath:" + path + "):"), e, new Object[0]);
        }
    }

    public NodeList getNodeList(Node node, String xPathStr) {
        if (node == null) {
            return this.getNodeList(xPathStr);
        }
        ClassLoader origCL = null;
        try {
            origCL = this.changeCL(this.getClass().getClassLoader());
            NodeList nodeList = XPathAPI.selectNodeList((Node)node, (String)xPathStr);
            return nodeList;
        }
        catch (Exception e) {
            String path = XmlDoc.logError(node, xPathStr);
            throw new EcpRuntimeException("service.XmlDoc_GETNODE_FAIL", EcpI18nUtil.localizedString("service.XmlDoc_GETNODE_FAIL", "\u53d6\u8282\u70b9\u5217\u8868\u51fa\u9519(Xpath:" + path + "):" + XmlUtil.getExceptionAllMessage(e)), e, new Object[0]);
        }
        finally {
            if (origCL != null) {
                this.changeCL(origCL);
            }
        }
    }

    public String getNodeText(String xPathString) {
        return this.getNodeText(null, xPathString);
    }

    public int getNodeTextAsInt(String xPathString) {
        String str = this.getNodeText(xPathString);
        return str == null || str.equals("") ? 0 : Integer.parseInt(str);
    }

    public int getNodeTextAsInt(Node node) {
        String str = XmlUtil.getNodeText(node);
        return str == null || str.equals("") ? 0 : Integer.parseInt(str);
    }

    public Node setNodeText(Node node, String XpathStr, String nodeText) throws Exception {
        return XmlUtil.setNodeText(this.getNode(node, XpathStr), nodeText);
    }

    public Node setNodeText(String xPathStr, String nodeText) throws Exception {
        return XmlUtil.setNodeText(this.getNode(xPathStr), nodeText);
    }

    public Node setNodeChildXml(Node node, String xmlStr) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<xml>");
        buffer.append(xmlStr);
        buffer.append("</xml>");
        XmlDoc tmpDoc = new XmlDoc(true);
        tmpDoc.loadFromXml(buffer.toString());
        buffer = null;
        NodeList list = node.getChildNodes();
        for (int i = list.getLength() - 1; i >= 0; --i) {
            node.removeChild(node.getLastChild());
        }
        list = tmpDoc.getRootNode().getChildNodes();
        int isize = list.getLength();
        for (int i = 0; i < isize; ++i) {
            Node tmpNode = list.item(i);
            tmpNode = this.xmlDoc.importNode(tmpNode, true);
            node.appendChild(tmpNode);
        }
        return node;
    }

    public Node setNodeXml(Node node, String newXmlString) {
        if (this.rootNode == node) {
            this.loadFromXml(newXmlString);
            return this.rootNode;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<xml>");
        buffer.append(newXmlString);
        buffer.append("</xml>");
        XmlDoc tmpDoc = new XmlDoc(true);
        tmpDoc.loadFromXml(buffer.toString());
        buffer = null;
        Node newNode = tmpDoc.getRootNode().getChildNodes().item(0);
        Node pnode = node.getParentNode();
        if (pnode == null) {
            pnode = this.getRootNode();
        }
        newNode = this.xmlDoc.importNode(newNode, true);
        pnode.replaceChild(newNode, node);
        return newNode;
    }

    public String getNodeText(Node node, String xPathStr) {
        return XmlUtil.getNodeText(this.getNode(node, xPathStr));
    }

    public int getNodeTextAsInt(Node node, String xPathStr) {
        String str = this.getNodeText(node, xPathStr);
        return str == null || str.equals("") ? 0 : Integer.parseInt(str);
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public void initRootNode() {
        this.rootNode = this.xmlDoc.getDocumentElement();
        this.rootTag = this.rootNode.getNodeName();
        this.createIndex(this.rootNode);
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public String getRootTag() {
        return this.rootNode.getNodeName();
    }

    public Document getXmldoc() {
        return this.xmlDoc;
    }

    public void setNamespaceUri(String string) {
        this.namespaceUri = string;
    }

    public String getXmlParseImplClass() {
        return this.xmlParseImplClass;
    }

    public void setXmlParseImplClass(String string) {
        this.xmlParseImplClass = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isIndenting() {
        return this.indenting;
    }

    public void setIndenting(boolean indenting) {
        this.indenting = indenting;
    }

    public String getRootXpath() {
        return new StringBuffer().append('/').append(this.getRootTag()).toString();
    }

    public Node importNode(Node importedNode, boolean deep) {
        return this.xmlDoc.importNode(importedNode, deep);
    }

    public Node replaceChild(Node newChild, Node oldChild) {
        Node pNode = oldChild.getParentNode();
        if (pNode != null) {
            return pNode.replaceChild(newChild, oldChild);
        }
        return this.xmlDoc.replaceChild(newChild, oldChild);
    }

    public boolean isCacheNode() {
        return this.cacheNode;
    }

    public void setCacheNode(boolean cacheNode) {
        this.cacheNode = cacheNode;
    }

    public boolean isUsedIndex() {
        return this.isCacheNode();
    }

    public void setUsedIndex(boolean useCache) {
        boolean oldValue = this.cacheNode;
        this.setCacheNode(useCache);
        if (!oldValue && oldValue != this.cacheNode) {
            this.createIndex(this.rootNode);
        }
    }

    protected void createIndex(Node startNode) {
        if (startNode == null) {
            return;
        }
        if (!this.isUsedIndex()) {
            if (log.isDebugEnabled()) {
                log.debug("\u5f53\u524d\u6587\u6863\u6ca1\u6709\u8bbe\u7f6e\u4e3a\u652f\u6301\u7d22\u5f15\uff0c\u4f7f\u7528XPATH\u67e5\u627e\u65f6\u6027\u80fd\u8f83\u4f4e\uff0c\u5efa\u8bae\u4f7f\u7528setUsedIndex(true)\u8bbe\u4e3a\u652f\u6301\u7d22\u5f15\u8bbf\u95ee");
            }
            return;
        }
        if (log.isInfoEnabled()) {
            // empty if block
        }
        Node curNode = startNode;
        Node node = null;
        int repeatCount = 0;
        while (true) {
            if ((node = node == null ? curNode.getFirstChild() : node.getNextSibling()) != null) {
                curNode = node;
                node = null;
                continue;
            }
            node = curNode;
            if (!XmlUtil.isTextNode(curNode) && !XmlUtil.isCommentNode(curNode)) {
                String key = this.xmlCache.getKey(curNode);
                if (this.xmlCache.containedNode(key)) {
                    this.xmlCache.deleteNodeFromCache(key);
                    this.xmlCache.addToNotCachedMap(key);
                    ++repeatCount;
                } else {
                    this.xmlCache.addNodeToCache(key, curNode);
                }
            }
            if ((curNode = curNode.getParentNode()) == null || curNode == this.getXmldoc()) break;
        }
        if (log.isInfoEnabled()) {
            // empty if block
        }
    }

    public boolean isXpathUsedCondition() {
        return this.xpathUsedCondition;
    }

    public void setXpathUsedCondition(boolean xpathUsedCondition) {
        this.xpathUsedCondition = xpathUsedCondition;
    }

    public boolean isOnlyQueryInCache() {
        return this.onlyQueryInCache;
    }

    public void setOnlyQueryInCache(boolean onlyQueryInCache) {
        this.onlyQueryInCache = onlyQueryInCache;
    }

    public String getRootTagPrefix() {
        return this.rootTagPrefix;
    }

    public void setRootTagPrefix(String rootTagPrefix) {
        this.rootTagPrefix = rootTagPrefix;
    }

    public final boolean isPreserveSpace() {
        return this.preserveSpace;
    }

    public final void setPreserveSpace(boolean preserveSpace) {
        this.preserveSpace = preserveSpace;
    }

    private ClassLoader changeCL(ClassLoader cl) {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        return tcl;
    }

    public class XmlCache {
        private Map map = new ConcurrentHashMap();
        private Map notCachedMap = new ConcurrentHashMap();

        public XmlCache(XmlDoc xmlDoc) {
        }

        public void addToNotCachedMap(String key) {
            this.notCachedMap.put(key, key);
        }

        private String getKey(Node node, String xPath) {
            String pPath = XmlUtil.getXPath(node, -1);
            return XmlUtil.comboXpath(pPath, xPath, XmlDoc.this.getRootTag());
        }

        private String getKey(String xPath) {
            return xPath;
        }

        private String getKey(Node node) {
            String xPath = XmlUtil.getXPath(node, -1);
            String key = this.getKey(xPath);
            return key;
        }

        public Node getCachedNode(Node node, String xPath) {
            String key = this.getKey(node, xPath);
            if (this.notCachedMap.containsKey(key)) {
                return null;
            }
            Node resultNode = (Node)this.map.get(key);
            return resultNode;
        }

        public void addNodeToCache(Node node) {
            String xPath = XmlUtil.getXPath(node, -1);
            String key = this.getKey(xPath);
            this.map.put(key, node);
            NodeList list = node.getChildNodes();
            Node subNode = null;
            for (int i = 0; i < list.getLength(); ++i) {
                subNode = list.item(i);
                if (!XmlUtil.isElementNode(subNode)) continue;
                this.addNodeToCache(subNode);
            }
        }

        public void deleteNodeFromCache(String xPath) {
            String key = this.getKey(xPath);
            this.map.remove(key);
        }

        public boolean containedNode(String key) {
            return this.map.containsKey(key);
        }

        public void addNodeToCache(String key, Node node) {
            this.map.put(key, node);
            NodeList list = node.getChildNodes();
            Node subNode = null;
            for (int i = 0; i < list.getLength(); ++i) {
                subNode = list.item(i);
                if (!XmlUtil.isElementNode(subNode)) continue;
                this.addNodeToCache(subNode);
            }
        }

        public void deleteNodeFromCache(Node node) {
            String xPath = XmlUtil.getXPath(node, -1);
            String key = this.getKey(xPath);
            this.map.remove(key);
            NodeList list = node.getChildNodes();
            int len = list.getLength();
            Node child = null;
            for (int i = 0; i < len; ++i) {
                child = list.item(i);
                if (!XmlUtil.isElementNode(child)) continue;
                this.deleteNodeFromCache(child);
            }
        }

        public void clear() {
            this.map.clear();
            this.notCachedMap.clear();
        }
    }
}

