/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool.sftp;

import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.sftp.SFTPChannel;

public final class SFTPUtil {
    private static boolean isUseSFTP = false;
    private static String host;
    private static int port;
    private static String username;
    private static String password;

    private SFTPUtil() {
    }

    public static SFTPUtil newInsance() {
        return new SFTPUtil();
    }

    public static SFTPChannel getChannel(String phost, int ppost, String puserName, String ppasswd) {
        return new SFTPChannel(phost, ppost, puserName, ppasswd);
    }

    public static SFTPChannel getChannel() {
        if (host == null) {
            String sftpSetting = System.getProperty("unstructure.sftp.setting");
            if (StringUtil.isEmptyString(sftpSetting)) {
                throw new EcpRuntimeException("E0208.0030", "\u4f7f\u7528SFTP\u534f\u8bae\u5b58\u50a8\u6587\u4ef6\u65f6\u5728\u7cfb\u7edf\u53c2\u6570\u4e2d\u6ca1\u914d\u7f6e\u4fe1\u606f");
            }
            String[] settingArr = sftpSetting.split("\\|");
            int settingArrlen = settingArr.length;
            if (settingArrlen != 4 && settingArrlen != 3) {
                throw new EcpRuntimeException("E0208.0031", "\u4f7f\u7528SFTP\u534f\u8bae\u5b58\u50a8\u6587\u4ef6\u65f6\u5728\u7cfb\u7edf\u53c2\u6570\u4e2d\u914d\u7f6e\u4fe1\u606f\u6709\u8bef");
            }
            host = settingArr[0];
            if (StringUtil.isEmptyString(host)) {
                throw new EcpRuntimeException("E0208.0027", "\u4f7f\u7528SFTP\u534f\u8bae\u5b58\u50a8\u6587\u4ef6\u65f6\u5728\u7cfb\u7edf\u53c2\u6570\u4e2d\u6ca1\u914d\u7f6e\u9ed8\u8ba4\u7684\u670d\u52a1\u5668\u8fde\u63a5\u5730\u5740");
            }
            port = 22;
            String pport = settingArr[1];
            if (StringUtil.isNotEmpty(pport)) {
                port = Integer.parseInt(pport);
            }
            if (StringUtil.isEmptyString(username = settingArr[2])) {
                throw new EcpRuntimeException("E0208.0029", "\u4f7f\u7528SFTP\u534f\u8bae\u5b58\u50a8\u6587\u4ef6\u65f6\u5728\u7cfb\u7edf\u53c2\u6570\u4e2d\u6ca1\u914d\u7f6e\u9ed8\u8ba4\u7684\u7528\u6237\u540d");
            }
            if (settingArrlen == 4) {
                password = settingArr[3];
            }
        }
        return new SFTPChannel(host, port, username, password);
    }

    public static boolean isUseSFTP() {
        return isUseSFTP;
    }

    public static void setUseSFTP(boolean newIsUseSFTP) {
        isUseSFTP = newIsUseSFTP;
    }
}

