/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.cons.SecurityType;
import com.ygsoft.ecp.service.internal.tool.AssertException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.ConfigUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.SecurityUtil;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public final class ValidatorUtil
implements IEcpToolLogic {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ValidatorUtil.class);
    public static final String REGULAREXPRESSION_DATE = "^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1][0-9])|([2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$";
    public static final String REGULAREXPRESSION_EMAIL = "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$";
    public static final String REGULAREXPRESSION_IP = "\\d+\\.\\d+\\.\\d+\\.\\d+";
    public static final String REGULAREXPRESSION_OPPOSITE_URL = "[a-z0-9A-Z_/.-]+";
    public static final String REGULAREXPRESSION_SCRIPT = "(?is)<script[^>]*?>.*?<\\/script>";
    private static final String REG = "(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(select|update|and|or|delete|insert|truncate|char|into|substr|ascii|declare|exec|master|drop|execute|ctxsys|chr|concat|utl_inaddr|utl_http|utl_raw)\\b)";
    private static final Pattern SQL_PATTERN = Pattern.compile("(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(select|update|and|or|delete|insert|truncate|char|into|substr|ascii|declare|exec|master|drop|execute|ctxsys|chr|concat|utl_inaddr|utl_http|utl_raw)\\b)", 2);

    private ValidatorUtil() {
    }

    public static boolean validateRequired(String value) {
        return value != null && value.trim().length() > 0;
    }

    public static boolean validateInt(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean validateLong(String value) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean validateFloat(String value) {
        try {
            Float.parseFloat(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean validateDouble(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean validateDate(String value) {
        return ValidatorUtil.matchPattern(value.trim(), REGULAREXPRESSION_DATE);
    }

    public static boolean validateLength(String value, int minLength, int maxLength) {
        String validatedValue = value;
        if (!ValidatorUtil.validateRequired(value)) {
            validatedValue = "";
        }
        return validatedValue.length() >= minLength && validatedValue.length() <= maxLength;
    }

    public static boolean validateIntegerRange(int value, int min, int max) {
        return value >= min && value <= max;
    }

    public static boolean validateOption(String value, String[] options) {
        try {
            List<String> list = Arrays.asList(options);
            if (list != null) {
                return list.contains(value);
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean validateOppositeUrl(String value) {
        return ValidatorUtil.matchPattern(value, REGULAREXPRESSION_OPPOSITE_URL);
    }

    public static boolean matchPattern(String value, String expression) {
        if (ValidatorUtil.validateRequired(expression)) {
            return Pattern.matches(expression, value);
        }
        return false;
    }

    public static boolean checkSQLInjectionAttack(String str) {
        if (SecurityUtil.check(SecurityType.SECURITY_CHECK) && SecurityUtil.check(SecurityType.WEB_CHECK)) {
            String qurystr = str;
            if (ValidatorUtil.validateRequired(str)) {
                if (!qurystr.equals("")) {
                    try {
                        qurystr = URLDecoder.decode(qurystr, ConfigUtil.getCharsetName());
                    }
                    catch (Exception ex) {
                        LOG.error(ex.getMessage(), ex);
                    }
                }
                if (qurystr.indexOf("\r\n") != -1) {
                    qurystr = qurystr.replaceAll("\r\n", "");
                }
                if (qurystr.indexOf("\n\r") != -1) {
                    qurystr = qurystr.replaceAll("\n\r", "");
                }
                if (qurystr.indexOf("\r") != -1) {
                    qurystr = qurystr.replaceAll("\r", "");
                }
                if (qurystr.indexOf("\n") != -1) {
                    qurystr = qurystr.replaceAll("\n", "");
                }
                if (SQL_PATTERN.matcher(qurystr).find() || qurystr.indexOf(" sys.") > -1 || qurystr.indexOf(" utl_") > -1 || qurystr.indexOf(" dbms_") > -1 || qurystr.indexOf(" count(") > -1) {
                    LOG.error("\u8f93\u5165\u6570\u636e\u4e0d\u5408\u6cd5\uff1astr=" + qurystr);
                    return true;
                }
                if (!"false".equals(System.getProperty("SECURITY_CHECK"))) {
                    if (!"false".equals(System.getProperty("DYH_CHECK")) && ValidatorUtil.counter(qurystr, '\'') % 2 != 0) {
                        LOG.error("\u8f93\u5165\u6570\u636e\u4e0d\u5408\u6cd5\uff1astr=" + qurystr);
                        return true;
                    }
                    if ("true".equals(System.getProperty("KH_CHECK")) && qurystr.indexOf("(") > -1) {
                        LOG.error("\u8f93\u5165\u6570\u636e\u4e0d\u5408\u6cd5\uff1astr=" + qurystr);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static int counter(String s, char c) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static boolean checkFiledNameSQLInjectionAttack(String str) {
        String tmpStr;
        if (ValidatorUtil.validateRequired(str) && ((tmpStr = str).indexOf(" ") > -1 || tmpStr.indexOf("--") > -1 || ValidatorUtil.checkSQLInjectionAttack(tmpStr))) {
            LOG.error("\u8f93\u5165\u6570\u636e\u4e0d\u5408\u6cd5\uff1astr=" + tmpStr);
            return true;
        }
        return false;
    }

    public static boolean checkLocalFileInjectionAttack(String str) {
        String tmpStr;
        if (ValidatorUtil.validateRequired(str) && ((tmpStr = str.replaceAll("\\\\", "/").toLowerCase()).indexOf("/.") > -1 || tmpStr.indexOf("%2f.") > -1 || tmpStr.indexOf(".%2f") > -1 || tmpStr.indexOf("./") > -1)) {
            LOG.error("\u8f93\u5165\u6570\u636e\u4e0d\u5408\u6cd5\uff0c\u5b58\u5728\u672c\u5730\u6587\u4ef6\u653b\u51fb\u98ce\u9669\uff01");
            return true;
        }
        return false;
    }

    public static void checkXSSInjectionAttack(String str) {
        if (ValidatorUtil.validateRequired(str) && Pattern.matches(REGULAREXPRESSION_SCRIPT, str)) {
            String error = "\u8f93\u5165\u6570\u636e[" + str + "]\u4e0d\u5408\u6cd5\u6709script\u6807\u8bb0\uff0c\u5b58\u5728\u8de8\u7ad9\u811a\u672c\u653b\u51fb\u98ce\u9669!";
            LOG.error(error);
            throw new AssertException(error);
        }
    }

    public static boolean checkInjectionAttack(String str) {
        if (ValidatorUtil.checkSQLInjectionAttack(str)) {
            return true;
        }
        return ValidatorUtil.checkLocalFileInjectionAttack(str);
    }
}

