/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.exception.StreamException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public final class StreamUtil
implements IEcpToolLogic {
    private static final int BUFFERSIZE = 1024;

    private StreamUtil() {
    }

    public static void closeStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                throw new StreamException("E0208.0019", e);
            }
        }
    }

    public static void closeStream(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                throw new StreamException("E0208.0019", e);
            }
        }
    }

    public static void closeWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception e) {
                throw new StreamException("E0208.0019", e);
            }
        }
    }

    public static void closeReader(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception e) {
                throw new StreamException("E0208.0019", e);
            }
        }
    }

    public static String getString(Reader reader) throws IOException {
        StringBuffer buffer = new StringBuffer();
        int c = 0;
        char[] cs = new char[1024];
        while ((c = reader.read(cs)) > 0) {
            buffer.append(cs, 0, c);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(InputStream stream) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        try {
            byte[] result;
            int c = 0;
            byte[] bs = new byte[1024];
            while ((c = stream.read(bs)) > 0) {
                out.write(bs, 0, c);
            }
            byArray = result = out.toByteArray();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            StreamUtil.closeStream(out);
            throw throwable;
        }
        StreamUtil.closeStream(out);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(File file) throws IOException {
        byte[] byArray;
        block2: {
            FileInputStream stream = new FileInputStream(file);
            try {
                byArray = StreamUtil.getBytes(stream);
                Object var4_3 = null;
                if (stream == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_4 = null;
                    if (stream == null) break block3;
                    ((InputStream)stream).close();
                }
                throw throwable;
            }
            ((InputStream)stream).close();
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] serialize(Object o) {
        byte[] byArray;
        ObjectOutputStream os;
        block11: {
            ByteArrayOutputStream bos = null;
            os = null;
            try {
                try {
                    bos = new ByteArrayOutputStream();
                    os = new ObjectOutputStream(bos);
                    os.writeObject(o);
                    os.close();
                    bos.close();
                    byArray = bos.toByteArray();
                    Object var5_5 = null;
                    if (bos == null) break block11;
                }
                catch (Exception e) {
                    throw new StreamException("E0208.0018", EcpI18nUtil.localizedString("E0208.0018", "\u7f13\u5b58\u5e8f\u5217\u5316\u5bf9\u8c61\u5931\u8d25!"), e, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException e2) {
                        throw new StreamException("E0208.0019", EcpI18nUtil.localizedString("E0208.0019", "\u7f13\u5b58\u5e8f\u5217\u5316\u5bf9\u8c61\u8f93\u51fa\u6d41\u5173\u95ed\u5931\u8d25!"), e2, new Object[0]);
                    }
                }
                if (os == null) throw throwable;
                try {
                    os.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    throw new StreamException("E0208.0019", EcpI18nUtil.localizedString("E0208.0019", "\u7f13\u5b58\u5e8f\u5217\u5316\u5bf9\u8c61\u8f93\u51fa\u6d41\u5173\u95ed\u5931\u8d25!"), e3, new Object[0]);
                }
            }
            try {}
            catch (IOException e2) {
                throw new StreamException("E0208.0019", EcpI18nUtil.localizedString("E0208.0019", "\u7f13\u5b58\u5e8f\u5217\u5316\u5bf9\u8c61\u8f93\u51fa\u6d41\u5173\u95ed\u5931\u8d25!"), e2, new Object[0]);
            }
            bos.close();
        }
        if (os == null) return byArray;
        try {}
        catch (IOException e3) {
            throw new StreamException("E0208.0019", EcpI18nUtil.localizedString("E0208.0019", "\u7f13\u5b58\u5e8f\u5217\u5316\u5bf9\u8c61\u8f93\u51fa\u6d41\u5173\u95ed\u5931\u8d25!"), e3, new Object[0]);
        }
        os.close();
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(byte[] in) {
        Object object;
        ObjectInputStream is;
        block12: {
            if (in == null) {
                return null;
            }
            ByteArrayInputStream bis = null;
            is = null;
            try {
                try {
                    Object rv;
                    bis = new ByteArrayInputStream(in);
                    is = new ObjectInputStream(bis);
                    object = rv = is.readObject();
                    Object var6_6 = null;
                    if (bis == null) break block12;
                }
                catch (Exception e) {
                    throw new StreamException("E0208.0018", EcpI18nUtil.localizedString("E0208.0018", "\u7f13\u5b58\u53cd\u5e8f\u5217\u5316\u5bf9\u8c61\u5931\u8d25!"), e, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e2) {
                        throw new StreamException("E0208.0019", EcpI18nUtil.localizedString("E0208.0019", "\u7f13\u5b58\u53cd\u5e8f\u5217\u5316\u5bf9\u8c61\u8f93\u5165\u6d41\u5173\u95ed\u5931\u8d25!"), e2, new Object[0]);
                    }
                }
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    throw new StreamException("E0208.0019", EcpI18nUtil.localizedString("E0208.0019", "\u7f13\u5b58\u53cd\u5e8f\u5217\u5316\u5bf9\u8c61\u8f93\u5165\u6d41\u5173\u95ed\u5931\u8d25!"), e3, new Object[0]);
                }
            }
            try {}
            catch (IOException e2) {
                throw new StreamException("E0208.0019", EcpI18nUtil.localizedString("E0208.0019", "\u7f13\u5b58\u53cd\u5e8f\u5217\u5316\u5bf9\u8c61\u8f93\u5165\u6d41\u5173\u95ed\u5931\u8d25!"), e2, new Object[0]);
            }
            bis.close();
        }
        if (is == null) return object;
        try {}
        catch (IOException e3) {
            throw new StreamException("E0208.0019", EcpI18nUtil.localizedString("E0208.0019", "\u7f13\u5b58\u53cd\u5e8f\u5217\u5316\u5bf9\u8c61\u8f93\u5165\u6d41\u5173\u95ed\u5931\u8d25!"), e3, new Object[0]);
        }
        is.close();
        return object;
    }
}

