/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.framework.spring.SpringContextHolder;
import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.executor.ConcurrentHashSet;
import com.ygsoft.ecp.service.im.IYGIMSender;
import com.ygsoft.ecp.service.jms.DefMessageServiceConfig;
import com.ygsoft.ecp.service.jms.DefReceiveServiceConfig;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.mail.IMailSender;
import com.ygsoft.ecp.service.mail.IMailServiceFactory;
import com.ygsoft.ecp.service.mail.MailboxConfig;
import com.ygsoft.ecp.service.message.ActiveMQTransportListener;
import com.ygsoft.ecp.service.message.IJndiResourceFactory;
import com.ygsoft.ecp.service.message.IMessage;
import com.ygsoft.ecp.service.message.IMessageHandler;
import com.ygsoft.ecp.service.message.IMessageService;
import com.ygsoft.ecp.service.message.IMessageServiceFactory;
import com.ygsoft.ecp.service.message.IReceiveService;
import com.ygsoft.ecp.service.message.MessageServiceConfig;
import com.ygsoft.ecp.service.message.ReceiveServiceConfig;
import com.ygsoft.ecp.service.sms.ISmsSender;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.RuntimeEnvUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.XtcsUtil;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageUtil
implements IEcpToolLogic {
    private static final IEcpLog LOG = EcpLogFactory.getLog(MessageUtil.class);
    private static Set<String> topicCache = new ConcurrentHashSet<String>();
    private static Set<String> queueCache = new ConcurrentHashSet<String>();
    private static volatile IJndiResourceFactory jndiResourceFactory = null;
    private static volatile IYGIMSender ygimSender = null;
    private static volatile IMailServiceFactory mailServiceFactory = null;
    private static volatile IMessageServiceFactory messageFactory = null;
    private static volatile ISmsSender smsSender = null;

    private MessageUtil() {
    }

    public static IMessageService getMessageService(MessageServiceConfig config) {
        try {
            return MessageUtil.getMessageFactory().getMessageService(config);
        }
        catch (Throwable e) {
            throw new EcpRuntimeException("service.MessageService_NOT_FOUND", EcpI18nUtil.localizedString("service.MessageService_NOT_FOUND", "\u83b7\u53d6\u6d88\u606f\u670d\u52a1\u5931\u8d25"), e, new Object[0]);
        }
    }

    public static <V extends IMessage> void sendQueueMessage(String queueName, V message, Class<? extends IMessageHandler> handler) {
        MessageUtil.send(queueName, message, false, handler);
    }

    public static <V extends IMessage> void sendTopicMessage(String topicName, V message, Class<? extends IMessageHandler> handler) {
        MessageUtil.send(topicName, message, true, handler);
    }

    private static <V extends IMessage> void send(String name, V message, boolean isTopic, Class<? extends IMessageHandler> handler) {
        try {
            boolean flag;
            boolean bl = flag = isTopic ? topicCache.contains(name) : queueCache.contains(name);
            if (!flag) {
                DefReceiveServiceConfig config = new DefReceiveServiceConfig(name, isTopic, handler);
                IReceiveService service = MessageUtil.getMessageFactory().getReceiveService(config);
                service.start();
                if (isTopic) {
                    topicCache.add(name);
                } else {
                    queueCache.add(name);
                }
            }
            if (isTopic) {
                MessageUtil.sendTopicMessage(name, message);
            } else {
                MessageUtil.sendQueueMessage(name, message);
            }
        }
        catch (Exception e) {
            throw new EcpRuntimeException("service.MessageService_NOT_FOUND", EcpI18nUtil.localizedString("service.MessageService_NOT_FOUND", "\u83b7\u53d6\u6d88\u606f\u670d\u52a1\u5931\u8d25"), e, new Object[0]);
        }
    }

    public static <V extends IMessage> void sendQueueMessage(String queueName, V message) {
        MessageUtil.send(queueName, message, false);
    }

    public static <V extends IMessage> void sendTopicMessage(String topicName, V message) {
        MessageUtil.send(topicName, message, true);
    }

    private static <V extends IMessage> void send(String name, V message, boolean isTopic) {
        block2: {
            try {
                DefMessageServiceConfig config = new DefMessageServiceConfig(name, isTopic);
                MessageUtil.getMessageService(config).send(message);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error(e);
            }
        }
    }

    public static IReceiveService getReceiveService(ReceiveServiceConfig config) {
        try {
            return MessageUtil.getMessageFactory().getReceiveService(config);
        }
        catch (Throwable e) {
            throw new EcpRuntimeException("service.ReceiveService_NOT_FOUND", EcpI18nUtil.localizedString("service.ReceiveService_NOT_FOUND", "\u83b7\u53d6\u6d88\u606f\u5f02\u6b65\u4fa6\u542c\u670d\u52a1\u5931\u8d25"), e, new Object[0]);
        }
    }

    public static IMailSender getMailSender() {
        return MessageUtil.getMailServiceFactory().getMailSender();
    }

    public static IMailSender getMailSender(Properties props) {
        return MessageUtil.getMailServiceFactory().getMailSender(props);
    }

    public static IMailSender getMailSender(MailboxConfig mailboxConfig) {
        return MessageUtil.getMailServiceFactory().getMailSender(mailboxConfig);
    }

    public static ISmsSender getSmsSender() {
        if (smsSender == null) {
            try {
                String clsName = "com.ygsoft.ecp.component.sms.SmsYGSender";
                smsSender = (ISmsSender)Class.forName("com.ygsoft.ecp.component.sms.SmsYGSender").newInstance();
            }
            catch (Throwable e) {
                throw new EcpRuntimeException("service.SmsServiceFactory_NOT_FOUND", EcpI18nUtil.localizedString("service.SmsServiceFactory_NOT_FOUND", "\u77ed\u4fe1\u670d\u52a1\u6ca1\u6709\u627e\u5230"), e, new Object[0]);
            }
        }
        return smsSender;
    }

    private static IMessageServiceFactory getMessageFactory() {
        if (messageFactory == null) {
            try {
                String id = "com.ygsoft.ecp.service.message.IMessageServiceFactory";
                messageFactory = (IMessageServiceFactory)SpringContextHolder.INSTANCE.getApplicationContext().getBean("com.ygsoft.ecp.service.message.IMessageServiceFactory");
            }
            catch (Throwable e) {
                throw new EcpRuntimeException("service.MessageServiceFactory_NOT_FOUND", EcpI18nUtil.localizedString("service.MessageServiceFactory_NOT_FOUND", "\u6d88\u606f\u5de5\u5382\u7c7b\u6ca1\u6709\u627e\u5230"), e, new Object[0]);
            }
        }
        return messageFactory;
    }

    private static IMailServiceFactory getMailServiceFactory() {
        if (mailServiceFactory == null && (mailServiceFactory = (IMailServiceFactory)SpringContextHolder.INSTANCE.getApplicationContext().getBean(IMailServiceFactory.class)) == null) {
            try {
                String clsName = "com.ygsoft.ecp.service.mail.impl.MailServiceFactory";
                mailServiceFactory = (IMailServiceFactory)Class.forName("com.ygsoft.ecp.service.mail.impl.MailServiceFactory").newInstance();
            }
            catch (Throwable e) {
                throw new EcpRuntimeException("service.MailServiceFactory_NOT_FOUND", EcpI18nUtil.localizedString("service.MailServiceFactory_NOT_FOUND", "\u90ae\u4ef6\u670d\u52a1\u5de5\u5382\u7c7b\u6ca1\u6709\u627e\u5230"), e, new Object[0]);
            }
        }
        return mailServiceFactory;
    }

    public static Properties getJndiTemplateEnv() {
        IJndiResourceFactory jndiFactoryService = MessageUtil.getJndiResourceFactory();
        if (null != jndiFactoryService) {
            return jndiFactoryService.getJndiTemplateEnv();
        }
        return null;
    }

    public static Properties getJndiTemplateEnv(String mqName) {
        IJndiResourceFactory jndiFactoryService = MessageUtil.getJndiResourceFactory();
        if (null != jndiFactoryService) {
            return jndiFactoryService.getJndiTemplateEnv(mqName);
        }
        return null;
    }

    private static IJndiResourceFactory getJndiResourceFactory() {
        if (jndiResourceFactory == null) {
            try {
                String clsName = "com.ygsoft.ecp.service.message.impl.resource.JndiResourceFactory";
                jndiResourceFactory = (IJndiResourceFactory)Class.forName("com.ygsoft.ecp.service.message.impl.resource.JndiResourceFactory").newInstance();
            }
            catch (Throwable e) {
                throw new EcpRuntimeException("service.JndiResourceFactory_NOT_FOUND", EcpI18nUtil.localizedString("service.JndiResourceFactory_NOT_FOUND", "JNDI\u8d44\u6e90\u5de5\u5382\u7c7b\u6ca1\u6709\u627e\u5230"), e, new Object[0]);
            }
        }
        return jndiResourceFactory;
    }

    public static String getMessageUrl() {
        return XtcsUtil.readConfigValueThreePhase("Message.ActiveMQ", "java.naming.provider.url", "ECPMSG_ACTIVEMQ_PROVIDER_URL", null);
    }

    public static boolean isMQConnected() {
        if (ActiveMQTransportListener.INSTANCE.isAlive()) {
            return true;
        }
        if (!RuntimeEnvUtil.INSTANCE.isDeployment()) {
            return false;
        }
        String url = MessageUtil.getMessageUrl();
        if (StringUtil.isEmptyString(url)) {
            return false;
        }
        return MessageUtil.isMQConnected(url);
    }

    public static boolean isMQConnected(String url) {
        boolean flag = false;
        if (url.startsWith("failover")) {
            String[] urls;
            int start = url.indexOf("(");
            int end = url.indexOf(")");
            for (String u : urls = url.substring(start, end).split(",")) {
                String[] s = u.split(":");
                String ip = s[1].substring(2);
                int port = Integer.parseInt(s[2]);
                flag = flag || MessageUtil.checkConnect(ip, port);
            }
        } else {
            String[] s = url.split(":");
            String ip = s[1].substring(2);
            int port = Integer.parseInt(s[2]);
            flag = MessageUtil.checkConnect(ip, port);
        }
        if (!flag && LOG.isErrorEnabled()) {
            LOG.error("******************\u914d\u7f6e\u7684MQ\u6d88\u606f\u670d\u52a1\u5668\u5730\u5740\u65e0\u6cd5\u8bbf\u95ee[" + url + "]*****************");
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkConnect(String ip, int port) {
        boolean bl;
        Socket socket = null;
        try {
            try {
                socket = new Socket(ip, port);
                bl = true;
                Object var6_5 = null;
                if (socket == null) return bl;
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("\u68c0\u6d4b\u6307\u5b9aIP\u5730\u5740\u548c\u7aef\u53e3\u662f\u5426\u8fde\u901a\u5931\u8d25,\u6307\u5b9a\u7684\u670d\u52a1\u5668\u5730\u5740\u65e0\u6cd5\u8bbf\u95ee[" + ip + ":" + port + "]");
                }
                boolean bl2 = false;
                Object var6_6 = null;
                if (socket == null) return bl2;
                try {
                    socket.close();
                    return bl2;
                }
                catch (IOException e2) {
                    if (!LOG.isErrorEnabled()) return bl2;
                    LOG.error("\u670d\u52a1\u5668socked\u8fde\u63a5\u5173\u95ed\u5f02\u5e38 ");
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (socket == null) throw throwable;
            try {}
            catch (IOException e2) {
                if (!LOG.isErrorEnabled()) throw throwable;
                LOG.error("\u670d\u52a1\u5668socked\u8fde\u63a5\u5173\u95ed\u5f02\u5e38 ");
                throw throwable;
            }
            socket.close();
            throw throwable;
        }
        try {}
        catch (IOException e2) {
            if (!LOG.isErrorEnabled()) return bl;
            LOG.error("\u670d\u52a1\u5668socked\u8fde\u63a5\u5173\u95ed\u5f02\u5e38 ");
            return bl;
        }
        socket.close();
        return bl;
    }

    public static IYGIMSender getYGIMSender() {
        if (ygimSender == null) {
            try {
                String clsName = "com.ygsoft.ecp.service.ygim.IYGIMSender";
                ygimSender = (IYGIMSender)Class.forName("com.ygsoft.ecp.service.ygim.IYGIMSender").newInstance();
            }
            catch (Throwable e) {
                throw new EcpRuntimeException("service.IYGIMSender_NOT_FOUND", EcpI18nUtil.localizedString("service.IYGIMSender_NOT_FOUND", "\u4f01\u4e1a\u793e\u533a\u670d\u52a1\u6ca1\u6709\u627e\u5230"), e, new Object[0]);
            }
        }
        return ygimSender;
    }
}

