/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.framework.actuator.TraceHolder;
import com.ygsoft.ecp.framework.cons.MappConst;
import com.ygsoft.ecp.framework.token.TokenHolder;
import com.ygsoft.ecp.framework.util.CryptUtil;
import com.ygsoft.ecp.service.async.IAsyncCallback;
import com.ygsoft.ecp.service.async.IAsyncResult;
import com.ygsoft.ecp.service.internal.config.ApplicationConfig;
import com.ygsoft.ecp.service.internal.tool.HTTPServiceProxy;
import com.ygsoft.ecp.service.internal.tool.HTTPServiceRequester;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.AsyncUtil;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.EncodeUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.StreamUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.UuidUtil;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import sun.net.www.protocol.http.HttpURLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MappUtil
implements IEcpToolLogic {
    private static final IEcpLog LOG = EcpLogFactory.getLog(MappUtil.class);
    private static final int CONNECT_TIMEOUT = 2000;
    private static final int READ_TIMEOUT = 3600000;
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String DEFUALT_ENCODER = "UTF-8";
    private static final String MAPP_CLIENT_CLASS = "com.ygsoft.ecp.core.mapp.util.AddressUtil";
    public static final String HTTP_PREFIX = "http://";
    public static final String HTTPS_PREFIX = "https://";
    private static final String MAPP_MARK = "/mapp/";
    private static final String VIPADDRESS_PARAM = "m_vipaddress=";

    private MappUtil() {
    }

    private static void addHeader(java.net.HttpURLConnection conn, Map<String, String> headers) {
        if (MapUtils.isEmpty(headers)) {
            return;
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            conn.addRequestProperty(entry.getKey(), entry.getValue());
        }
    }

    public static IAsyncResult<String> doPostAsync(String url, String param, IAsyncCallback callBack) {
        Object[] paramers = new Object[]{url, param};
        return AsyncUtil.invokeByCallback(MappUtil.class, "doPost", callBack, paramers);
    }

    public static IAsyncResult<String> doPostAsync4Jt(String url, String targetJtApplicationName, String param, IAsyncCallback callBack) {
        Object[] paramers = new Object[]{url, targetJtApplicationName, param};
        return AsyncUtil.invokeByCallback(MappUtil.class, "doPost4Jt", callBack, paramers);
    }

    public static String doPost(String url, String param) {
        Map<String, String> headers = null;
        return MappUtil.doPost(url, param, headers);
    }

    public static String doPost4Jt(String url, String targetJtApplicationName, String param) {
        Map<String, String> headers = null;
        return MappUtil.doPost4Jt(url, targetJtApplicationName, param, headers);
    }

    public static String doPost(String url, String param, Map<String, String> headers) {
        String uuid;
        String targetUrl;
        long startTime;
        StringBuilder sb;
        InputStream in;
        java.net.HttpURLConnection conn;
        PrintWriter out;
        block14: {
            int index;
            out = null;
            conn = null;
            in = null;
            sb = new StringBuilder();
            startTime = System.currentTimeMillis();
            targetUrl = null;
            uuid = UuidUtil.newUUID();
            String urlString = MappUtil.getMappUrl(url);
            String token = TokenHolder.INSTANCE.getToken();
            if (token == null || token.trim().length() == 0) {
                token = "ecp.mapp";
            }
            urlString = (index = urlString.indexOf("?")) > 0 ? urlString + "&ecp_token=" + token : urlString + "?ecp_token=" + token;
            String pid = TraceHolder.INSTANCE.getId();
            if (pid == null) {
                pid = "null";
            }
            urlString = urlString + "&" + "trice_pid" + "=" + pid + "&ecp.mapp=true";
            try {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.net.www.protocol.http.HttpURLConnection");
                if (clazz != null) {
                    conn = new HttpURLConnection(new URL(urlString), null);
                }
            }
            catch (ClassNotFoundException ex) {
                conn = (java.net.HttpURLConnection)new URL(urlString).openConnection();
            }
            targetUrl = urlString;
            MappUtil.startLog(uuid, url, urlString, null);
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(2000);
            conn.setReadTimeout(3600000);
            conn.setRequestProperty("Accept-Charset", DEFUALT_ENCODER);
            conn.setRequestProperty("Charset", ApplicationConfig.INSTANCE.getCharset().name());
            conn.setRequestProperty("Content-Type", CONTENT_TYPE_JSON);
            conn.setRequestProperty("Content-Encoding", ApplicationConfig.INSTANCE.getCharset().name());
            conn.addRequestProperty("ecp_token", token);
            String time = String.valueOf(System.currentTimeMillis());
            String sm4CBCTime = CryptUtil.encodeSM4CBC(null, (String)time);
            conn.addRequestProperty("stime", sm4CBCTime);
            MappUtil.addHeader(conn, headers);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            out = new PrintWriter(new OutputStreamWriter(conn.getOutputStream(), DEFUALT_ENCODER));
            out.print(param);
            out.flush();
            int statusCode = conn.getResponseCode();
            in = statusCode == 200 ? conn.getInputStream() : conn.getErrorStream();
            sb.append(IOUtils.toString((InputStream)in, (Charset)Charset.forName(DEFUALT_ENCODER)));
            in.close();
            if (statusCode != 200) break block14;
            String string = sb.toString();
            Object var20_20 = null;
            StreamUtil.closeWriter(out);
            StreamUtil.closeStream(in);
            if (conn != null) {
                conn.disconnect();
            }
            long costTime = System.currentTimeMillis() - startTime;
            MappUtil.endLog(uuid, url, targetUrl, null, costTime);
            return string;
        }
        try {
            try {
                throw new RuntimeException(sb.toString());
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("\u53d1\u9001 POST \u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var20_21 = null;
            StreamUtil.closeWriter(out);
            StreamUtil.closeStream(in);
            if (conn != null) {
                conn.disconnect();
            }
            long costTime = System.currentTimeMillis() - startTime;
            MappUtil.endLog(uuid, url, targetUrl, null, costTime);
            throw throwable;
        }
    }

    public static String doPost4Jt(String url, String targetJtApplicationName, String param, Map<String, String> headers) {
        String uuid;
        String targetUrl;
        long startTime;
        StringBuilder sb;
        InputStream in;
        java.net.HttpURLConnection conn;
        PrintWriter out;
        block14: {
            int index;
            out = null;
            conn = null;
            in = null;
            sb = new StringBuilder();
            startTime = System.currentTimeMillis();
            targetUrl = null;
            uuid = UuidUtil.newUUID();
            String urlString = "";
            urlString = StringUtil.isNotEmpty(targetJtApplicationName) ? MappUtil.getMappUrl(url, targetJtApplicationName) : MappUtil.getMappUrl(url);
            String token = TokenHolder.INSTANCE.getToken();
            if (token == null || token.trim().length() == 0) {
                token = "ecp.mapp";
            }
            urlString = (index = urlString.indexOf("?")) > 0 ? urlString + "&ecp_token=" + token : urlString + "?ecp_token=" + token;
            String pid = TraceHolder.INSTANCE.getId();
            if (pid == null) {
                pid = "null";
            }
            urlString = urlString + "&" + "trice_pid" + "=" + pid + "&ecp.mapp=true";
            try {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.net.www.protocol.http.HttpURLConnection");
                if (clazz != null) {
                    conn = new HttpURLConnection(new URL(urlString), null);
                }
            }
            catch (ClassNotFoundException ex) {
                conn = (java.net.HttpURLConnection)new URL(urlString).openConnection();
            }
            targetUrl = urlString;
            MappUtil.startLog(uuid, url, urlString, targetJtApplicationName);
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(2000);
            conn.setReadTimeout(3600000);
            conn.setRequestProperty("Accept-Charset", DEFUALT_ENCODER);
            conn.setRequestProperty("Charset", ApplicationConfig.INSTANCE.getCharset().name());
            conn.setRequestProperty("Content-Type", CONTENT_TYPE_JSON);
            conn.setRequestProperty("Content-Encoding", ApplicationConfig.INSTANCE.getCharset().name());
            conn.addRequestProperty("ecp_token", token);
            String time = String.valueOf(System.currentTimeMillis());
            String sm4CBCTime = CryptUtil.encodeSM4CBC(null, (String)time);
            conn.addRequestProperty("stime", sm4CBCTime);
            MappUtil.addHeader(conn, headers);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            out = new PrintWriter(new OutputStreamWriter(conn.getOutputStream(), DEFUALT_ENCODER));
            out.print(param);
            out.flush();
            int statusCode = conn.getResponseCode();
            in = statusCode == 200 ? conn.getInputStream() : conn.getErrorStream();
            sb.append(IOUtils.toString((InputStream)in, (Charset)Charset.forName(DEFUALT_ENCODER)));
            in.close();
            if (statusCode != 200) break block14;
            String string = sb.toString();
            Object var21_21 = null;
            StreamUtil.closeWriter(out);
            StreamUtil.closeStream(in);
            if (conn != null) {
                conn.disconnect();
            }
            long costTime = System.currentTimeMillis() - startTime;
            MappUtil.endLog(uuid, url, targetUrl, targetJtApplicationName, costTime);
            return string;
        }
        try {
            try {
                throw new RuntimeException(sb.toString());
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("\u53d1\u9001 POST \u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var21_22 = null;
            StreamUtil.closeWriter(out);
            StreamUtil.closeStream(in);
            if (conn != null) {
                conn.disconnect();
            }
            long costTime = System.currentTimeMillis() - startTime;
            MappUtil.endLog(uuid, url, targetUrl, targetJtApplicationName, costTime);
            throw throwable;
        }
    }

    public static IAsyncResult<String> doGetAsync(String url, IAsyncCallback callBack) {
        Object[] paramers = new Object[]{url};
        return AsyncUtil.invokeByCallback(MappUtil.class, "doGet", callBack, paramers);
    }

    public static IAsyncResult<String> doGetAsync4Jt(String url, String targetJtApplicationName, IAsyncCallback callBack) {
        Object[] paramers = new Object[]{url, targetJtApplicationName};
        return AsyncUtil.invokeByCallback(MappUtil.class, "doGet4Jt", callBack, paramers);
    }

    public static String doGet(String url) {
        return MappUtil.doGet(url, new HashMap<String, String>());
    }

    public static String doGet4Jt(String url, String targetJtApplicationName) {
        return MappUtil.doGet4Jt(url, targetJtApplicationName, new HashMap<String, String>());
    }

    public static String doGet(String url, Map<String, String> headers) {
        String uuid;
        String targetUrl;
        long startTime;
        StringBuilder sb;
        InputStream in;
        java.net.HttpURLConnection conn;
        block14: {
            int index;
            conn = null;
            in = null;
            sb = new StringBuilder();
            startTime = System.currentTimeMillis();
            targetUrl = null;
            uuid = UuidUtil.newUUID();
            String urlString = MappUtil.getMappUrl(url);
            String token = TokenHolder.INSTANCE.getToken();
            if (token == null || token.trim().length() == 0) {
                token = "ecp.mapp";
            }
            urlString = (index = urlString.indexOf("?")) > 0 ? urlString + "&ecp_token=" + token : urlString + "?ecp_token=" + token;
            String pid = TraceHolder.INSTANCE.getId();
            if (pid == null) {
                pid = "null";
            }
            urlString = urlString + "&" + "trice_pid" + "=" + pid + "&ecp.mapp=true";
            try {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.net.www.protocol.http.HttpURLConnection");
                if (clazz != null) {
                    conn = new HttpURLConnection(new URL(urlString), null);
                }
            }
            catch (ClassNotFoundException ex) {
                conn = (java.net.HttpURLConnection)new URL(urlString).openConnection();
            }
            targetUrl = urlString;
            MappUtil.startLog(uuid, url, urlString, null);
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(2000);
            conn.setReadTimeout(3600000);
            conn.setRequestProperty("Accept-Charset", DEFUALT_ENCODER);
            conn.setRequestProperty("Charset", ApplicationConfig.INSTANCE.getCharset().name());
            conn.setRequestProperty("Content-Type", CONTENT_TYPE_JSON);
            conn.addRequestProperty("ecp_token", token);
            String time = String.valueOf(System.currentTimeMillis());
            String sm4CBCTime = CryptUtil.encodeSM4CBC(null, (String)time);
            conn.addRequestProperty("stime", sm4CBCTime);
            String currentMills = "Tim" + System.currentTimeMillis() + "ct";
            conn.setRequestProperty("mapp_send_mills", currentMills);
            MappUtil.addHeader(conn, headers);
            int statusCode = conn.getResponseCode();
            in = statusCode == 200 ? conn.getInputStream() : conn.getErrorStream();
            sb.append(IOUtils.toString((InputStream)in, (Charset)Charset.forName(DEFUALT_ENCODER)));
            in.close();
            if (statusCode != 200) break block14;
            String string = sb.toString();
            Object var19_19 = null;
            StreamUtil.closeStream(in);
            if (conn != null) {
                conn.disconnect();
            }
            long costTime = System.currentTimeMillis() - startTime;
            MappUtil.endLog(uuid, url, targetUrl, null, costTime);
            return string;
        }
        try {
            try {
                throw new RuntimeException(sb.toString());
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("\u53d1\u9001 GET\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            StreamUtil.closeStream(in);
            if (conn != null) {
                conn.disconnect();
            }
            long costTime = System.currentTimeMillis() - startTime;
            MappUtil.endLog(uuid, url, targetUrl, null, costTime);
            throw throwable;
        }
    }

    public static String doGet4Jt(String url, String targetJtApplicationName, Map<String, String> headers) {
        String uuid;
        String targetUrl;
        long startTime;
        StringBuilder sb;
        InputStream in;
        java.net.HttpURLConnection conn;
        block14: {
            int index;
            conn = null;
            in = null;
            sb = new StringBuilder();
            startTime = System.currentTimeMillis();
            targetUrl = null;
            uuid = UuidUtil.newUUID();
            String urlString = "";
            urlString = StringUtil.isNotEmpty(targetJtApplicationName) ? MappUtil.getMappUrl(url, targetJtApplicationName) : MappUtil.getMappUrl(url);
            String token = TokenHolder.INSTANCE.getToken();
            if (token == null || token.trim().length() == 0) {
                token = "ecp.mapp";
            }
            urlString = (index = urlString.indexOf("?")) > 0 ? urlString + "&ecp_token=" + token : urlString + "?ecp_token=" + token;
            String pid = TraceHolder.INSTANCE.getId();
            if (pid == null) {
                pid = "null";
            }
            urlString = urlString + "&" + "trice_pid" + "=" + pid + "&ecp.mapp=true";
            try {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.net.www.protocol.http.HttpURLConnection");
                if (clazz != null) {
                    conn = new HttpURLConnection(new URL(urlString), null);
                }
            }
            catch (ClassNotFoundException ex) {
                conn = (java.net.HttpURLConnection)new URL(urlString).openConnection();
            }
            targetUrl = urlString;
            MappUtil.startLog(uuid, url, urlString, targetJtApplicationName);
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(2000);
            conn.setReadTimeout(3600000);
            conn.setRequestProperty("Accept-Charset", DEFUALT_ENCODER);
            conn.setRequestProperty("Charset", ApplicationConfig.INSTANCE.getCharset().name());
            conn.setRequestProperty("Content-Type", CONTENT_TYPE_JSON);
            conn.addRequestProperty("ecp_token", token);
            String time = String.valueOf(System.currentTimeMillis());
            String sm4CBCTime = CryptUtil.encodeSM4CBC(null, (String)time);
            conn.addRequestProperty("stime", sm4CBCTime);
            String currentMills = "Tim" + System.currentTimeMillis() + "ct";
            conn.setRequestProperty("mapp_send_mills", currentMills);
            MappUtil.addHeader(conn, headers);
            int statusCode = conn.getResponseCode();
            in = statusCode == 200 ? conn.getInputStream() : conn.getErrorStream();
            sb.append(IOUtils.toString((InputStream)in, (Charset)Charset.forName(DEFUALT_ENCODER)));
            in.close();
            if (statusCode != 200) break block14;
            String string = sb.toString();
            Object var20_20 = null;
            StreamUtil.closeStream(in);
            if (conn != null) {
                conn.disconnect();
            }
            long costTime = System.currentTimeMillis() - startTime;
            MappUtil.endLog(uuid, url, targetUrl, targetJtApplicationName, costTime);
            return string;
        }
        try {
            try {
                throw new RuntimeException(sb.toString());
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("\u53d1\u9001 GET\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var20_21 = null;
            StreamUtil.closeStream(in);
            if (conn != null) {
                conn.disconnect();
            }
            long costTime = System.currentTimeMillis() - startTime;
            MappUtil.endLog(uuid, url, targetUrl, targetJtApplicationName, costTime);
            throw throwable;
        }
    }

    public static String getMappUrl(String url) {
        String path = url.toLowerCase();
        String prefix = null;
        if (path.startsWith(HTTP_PREFIX)) {
            path = path.substring(HTTP_PREFIX.length());
            prefix = HTTP_PREFIX;
        } else if (path.startsWith(HTTPS_PREFIX)) {
            path = path.substring(HTTPS_PREFIX.length());
            prefix = HTTPS_PREFIX;
        } else {
            prefix = HTTP_PREFIX;
        }
        try {
            Class cls = ClassUtil.getClass(MAPP_CLIENT_CLASS);
            String vipAddress = (String)ClassUtil.callMethod(cls, "getVipAddress", new Object[]{path});
            Object info = ClassUtil.callMethod(cls, "getIpAndPort", new Object[]{vipAddress});
            if (info == null) {
                return url;
            }
            String[] arr = (String[])info;
            String ipAddress = arr[0];
            String port = arr[1];
            String contextPath = arr[2];
            StringBuilder sb = new StringBuilder(prefix);
            if (url.lastIndexOf(":") > 0) {
                String uri = url.substring(url.lastIndexOf(":"));
                uri = uri.substring(uri.indexOf("/"));
                sb.append(ipAddress).append(":").append(port);
                if (!"/".equals(contextPath)) {
                    sb.append(contextPath);
                }
                sb.append(url);
            } else {
                sb.append(ipAddress).append(":").append(port);
                if (!"/".equals(contextPath)) {
                    sb.append(contextPath);
                }
                sb.append(url);
            }
            return sb.toString();
        }
        catch (Throwable e) {
            return url;
        }
    }

    public static String getMappUrl(String url, String targetJtApplicationName) {
        String path = url.toLowerCase();
        String prefix = null;
        if (path.startsWith(HTTP_PREFIX)) {
            path = path.substring(HTTP_PREFIX.length());
            prefix = HTTP_PREFIX;
        } else if (path.startsWith(HTTPS_PREFIX)) {
            path = path.substring(HTTPS_PREFIX.length());
            prefix = HTTPS_PREFIX;
        } else {
            prefix = HTTP_PREFIX;
        }
        try {
            Class cls = ClassUtil.getClass(MAPP_CLIENT_CLASS);
            String vipAddress = "";
            vipAddress = StringUtil.isNotEmpty(targetJtApplicationName) ? targetJtApplicationName : (String)ClassUtil.callMethod(cls, "getVipAddress", new Object[]{path});
            Object info = ClassUtil.callMethod(cls, "getIpAndPort", new Object[]{vipAddress});
            if (info == null) {
                return url;
            }
            String[] arr = (String[])info;
            String ipAddress = arr[0];
            String port = arr[1];
            String contextPath = arr[2];
            StringBuilder sb = new StringBuilder(prefix);
            if (url.lastIndexOf(":") > 0) {
                String uri = url.substring(url.lastIndexOf(":"));
                uri = uri.substring(uri.indexOf("/"));
                sb.append(ipAddress).append(":").append(port);
                if (!"/".equals(contextPath)) {
                    sb.append(contextPath);
                }
                sb.append(url);
            } else {
                sb.append(ipAddress).append(":").append(port);
                if (!"/".equals(contextPath)) {
                    sb.append(contextPath);
                }
                sb.append(url);
            }
            return sb.toString();
        }
        catch (Throwable e) {
            return url;
        }
    }

    public static String getHostUrl(String vipAddress) {
        String prefix = HTTP_PREFIX;
        try {
            Class cls = ClassUtil.getClass(MAPP_CLIENT_CLASS);
            Object info = ClassUtil.callMethod(cls, "getIpAndPort", new Object[]{vipAddress});
            if (info == null) {
                return null;
            }
            String[] arr = (String[])info;
            String ipAddress = arr[0];
            String port = arr[1];
            String contextPath = arr[2];
            StringBuilder sb = new StringBuilder(HTTP_PREFIX);
            sb.append(ipAddress).append(":").append(port);
            if (!"/".equals(contextPath)) {
                sb.append(contextPath);
            }
            return sb.toString();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String doGet(String beanName, String methodName, Object[] parameters) {
        return MappUtil.doPost(beanName, methodName, parameters);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPost(String beanName, String methodName, Object[] parameters) {
        String result = null;
        long startTime = System.currentTimeMillis();
        String uuid = UuidUtil.newUUID();
        String host = HTTPServiceProxy.getRemoteHost();
        MappUtil.startLog(uuid, null, host, beanName + "#" + methodName);
        long endTime = -1L;
        if (StringUtil.isNotEmptyString(host)) {
            try {
                try {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("\u53d1\u9001doPost\u8bf7\u6c42,\u8bf7\u6c42\u7684\u4e3b\u673a\u540d\u4e3a\u3010" + host + "\u3011\uff0cbeanName\u4e3a\u3010" + beanName + "\u3011\uff0cmethodName\u4e3a\u3010" + methodName + "\u3011");
                    }
                    result = HTTPServiceRequester.send(host, beanName, methodName, parameters);
                }
                catch (Throwable e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error(e.getMessage(), e);
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
                Object var12_8 = null;
            }
            catch (Throwable throwable) {
                Object var12_9 = null;
                endTime = System.currentTimeMillis();
                throw throwable;
            }
            endTime = System.currentTimeMillis();
        }
        if (endTime < 1L) {
            endTime = System.currentTimeMillis();
        }
        MappUtil.endLog(uuid, null, host, beanName + "#" + methodName, endTime - startTime);
        return result;
    }

    public static String doPostByVipaddress(String vipAddress, String beanName, String methodName, Object[] parameters) {
        return MappUtil.doPostByVipaddress(null, null, vipAddress, beanName, methodName, parameters);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPostByVipaddress(Integer connentTimeout, Integer readTimeout, String vipAddress, String beanName, String methodName, Object[] parameters) {
        String result = null;
        long startTime = System.currentTimeMillis();
        String uuid = UuidUtil.newUUID();
        String host = MappUtil.getHostUrl(vipAddress);
        if (LOG.isInfoEnabled()) {
            LOG.info("\u53d1\u9001doPost\u8bf7\u6c42,\u8bf7\u6c42\u7684\u4e3b\u673a\u540d\u4e3a\u3010" + host + "\u3011\uff0cbeanName\u4e3a\u3010" + beanName + "\u3011\uff0cmethodName\u4e3a\u3010" + methodName + "\u3011");
        }
        MappUtil.startLog(uuid, vipAddress, host, beanName + "#" + methodName);
        long endTime = -1L;
        if (StringUtil.isNotEmptyString(host)) {
            try {
                try {
                    int realConnectTimeout = MappConst.HTTP_CONNECT_TIMEOUT;
                    if (connentTimeout != null) {
                        realConnectTimeout = connentTimeout;
                    }
                    int realReadTimeout = MappConst.HTTP_READ_TIMEOUT;
                    if (readTimeout != null) {
                        realReadTimeout = readTimeout;
                    }
                    result = HTTPServiceRequester.send4New(realConnectTimeout, realReadTimeout, host, beanName, methodName, parameters);
                }
                catch (Throwable e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error(e.getMessage(), e);
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
                Object var16_14 = null;
            }
            catch (Throwable throwable) {
                Object var16_15 = null;
                endTime = System.currentTimeMillis();
                throw throwable;
            }
            endTime = System.currentTimeMillis();
        }
        if (endTime < 0L) {
            endTime = System.currentTimeMillis();
        }
        MappUtil.endLog(uuid, vipAddress, host, beanName + "#" + methodName, endTime - startTime);
        if (StringUtil.isNull(result)) {
            return null;
        }
        return result;
    }

    public static String getVipAddressByReq(HttpServletRequest httpRequest) {
        String vipAddress = "";
        String pathURI = MappUtil.getURI(httpRequest);
        vipAddress = MappUtil.getVipAddress(pathURI);
        if (StringUtil.isEmpty(vipAddress)) {
            String referer = httpRequest.getHeader("Referer");
            vipAddress = MappUtil.getVipAddress(referer);
        }
        if (StringUtil.isEmpty(vipAddress) && pathURI.toLowerCase().contains(".css")) {
            vipAddress = MappUtil.getVipAddressByCookie(httpRequest);
        }
        return vipAddress;
    }

    public static String getVipAddress(String url) {
        if (StringUtil.isEmpty(url)) {
            return null;
        }
        String vipAddress = MappUtil.getVipAddressByURLParam(url);
        if (StringUtil.isEmpty(vipAddress)) {
            vipAddress = MappUtil.getVipAddressByURLPath(url);
        }
        return vipAddress;
    }

    private static String getVipAddressByURLParam(String url) {
        String vipAddress;
        block12: {
            if (StringUtil.isEmpty(url) || url.indexOf("?") == -1) {
                return null;
            }
            vipAddress = "";
            String urlParam = url.substring(url.indexOf("?"));
            if (StringUtil.isNotEmpty(urlParam)) {
                int vipParamIndex = urlParam.indexOf(VIPADDRESS_PARAM);
                if (vipParamIndex > -1) {
                    String[] params;
                    for (String param : params = urlParam.split("&")) {
                        if (!StringUtil.isNotEmpty(param) || (vipParamIndex = param.indexOf(VIPADDRESS_PARAM)) <= -1) continue;
                        vipAddress = param.substring(vipParamIndex + VIPADDRESS_PARAM.length());
                        break;
                    }
                    try {
                        vipAddress = URLDecoder.decode(vipAddress, DEFUALT_ENCODER);
                    }
                    catch (UnsupportedEncodingException e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error("url\u89e3\u5bc6\u5931\u8d25.", e);
                        }
                        break block12;
                    }
                }
                int encodeIndex = urlParam.indexOf("_d=");
                if (encodeIndex > -1) {
                    String encodeParam = urlParam.substring(encodeIndex + "_d=".length());
                    String decodeParam = "";
                    decodeParam = EncodeUtil.decodeString(encodeParam);
                    if (StringUtil.isNotEmpty(decodeParam) && (vipParamIndex = decodeParam.indexOf(VIPADDRESS_PARAM)) > -1) {
                        String[] params;
                        for (String param : params = decodeParam.split("&")) {
                            if (!StringUtil.isNotEmpty(param) || (vipParamIndex = param.indexOf(VIPADDRESS_PARAM)) <= -1) continue;
                            vipAddress = param.substring(vipParamIndex + VIPADDRESS_PARAM.length());
                            break;
                        }
                        try {
                            vipAddress = URLDecoder.decode(vipAddress, DEFUALT_ENCODER);
                        }
                        catch (UnsupportedEncodingException e) {
                            if (!LOG.isErrorEnabled()) break block12;
                            LOG.error("url\u89e3\u5bc6\u5931\u8d25.", e);
                        }
                    }
                }
            }
        }
        return vipAddress;
    }

    private static String getVipAddressByURLPath(String url) {
        if (StringUtil.isEmpty(url)) {
            return null;
        }
        String vipAddress = "";
        int mappIndex = url.indexOf(MAPP_MARK);
        if (mappIndex == -1) {
            return vipAddress;
        }
        String s1 = url.substring(0, mappIndex);
        int i = s1.lastIndexOf("/");
        if (i == -1) {
            return null;
        }
        s1 = s1.substring(i);
        String s2 = url.substring(mappIndex + MAPP_MARK.length(), url.length());
        i = s2.indexOf("/");
        if (i == -1) {
            return null;
        }
        s2 = s2.substring(0, i);
        vipAddress = s1 + MAPP_MARK + s2;
        return vipAddress;
    }

    private static String getVipAddressByCookie(HttpServletRequest httpRequest) {
        String vipAddress = "";
        Cookie[] cookies = httpRequest.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!"m_vipaddress".equals(cookies[i].getName())) continue;
                vipAddress = cookies[i].getValue();
                break;
            }
        }
        return vipAddress;
    }

    private static String getURI(HttpServletRequest httpRequest) {
        String contextPath = httpRequest.getContextPath();
        String uri = "";
        try {
            uri = httpRequest.getRequestURI().substring(contextPath.length());
        }
        catch (Exception e) {
            uri = httpRequest.getServletPath();
        }
        if (StringUtil.isNotEmpty(httpRequest.getQueryString())) {
            uri = uri + "?" + httpRequest.getQueryString();
        }
        return uri;
    }

    public static String getWebContextPathByReq(HttpServletRequest httpRequest) {
        String webContextPath;
        block3: {
            webContextPath = "";
            try {
                Class cls;
                List serverInfo;
                String vipAddress = MappUtil.getVipAddressByReq(httpRequest);
                if (StringUtil.isNotEmptyString(vipAddress) && (serverInfo = (List)ClassUtil.callMethod(cls = ClassUtil.getClass(MAPP_CLIENT_CLASS), "getServieInfos", new Object[]{vipAddress})) != null && !serverInfo.isEmpty()) {
                    webContextPath = String.valueOf(ClassUtil.getAttribute(serverInfo.get(0), "contextPath"));
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error("", e);
            }
        }
        return webContextPath;
    }

    private static void startLog(String uuid, String originalUrl, String targetUrl, String target) {
        if (LOG.isInfoEnabled()) {
            String extMsg = null == target ? "" : ",target=" + target;
            LOG.info("[TrackingLog][CALLREMOTE][MappUtil][action=start,uuid=" + uuid + ",originalUrl=" + originalUrl + ",targetUrl=" + targetUrl + extMsg + "]");
        }
    }

    private static void endLog(String uuid, String originalUrl, String targetUrl, String target, long timecost) {
        if (LOG.isInfoEnabled()) {
            String extMsg = null == target ? "" : ",target=" + target;
            LOG.info("[TrackingLog][CALLREMOTE][MappUtil][action=end,uuid=" + uuid + ",originalUrl=" + originalUrl + ",targetUrl=" + targetUrl + extMsg + ",timecost=" + timecost + "(ms)]");
        }
    }
}

