/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.date.EcpDate;
import com.ygsoft.ecp.service.lob.SerialBlob;
import com.ygsoft.ecp.service.lob.SerialClob;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.exception.CastException;
import com.ygsoft.ecp.service.tool.exception.FindException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConvertUtil
implements IEcpToolLogic {
    private static IEcpLog log = EcpLogFactory.getLog(ConvertUtil.class);
    public static final int UNASSIGNED_NULL = 0;
    public static final int ASSIGNED_NULL = 1;
    public static final int BYTE = 2;
    public static final int SHORT = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int BIGINTEGER = 8;
    public static final int BIGDECIMAL = 10;
    public static final int BOOLEAN = 11;
    public static final int INPUTSTREAM = 12;
    public static final int DATE = 13;
    public static final int TIME = 14;
    public static final int TIMESTAMP = 15;
    public static final int STRING = 16;
    public static final int OBJECT = 17;
    public static final int BYTE_ARRAY = 18;
    public static final int BLOB = 19;
    public static final int CLOB = 20;
    public static final int ENUM = 21;
    public static final String ASSIGNEDNULL_S = "ASSIGNED_NULL";
    public static final String UNASSIGNEDNULL_S = "UNASSIGNED_NULL";
    public static final String BYTETYPE_S = "BYTE";
    public static final String SHORTTYPE_S = "SHORT";
    public static final String INTTYPE_S = "INT";
    public static final String INTEGERTYPE_S = "INTEGER";
    public static final String BIGINTEGERTYPE_S = "BIGINTEGER";
    public static final String LONGTYPE_S = "LONG";
    public static final String FLOATTYPE_S = "FLOAT";
    public static final String DOUBLETYPE_S = "DOUBLE";
    public static final String BIGDECIMALTYPE_S = "BIGDECIMAL";
    public static final String BOOLEANTYPE_S = "BOOLEAN";
    public static final String INPUTSTREAMTYPE_S = "INPUTSTREAM";
    public static final String DATETYPE_S = "DATE";
    public static final String TIMETYPE_S = "TIME";
    public static final String TIMESTAMPTYPE_S = "TIMESTAMP";
    public static final String BYTEARRAYTYPE_S = "[B";
    public static final String STRINGTYPE_S = "STRING";
    public static final String OBJECTTYPE_S = "OBJECT";
    public static final String BLOB_S = "SERIALBLOB";
    public static final String BLOB_P = "BLOB";
    public static final String CLOB_S = "SERIALCLOB";
    public static final String CLOB_P = "CLOB";
    public static final Double ZERODOUBLE = 0.0;
    public static final Float ZEROFLOAT = Float.valueOf(0.0f);
    public static final String ZEROSTRING = "0";
    public static final String FALSESTRING = "false";
    public static final String NOTSUPPORTTYPECAST = "\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u8f6c\u6362";
    public static final char PACKAGESEP = '.';
    public static final BigDecimal ZEROBIGDECIMAL = new BigDecimal(0);
    public static final byte[] EMPTYBYTES = new byte[0];
    public static final char[] EMPTYCHARS = new char[0];
    private static Map<String, String> types = new HashMap<String, String>();
    static Map typeMap;

    private ConvertUtil() {
    }

    public static int getType(Object obj) {
        if (obj == null) {
            return 1;
        }
        Class<?> cls = obj.getClass();
        if (cls.isEnum()) {
            return 21;
        }
        return ConvertUtil.getType(obj.getClass());
    }

    public static String getClassSimpleName(Class cls) {
        String name = cls.getName();
        int index = name.lastIndexOf(46);
        if (index > 0) {
            name = name.substring(index + 1);
        }
        return name;
    }

    public static int getType(Class cls) {
        if (cls == null) {
            return 1;
        }
        if (cls.isEnum()) {
            return 21;
        }
        String typeValue = types.get(ConvertUtil.getClassSimpleName(cls).toUpperCase());
        if (typeValue != null) {
            return Integer.parseInt(typeValue);
        }
        return 17;
    }

    private static void typeProblem(int unexpectedType, int expectedType, boolean getter) {
        throw new CastException("E0208.0009", EcpI18nUtil.localizedString("E0208.0009", NOTSUPPORTTYPECAST));
    }

    public static BigDecimal toBigDecimal(Object object) {
        int type = ConvertUtil.getType(object);
        switch (type) {
            case 21: {
                return new BigDecimal(((Enum)object).ordinal());
            }
            case 11: {
                return new BigDecimal((Boolean)object != false ? 1 : 0);
            }
            case 2: {
                return new BigDecimal(((Byte)object).longValue());
            }
            case 3: {
                return new BigDecimal(((Short)object).longValue());
            }
            case 4: {
                return new BigDecimal(String.valueOf(object));
            }
            case 8: {
                return BigDecimal.valueOf(((BigInteger)object).longValue(), 0);
            }
            case 5: {
                return BigDecimal.valueOf((Long)object, 0);
            }
            case 6: {
                return new BigDecimal(String.valueOf(object));
            }
            case 7: {
                return new BigDecimal(String.valueOf(object));
            }
            case 10: {
                return (BigDecimal)object;
            }
            case 14: {
                return BigDecimal.valueOf(((Time)object).getTime());
            }
            case 13: {
                return BigDecimal.valueOf(((java.util.Date)object).getTime());
            }
            case 15: {
                return BigDecimal.valueOf(((Timestamp)object).getTime());
            }
            case 0: 
            case 1: {
                return new BigDecimal(0);
            }
            case 16: {
                String stringVal = (String)object;
                return stringVal == null || stringVal.length() == 0 ? ZEROBIGDECIMAL : new BigDecimal(stringVal);
            }
        }
        ConvertUtil.typeProblem(type, 10, true);
        return null;
    }

    public static Boolean toBoolean(Object object) {
        int type = ConvertUtil.getType(object);
        switch (type) {
            case 11: {
                return (Boolean)object;
            }
            case 2: {
                return ((Byte)object).longValue() != 0L;
            }
            case 3: {
                return ((Short)object).longValue() != 0L;
            }
            case 4: {
                return (Integer)object != 0;
            }
            case 8: {
                return ((BigInteger)object).intValue() != 0;
            }
            case 5: {
                return (Long)object != 0L;
            }
            case 6: {
                return ((Float)object).compareTo(ZEROFLOAT) != 0;
            }
            case 7: {
                return ((Double)object).compareTo(ZERODOUBLE) != 0;
            }
            case 10: {
                return ((BigDecimal)object).longValue() != 0L;
            }
            case 14: {
                return object != null;
            }
            case 13: {
                return object != null;
            }
            case 15: {
                return object != null;
            }
            case 0: 
            case 1: {
                return Boolean.FALSE;
            }
            case 16: {
                String stringVal = (String)object;
                boolean tmpValue = stringVal == null || stringVal.length() == 0 || ZEROSTRING.equals(stringVal) || FALSESTRING.equalsIgnoreCase(stringVal);
                return !tmpValue;
            }
        }
        ConvertUtil.typeProblem(type, 11, true);
        return Boolean.FALSE;
    }

    public static Byte toByte(Object object) {
        int type = ConvertUtil.getType(object);
        switch (type) {
            case 11: {
                return Integer.valueOf((Boolean)object != false ? 1 : 0).byteValue();
            }
            case 2: {
                return (Byte)object;
            }
            case 3: {
                return ((Short)object).byteValue();
            }
            case 4: {
                return ((Integer)object).byteValue();
            }
            case 8: {
                return ((BigInteger)object).byteValue();
            }
            case 5: {
                return ((Long)object).byteValue();
            }
            case 6: {
                return ((Float)object).byteValue();
            }
            case 7: {
                return ((Double)object).byteValue();
            }
            case 10: {
                return ((BigDecimal)object).byteValue();
            }
            case 14: {
                return Long.valueOf(((Time)object).getTime()).byteValue();
            }
            case 13: {
                return Long.valueOf(((java.util.Date)object).getTime()).byteValue();
            }
            case 15: {
                return Long.valueOf(((Timestamp)object).getTime()).byteValue();
            }
            case 0: 
            case 1: {
                return null;
            }
            case 16: {
                String stringVal = (String)object;
                if (StringUtil.isNotEmptyString(stringVal)) {
                    try {
                        return stringVal.getBytes("UTF-8")[0];
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
        }
        ConvertUtil.typeProblem(type, 2, true);
        return null;
    }

    public static byte[] toByteArray(Object object) {
        return (byte[])object;
    }

    public static java.util.Date toDate(Object value) {
        if (value == null) {
            return null;
        }
        long time = 0L;
        if (value instanceof Timestamp) {
            time = ((Timestamp)value).getTime();
        } else {
            if (value instanceof Time) {
                return (Time)value;
            }
            if (value instanceof java.util.Date) {
                return (java.util.Date)value;
            }
            time = value instanceof Long ? (Long)value : (value instanceof String ? new EcpDate((String)value).toTimestamp().getTime() : ((EcpDate)((Object)value)).toTimestamp().getTime());
        }
        return new java.util.Date(time);
    }

    public static Date toSqlDate(Object value) {
        if (value == null) {
            return null;
        }
        long time = 0L;
        if (value instanceof Timestamp) {
            time = ((Timestamp)value).getTime();
        } else if (value instanceof Time) {
            time = ((Time)value).getTime();
        } else if (value instanceof java.util.Date) {
            time = ((java.util.Date)value).getTime();
        } else if (value instanceof String) {
            try {
                time = new SimpleDateFormat("yyyy-MM-dd").parse((String)value).getTime();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            time = ((EcpDate)((Object)value)).toTimestamp().getTime();
        }
        return new Date(time);
    }

    public static Double toDouble(Object object) {
        int type = ConvertUtil.getType(object);
        switch (type) {
            case 21: {
                return ((Enum)object).ordinal();
            }
            case 11: {
                return (Boolean)object != false ? 1.0 : 0.0;
            }
            case 2: {
                return ((Byte)object).doubleValue();
            }
            case 3: {
                return ((Short)object).doubleValue();
            }
            case 4: {
                return ((Integer)object).doubleValue();
            }
            case 8: {
                return ((BigInteger)object).doubleValue();
            }
            case 5: {
                return ((Long)object).doubleValue();
            }
            case 6: {
                return ((Float)object).doubleValue();
            }
            case 7: {
                return (Double)object;
            }
            case 10: {
                return ((BigDecimal)object).doubleValue();
            }
            case 14: {
                return Long.valueOf(((Time)object).getTime()).doubleValue();
            }
            case 13: {
                return Long.valueOf(((java.util.Date)object).getTime()).doubleValue();
            }
            case 15: {
                return Long.valueOf(((Timestamp)object).getTime()).doubleValue();
            }
            case 0: 
            case 1: {
                return null;
            }
            case 16: {
                String stringVal = (String)object;
                if (StringUtil.isNotEmptyString(stringVal)) {
                    return Double.valueOf(stringVal);
                }
                return null;
            }
        }
        ConvertUtil.typeProblem(type, 7, true);
        return null;
    }

    public static Float toFloat(Object object) {
        int type = ConvertUtil.getType(object);
        switch (type) {
            case 21: {
                return Float.valueOf(((Enum)object).ordinal());
            }
            case 11: {
                return Float.valueOf((Boolean)object != false ? 1.0f : 0.0f);
            }
            case 2: {
                return Float.valueOf(((Byte)object).floatValue());
            }
            case 3: {
                return Float.valueOf(((Short)object).floatValue());
            }
            case 8: {
                return Float.valueOf(((BigInteger)object).floatValue());
            }
            case 4: {
                return Float.valueOf(((Integer)object).floatValue());
            }
            case 5: {
                return Float.valueOf(((Long)object).floatValue());
            }
            case 6: {
                return (Float)object;
            }
            case 7: {
                return Float.valueOf(((Double)object).floatValue());
            }
            case 10: {
                return Float.valueOf(((BigDecimal)object).floatValue());
            }
            case 14: {
                return Float.valueOf(((Time)object).getTime());
            }
            case 13: {
                return Float.valueOf(((java.util.Date)object).getTime());
            }
            case 15: {
                return Float.valueOf(((Timestamp)object).getTime());
            }
            case 0: 
            case 1: {
                return null;
            }
            case 16: {
                String stringVal = (String)object;
                if (StringUtil.isNotEmptyString(stringVal)) {
                    return Float.valueOf(stringVal);
                }
                return null;
            }
        }
        ConvertUtil.typeProblem(type, 6, true);
        return null;
    }

    public static InputStream toInputStream(Object object) {
        return (InputStream)object;
    }

    public static Integer toInteger(Object object) {
        int type = ConvertUtil.getType(object);
        switch (type) {
            case 21: {
                return ((Enum)object).ordinal();
            }
            case 11: {
                return (Boolean)object != false ? 1 : 0;
            }
            case 2: {
                return ((Byte)object).intValue();
            }
            case 3: {
                return ((Short)object).intValue();
            }
            case 4: {
                return (Integer)object;
            }
            case 8: {
                return ((BigInteger)object).intValue();
            }
            case 5: {
                return ((Long)object).intValue();
            }
            case 6: {
                return ((Float)object).intValue();
            }
            case 7: {
                return ((Double)object).intValue();
            }
            case 10: {
                return ((BigDecimal)object).intValue();
            }
            case 14: {
                return (int)((Time)object).getTime();
            }
            case 13: {
                return (int)((java.util.Date)object).getTime();
            }
            case 15: {
                return (int)((Timestamp)object).getTime();
            }
            case 0: 
            case 1: {
                return null;
            }
            case 16: {
                String stringVal = (String)object;
                if (StringUtil.isNotEmptyString(stringVal)) {
                    return Integer.valueOf(stringVal);
                }
                return 0;
            }
        }
        ConvertUtil.typeProblem(type, 4, true);
        return null;
    }

    public static int toInt(Object object) {
        int type = ConvertUtil.getType(object);
        switch (type) {
            case 21: {
                return ((Enum)object).ordinal();
            }
            case 11: {
                return (Boolean)object != false ? 1 : 0;
            }
            case 2: {
                return ((Byte)object).intValue();
            }
            case 3: {
                return ((Short)object).intValue();
            }
            case 4: {
                return (Integer)object;
            }
            case 8: {
                return ((BigInteger)object).intValue();
            }
            case 5: {
                return ((Long)object).intValue();
            }
            case 6: {
                return ((Float)object).intValue();
            }
            case 7: {
                return ((Double)object).intValue();
            }
            case 10: {
                return ((BigDecimal)object).intValue();
            }
            case 14: {
                return (int)((Time)object).getTime();
            }
            case 13: {
                return (int)((java.util.Date)object).getTime();
            }
            case 15: {
                return (int)((Timestamp)object).getTime();
            }
            case 0: 
            case 1: {
                return 0;
            }
            case 16: {
                String stringVal = (String)object;
                if (StringUtil.isEmptyString(stringVal)) {
                    return 0;
                }
                return Integer.parseInt(stringVal);
            }
        }
        if (log.isErrorEnabled()) {
            log.error("can't convert " + object.getClass() + " to int");
        }
        ConvertUtil.typeProblem(type, 4, true);
        return 0;
    }

    public static Long toLong(Object object) {
        int type = ConvertUtil.getType(object);
        switch (type) {
            case 2: {
                return ((Byte)object).longValue();
            }
            case 3: {
                return ((Short)object).longValue();
            }
            case 4: {
                return ((Integer)object).longValue();
            }
            case 8: {
                return ((BigInteger)object).longValue();
            }
            case 5: {
                return (Long)object;
            }
            case 6: {
                return ((Float)object).longValue();
            }
            case 7: {
                return ((Double)object).longValue();
            }
            case 10: {
                return ((BigDecimal)object).longValue();
            }
            case 14: {
                return ((Time)object).getTime();
            }
            case 13: {
                return ((java.util.Date)object).getTime();
            }
            case 15: {
                return ((Timestamp)object).getTime();
            }
            case 0: 
            case 1: {
                return null;
            }
            case 16: {
                String stringVal = (String)object;
                if (StringUtil.isNotEmptyString(stringVal)) {
                    return Long.valueOf(stringVal);
                }
                return null;
            }
        }
        ConvertUtil.typeProblem(type, 5, true);
        return null;
    }

    public static Short toShort(Object object) {
        int type = ConvertUtil.getType(object);
        switch (type) {
            case 2: {
                return ((Byte)object).shortValue();
            }
            case 3: {
                return (Short)object;
            }
            case 4: {
                return ((Integer)object).shortValue();
            }
            case 8: {
                return ((BigInteger)object).shortValue();
            }
            case 5: {
                return ((Long)object).shortValue();
            }
            case 6: {
                return ((Float)object).shortValue();
            }
            case 7: {
                return ((Double)object).shortValue();
            }
            case 10: {
                return ((BigDecimal)object).shortValue();
            }
            case 14: {
                return (short)((Time)object).getTime();
            }
            case 13: {
                return (short)((java.util.Date)object).getTime();
            }
            case 15: {
                return (short)((Timestamp)object).getTime();
            }
            case 0: 
            case 1: {
                return null;
            }
            case 16: {
                String stringVal = (String)object;
                if (StringUtil.isNotEmptyString(stringVal)) {
                    return Short.valueOf(stringVal);
                }
                return null;
            }
        }
        ConvertUtil.typeProblem(type, 5, true);
        return null;
    }

    public static String toString(Object object) {
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }

    public static Timestamp toTimestamp(Object value) {
        if (value == null) {
            return null;
        }
        long time = 0L;
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        time = value instanceof Time ? ((Time)value).getTime() : (value instanceof java.util.Date ? ((java.util.Date)value).getTime() : (value instanceof String ? new EcpDate((String)value).toTimestamp().getTime() : ((EcpDate)((Object)value)).toTimestamp().getTime()));
        return new Timestamp(time);
    }

    public static EcpDate toEcpDate(Object value) {
        if (value == null) {
            return null;
        }
        EcpDate time = null;
        if (value instanceof Timestamp) {
            return new EcpDate((Timestamp)value);
        }
        time = value instanceof java.util.Date ? new EcpDate((java.util.Date)value) : (value instanceof Time ? new EcpDate((Time)value) : (value instanceof String ? new EcpDate((String)value) : (EcpDate)((Object)value)));
        return time;
    }

    public static Time toTime(Object value) {
        if (value == null) {
            return null;
        }
        long time = 0L;
        if (value instanceof Timestamp) {
            time = ((Timestamp)value).getTime();
        } else if (value instanceof java.util.Date) {
            time = ((java.util.Date)value).getTime();
        } else {
            if (value instanceof Time) {
                return (Time)value;
            }
            time = value instanceof String ? new EcpDate((String)value).toTimestamp().getTime() : ((EcpDate)((Object)value)).toTimestamp().getTime();
        }
        return new Time(time);
    }

    public static SerialBlob toBlob(Object value) {
        SerialBlob blob;
        try {
            if (value instanceof SerialBlob) {
                return (SerialBlob)value;
            }
            if (value instanceof byte[]) {
                return new SerialBlob((byte[])value);
            }
            if (value instanceof Blob) {
                return new SerialBlob((Blob)value);
            }
            if (value instanceof InputStream) {
                InputStream stream = (InputStream)value;
                byte[] b = new byte[stream.available()];
                stream.read(b);
                SerialBlob blob2 = new SerialBlob(b);
                return blob2;
            }
            blob = new SerialBlob(EMPTYBYTES);
            blob.setAsString(ConvertUtil.toString(value));
        }
        catch (Exception e) {
            throw new CastException("E0208.0009", EcpI18nUtil.localizedString("E0208.0009", "toBlob\u5931\u8d25"), e, new Object[0]);
        }
        return blob;
    }

    public static SerialClob toClob(Object value) {
        SerialClob clob;
        try {
            if (value instanceof SerialClob) {
                return (SerialClob)value;
            }
            if (value instanceof Clob) {
                SerialClob clob2 = new SerialClob((Clob)value);
                return clob2;
            }
            clob = new SerialClob(EMPTYCHARS);
            clob.setAsString(ConvertUtil.toString(value));
        }
        catch (Exception e) {
            throw new CastException("E0208.0009", EcpI18nUtil.localizedString("E0208.0009", "toBlob\u5931\u8d25"));
        }
        return clob;
    }

    public static <T> T toEnum(Object obj, Class<T> clazz) {
        try {
            if (obj instanceof String) {
                String name = (String)obj;
                if (name.length() == 0) {
                    return null;
                }
                return Enum.valueOf(clazz, name);
            }
            if (obj instanceof Number) {
                Object[] values;
                int ordinal = ((Number)obj).intValue();
                Method method = clazz.getMethod("values", new Class[0]);
                for (Object value : values = (Object[])method.invoke(null, new Object[0])) {
                    Enum e = (Enum)value;
                    if (e.ordinal() != ordinal) continue;
                    return (T)e;
                }
            }
        }
        catch (Exception ex) {
            throw new CastException("E0208.0009", EcpI18nUtil.localizedString("E0208.0009", "can not cast to : {0}", clazz.getName()), ex, new Object[0]);
        }
        throw new CastException("E0208.0009", EcpI18nUtil.localizedString("E0208.0009", "can not cast to : {0}", clazz.getName()));
    }

    public static Object toClassObject(Object instance, Class targetClass) {
        if (instance == null) {
            if (targetClass.isPrimitive()) {
                return ClassUtil.getPrimitiveTypeDefaultObject(targetClass);
            }
            return null;
        }
        Class<?> srcClass = instance.getClass();
        if (srcClass == targetClass) {
            return instance;
        }
        if (targetClass == Class.class && instance instanceof String) {
            try {
                return Class.forName(ConvertUtil.toString(instance));
            }
            catch (ClassNotFoundException e) {
                throw new FindException("E0208.0023", EcpI18nUtil.localizedString("E0208.0023", "\u7c7b\u627e\u4e0d\u5230"), e, new Object[0]);
            }
        }
        int type = ConvertUtil.getType(targetClass);
        switch (type) {
            case 21: {
                return ConvertUtil.toEnum(instance, targetClass);
            }
            case 4: {
                return ConvertUtil.toInteger(instance);
            }
            case 2: {
                return ConvertUtil.toByte(instance);
            }
            case 3: {
                return ConvertUtil.toShort(instance);
            }
            case 6: {
                return ConvertUtil.toFloat(instance);
            }
            case 7: {
                return ConvertUtil.toDouble(instance);
            }
            case 5: {
                return ConvertUtil.toLong(instance);
            }
            case 10: {
                return ConvertUtil.toBigDecimal(instance);
            }
            case 11: {
                return ConvertUtil.toBoolean(instance);
            }
            case 16: {
                return ConvertUtil.toString(instance);
            }
            case 14: {
                return ConvertUtil.toTime(instance);
            }
            case 13: {
                return ConvertUtil.toDate(instance);
            }
            case 15: {
                return ConvertUtil.toTimestamp(instance);
            }
            case 18: {
                return ConvertUtil.toByteArray(instance);
            }
            case 17: {
                return instance;
            }
            case 12: {
                return ConvertUtil.toInputStream(instance);
            }
            case 19: {
                return ConvertUtil.toBlob(instance);
            }
            case 20: {
                return ConvertUtil.toClob(instance);
            }
        }
        return instance;
    }

    public static Class sqlTypeToJavaType(int sqlType) {
        Class result = null;
        switch (sqlType) {
            case 12: {
                result = String.class;
                break;
            }
            case 1: {
                result = String.class;
                break;
            }
            case -5: {
                result = BigInteger.class;
                break;
            }
            case 2004: {
                result = SerialBlob.class;
                break;
            }
            case 2005: {
                result = SerialClob.class;
                break;
            }
            case 16: {
                result = Boolean.class;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                result = BigDecimal.class;
                break;
            }
            case 4: {
                result = Integer.class;
                break;
            }
            case 91: {
                result = java.util.Date.class;
                break;
            }
            case 92: {
                result = Time.class;
                break;
            }
            case 93: {
                result = Timestamp.class;
                break;
            }
            default: {
                result = String.class;
            }
        }
        return result;
    }

    public static String getObjectToString(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> cls = object.getClass();
        if (cls == Short.TYPE || cls == Short.class || cls == Integer.TYPE || cls == Integer.class) {
            return String.valueOf(object);
        }
        if (cls == Long.TYPE || cls == Long.class || cls == Double.TYPE || cls == Double.class) {
            return String.valueOf(object);
        }
        if (cls == Float.TYPE || cls == Float.class || cls == BigDecimal.class) {
            return String.valueOf(object);
        }
        if (cls == BigInteger.class || cls == Boolean.TYPE || cls == Boolean.class) {
            return String.valueOf(object);
        }
        if (cls == Byte.TYPE || cls == Byte.class || cls == String.class) {
            return String.valueOf(object);
        }
        if (cls == java.util.Date.class) {
            return String.valueOf(((java.util.Date)object).getTime());
        }
        if (cls == Date.class) {
            return String.valueOf(((Date)object).getTime());
        }
        if (cls == Timestamp.class) {
            return String.valueOf(((Timestamp)object).getTime());
        }
        return null;
    }

    public static Object getObject(String type, String value) {
        if (StringUtil.isNotEmptyString(type)) {
            if (Boolean.class.getName().toUpperCase().equals(type.toUpperCase())) {
                return Boolean.valueOf(value);
            }
            if (Integer.class.getName().toUpperCase().equals(type.toUpperCase())) {
                return Integer.valueOf(value);
            }
            if (BigDecimal.class.getName().toUpperCase().equals(type.toUpperCase())) {
                return new BigDecimal(value);
            }
            if (java.util.Date.class.getName().toUpperCase().equals(type.toUpperCase())) {
                return new java.util.Date(value);
            }
            if (Date.class.getName().toUpperCase().equals(type.toUpperCase())) {
                return new Date(new java.util.Date(value).getTime());
            }
            if (Timestamp.class.getName().toUpperCase().equals(type.toUpperCase())) {
                return Timestamp.valueOf(value);
            }
            if (String.class.getName().toUpperCase().equals(type.toUpperCase())) {
                return value;
            }
        }
        return null;
    }

    public static boolean checkComparable(Object object) {
        return object != null && Comparable.class.isAssignableFrom(object.getClass());
    }

    public static boolean checkCollection(Object object) {
        return object != null && Collection.class.isAssignableFrom(object.getClass());
    }

    public static int javaTypeToSqlType(Class cls) {
        if (cls.isEnum()) {
            return 4;
        }
        Integer result = (Integer)typeMap.get(cls);
        if (result == null) {
            return 12;
        }
        return result;
    }

    public static <T> T mapToObject(Map<String, Object> map, Class<T> beanClass) {
        if (map == null) {
            return null;
        }
        T obj = null;
        try {
            obj = beanClass.newInstance();
            Class clazz = ClassUtil.getClass("org.apache.commons.beanutils.BeanUtils");
            ClassUtil.callMethod(clazz, "populate", new Object[]{obj, map});
        }
        catch (Throwable e) {
            throw new CastException("E0208.0009", EcpI18nUtil.localizedString("E0208.0009", "can not cast to : {0}", beanClass.getName()));
        }
        return obj;
    }

    public static Map<?, ?> objectToMap(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            Class clazz = com.ygsoft.ecp.framework.util.ClassUtil.getClass((String)"org.apache.commons.beanutils.BeanMap");
            return (Map)clazz.getConstructor(Object.class).newInstance(obj);
        }
        catch (Throwable e) {
            throw new CastException("E0208.0009", EcpI18nUtil.localizedString("E0208.0009", "can not cast to : {0}", Map.class.getName()));
        }
    }

    static {
        types.put(BIGDECIMALTYPE_S, String.valueOf(10));
        types.put(BOOLEANTYPE_S, String.valueOf(11));
        types.put(BYTEARRAYTYPE_S, String.valueOf(18));
        types.put(BYTETYPE_S, String.valueOf(2));
        types.put(DATETYPE_S, String.valueOf(13));
        types.put(DOUBLETYPE_S, String.valueOf(7));
        types.put(FLOATTYPE_S, String.valueOf(6));
        types.put(INPUTSTREAMTYPE_S, String.valueOf(12));
        types.put(INTTYPE_S, String.valueOf(4));
        types.put(INTEGERTYPE_S, String.valueOf(4));
        types.put(BIGINTEGERTYPE_S, String.valueOf(8));
        types.put(LONGTYPE_S, String.valueOf(5));
        types.put(OBJECTTYPE_S, String.valueOf(17));
        types.put(SHORTTYPE_S, String.valueOf(3));
        types.put(STRINGTYPE_S, String.valueOf(16));
        types.put(TIMESTAMPTYPE_S, String.valueOf(15));
        types.put(TIMETYPE_S, String.valueOf(14));
        types.put(BLOB_S, String.valueOf(19));
        types.put(BLOB_P, String.valueOf(19));
        types.put(CLOB_S, String.valueOf(20));
        types.put(CLOB_P, String.valueOf(20));
        typeMap = new HashMap();
        typeMap.put(String.class, 12);
        typeMap.put(BigInteger.class, -5);
        typeMap.put(SerialBlob.class, 2004);
        typeMap.put(SerialClob.class, 2005);
        typeMap.put(Boolean.class, 16);
        typeMap.put(Boolean.TYPE, 16);
        Integer number = 2;
        typeMap.put(Float.class, number);
        typeMap.put(Float.TYPE, number);
        typeMap.put(Double.class, number);
        typeMap.put(Double.TYPE, number);
        typeMap.put(BigDecimal.class, number);
        typeMap.put(Long.TYPE, number);
        typeMap.put(Long.class, number);
        typeMap.put(Integer.class, 4);
        typeMap.put(Integer.TYPE, 4);
        typeMap.put(Date.class, 91);
        typeMap.put(java.util.Date.class, 91);
        typeMap.put(EcpDate.class, 93);
        typeMap.put(Time.class, 92);
        typeMap.put(Timestamp.class, 93);
    }
}

