/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.register;

import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.register.AbstractGapOsgiRegister;
import com.ygsoft.ecp.service.register.OSGIExtensionRegistryFactory;
import com.ygsoft.ecp.service.register.RegisterException;
import com.ygsoft.necp.eclipse.core.runtime.IConfigurationElement;
import com.ygsoft.necp.eclipse.core.runtime.IExtension;
import com.ygsoft.necp.eclipse.core.runtime.IExtensionPoint;
import com.ygsoft.necp.eclipse.core.runtime.IExtensionRegistry;
import com.ygsoft.necp.eclipse.core.runtime.IRegistryChangeListener;
import com.ygsoft.necp.eclipse.core.runtime.RegistryFactory;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.osgi.framework.BundleContext;

public final class ExtensionRegisterUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ExtensionRegisterUtil.class);
    private static final String NOTSUPPORTT_TYPE = "\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b\uff0c\u53ea\u652f\u6301nt,String,boolean\u4e09\u79cd\u7c7b\u578b\u3002";
    private static final String BUNDLE_ATTR = "bundle";
    private static final String CONFIG_ATTR = "configurationElement";

    private ExtensionRegisterUtil() {
    }

    private static List getInstancePropertyMap(Class cls) {
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>();
        try {
            BeanInfo bi = Introspector.getBeanInfo(cls);
            PropertyDescriptor[] ps = bi.getPropertyDescriptors();
            for (int i = 0; i < ps.length; ++i) {
                list.add(ps[i]);
            }
            return list;
        }
        catch (IntrospectionException introspectionException) {
            return list;
        }
    }

    private static Object typeConvert(Class cls, String value) {
        Object result = null;
        if (String.class.isAssignableFrom(cls)) {
            result = value;
        } else if (Integer.TYPE.isAssignableFrom(cls)) {
            result = Integer.parseInt(value);
        } else if (Boolean.TYPE.isAssignableFrom(cls)) {
            result = Boolean.parseBoolean(value);
        } else {
            throw new RuntimeException(NOTSUPPORTT_TYPE);
        }
        return result;
    }

    static Object createObjectFromConfigElement(BundleContext bundleContext, Class cls, IConfigurationElement configElement) {
        try {
            Object obj = cls.newInstance();
            List propList = ExtensionRegisterUtil.getInstancePropertyMap(cls);
            Iterator it = propList.iterator();
            PropertyDescriptor pd = null;
            Method method = null;
            String name = null;
            String value = null;
            Object bundle = null;
            while (it.hasNext()) {
                pd = (PropertyDescriptor)it.next();
                method = pd.getWriteMethod();
                if (method == null || BUNDLE_ATTR.equals(name = pd.getName())) continue;
                if (CONFIG_ATTR.equals(name)) {
                    method.invoke(obj, configElement);
                    continue;
                }
                value = configElement.getAttribute(name);
                if (value == null) continue;
                method.invoke(obj, ExtensionRegisterUtil.typeConvert(pd.getPropertyType(), value));
            }
            return obj;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                StringBuilder builder = new StringBuilder();
                if (configElement != null) {
                    String[] attrs = configElement.getAttributeNames();
                    for (int i = 0; i < attrs.length; ++i) {
                        builder.append(';');
                        builder.append(attrs[i] + "=" + configElement.getAttribute(attrs[i]));
                    }
                }
                LOG.error("\u52a0\u8f7d\u6269\u5c55\u70b9\u5f02\u5e38:" + e.getMessage() + ",cls=" + cls.getName() + ",\r\nconfigElement=" + builder.toString(), e);
            }
            return null;
        }
    }

    static Object[] createObjectFromConfigElements(BundleContext bundleContext, Class cls, IConfigurationElement[] configElements) {
        if (configElements == null) {
            return null;
        }
        try {
            ArrayList<Object> objects = new ArrayList<Object>(configElements.length);
            for (int i = 0; i < configElements.length; ++i) {
                Object object = ExtensionRegisterUtil.createObjectFromConfigElement(bundleContext, cls, configElements[i]);
                if (object == null) continue;
                objects.add(object);
            }
            return objects.toArray();
        }
        catch (Exception e) {
            throw new RegisterException(e);
        }
    }

    public static Object[] getExtensions(String extensionName, Class elementType) {
        return ExtensionRegisterUtil.getExtensions(null, null, extensionName, elementType);
    }

    public static Object[] getExtensions(IExtensionRegistry registry, BundleContext bundleContext, String extensionName, Class elementType) {
        IExtensionPoint exp = null;
        exp = registry == null ? OSGIExtensionRegistryFactory.getRegistry().getExtensionPoint(extensionName) : registry.getExtensionPoint(extensionName);
        if (exp != null) {
            IExtension[] es = exp.getExtensions();
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < es.length; ++i) {
                Object[] items = ExtensionRegisterUtil.createObjectFromConfigElements(bundleContext, elementType, es[i].getConfigurationElements());
                list.addAll(Arrays.asList(items));
            }
            return list.toArray((Object[])Array.newInstance(elementType, 0));
        }
        return (Object[])Array.newInstance(elementType, 0);
    }

    public static void registerChangeListener(IExtensionRegistry registry, IRegistryChangeListener changeListener, String namespace) {
        if (namespace == null) {
            registry.addRegistryChangeListener(changeListener);
        } else {
            registry.addRegistryChangeListener(changeListener, namespace);
        }
    }

    public static void removeRegisterChangeListener(IExtensionRegistry registry, IRegistryChangeListener changeListener) {
        registry.removeRegistryChangeListener(changeListener);
    }

    public static Object[] getExtensions(BundleContext bundleContext, String extensionName, Class elementType) {
        return ExtensionRegisterUtil.getExtensions(RegistryFactory.getRegistry(), bundleContext, extensionName, elementType);
    }

    public static void registerChangeListener(IRegistryChangeListener changeListener, String namespace) {
        ExtensionRegisterUtil.registerChangeListener(RegistryFactory.getRegistry(), changeListener, namespace);
    }

    public static void removeRegisterChangeListener(IRegistryChangeListener changeListener) {
        ExtensionRegisterUtil.removeRegisterChangeListener(RegistryFactory.getRegistry(), changeListener);
    }

    public static void removeRegisterChangeListener(AbstractGapOsgiRegister changeListener) {
        ExtensionRegisterUtil.removeRegisterChangeListener(RegistryFactory.getRegistry(), changeListener);
    }
}

