/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.log;

import com.ygsoft.ecp.service.async.ClassUtil;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.XtcsUtil;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogThreadUtil {
    private static Map<String, Object> map = new ConcurrentHashMap<String, Object>();
    private static Map<String, Object> rootContextMap = new ConcurrentHashMap<String, Object>();

    private LogThreadUtil() {
    }

    public static void addThreadInfo(String context) {
        Thread t = Thread.currentThread();
        long tid = t.getId();
        if (context != null) {
            map.put(String.valueOf(tid), context);
        }
    }

    public static void clearThreadInfo() {
        Thread t = Thread.currentThread();
        long tid = t.getId();
        map.remove(String.valueOf(tid));
    }

    public static String evalLayerCode() {
        if (XtcsUtil.isMultiLevelDeployMode()) {
            return "66";
        }
        Thread t = Thread.currentThread();
        long tid = t.getId();
        String rootInterfaceName = null;
        rootInterfaceName = String.valueOf(map.get(String.valueOf(tid)));
        Object rootContext = LogThreadUtil.getRootContext(rootInterfaceName);
        if (rootContext == null) {
            return "0";
        }
        long flag = 0L;
        long layer = 0L;
        StackTraceElement[] traces = t.getStackTrace();
        for (int i = traces.length - 1; i >= 3; --i) {
            StackTraceElement trace = traces[i];
            String className = trace.getClassName();
            if (className.equals(rootContext.getClass().getName())) {
                flag = 1L;
            }
            if (flag != 1L || className.indexOf("com.ygsoft.") == -1) continue;
            ++layer;
        }
        return String.valueOf(layer);
    }

    private static Object getRootContext(String rootInterfaceName) {
        if (rootInterfaceName == null || rootInterfaceName.length() == 0) {
            return null;
        }
        Object rootContext = rootContextMap.get(rootInterfaceName);
        if (rootContext != null) {
            return rootContext;
        }
        try {
            Object proxy = OSGiUtil.getService(rootInterfaceName);
            if (proxy == null) {
                return null;
            }
            Class<?> cls = proxy.getClass().getSuperclass();
            Field h = ClassUtil.getField(cls, "h");
            if (h != null) {
                h.setAccessible(true);
                AopProxy aopProxy = (AopProxy)h.get(proxy);
                Field advised = ClassUtil.getField(aopProxy.getClass(), "advised");
                if (advised != null) {
                    advised.setAccessible(true);
                    rootContext = ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
                }
            }
            if (rootContext != null) {
                rootContextMap.put(rootInterfaceName, rootContext);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rootContext;
    }

    public static Map<String, Object> getMap() {
        return map;
    }
}

