/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.log;

import com.ygsoft.ecp.service.cons.NumberConst;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.log.ILogSecReplay;
import com.ygsoft.ecp.service.tool.DBUitl;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogSecReplayFactory
implements ILogSecReplay {
    private DataSource dataSource;
    public static final ILogSecReplay INSTANCE = new LogSecReplayFactory();
    private static final IEcpLog LOG = EcpLogFactory.getSystemLog(LogSecReplayFactory.class);
    private static final String ADD_SQL = "INSERT INTO {0}ECP_SEC_REPLAY_CM(CM,HO) VALUES(?, TO_NUMBER(TO_CHAR(SYSDATE,''HH24'')))";
    private static final String ISEXIST_SQL = "SELECT CM FROM {0}ECP_SEC_REPLAY_CM WHERE HO IN (?, ?, ?) AND CM = ?";
    private static final String CLEAR_SQL = "ALTER TABLE {0}ECP_SEC_REPLAY_CM TRUNCATE PARTITION P{1}";

    private LogSecReplayFactory() {
    }

    private String getSchema() {
        try {
            return DBUitl.getShareSchema() + ".";
        }
        catch (Throwable ex) {
            return "";
        }
    }

    private Connection getConnection() {
        if (this.dataSource == null) {
            this.dataSource = OSGiUtil.getService(DataSource.class);
        }
        if (this.dataSource == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("\u6570\u636e\u6e90\u8fd8\u672a\u53d1\u5e03!");
            }
            return null;
        }
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new UnsupportedOperationException("\u83b7\u53d6\u6570\u636e\u8fde\u63a5\u5931\u8d25!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(String cm) {
        boolean bl;
        PreparedStatement pst;
        Connection conn;
        block5: {
            conn = null;
            pst = null;
            conn = this.getConnection();
            if (conn != null) break block5;
            boolean bl2 = false;
            Object var7_7 = null;
            DBUitl.closeConnStatementResultSet(conn, pst, null);
            return bl2;
        }
        try {
            String sql = MessageFormat.format(ADD_SQL, this.getSchema());
            pst = conn.prepareStatement(sql);
            pst.setString(NumberConst.ONE, cm);
            pst.executeUpdate();
            bl = true;
            Object var7_8 = null;
        }
        catch (Exception ex) {
            boolean bl3;
            try {
                LOG.info("\u8ffd\u52a0\u6570\u636e\u53d1\u751f\u5f02\u5e38" + ex.getMessage());
                bl3 = false;
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                DBUitl.closeConnStatementResultSet(conn, pst, null);
                throw throwable;
            }
            DBUitl.closeConnStatementResultSet(conn, pst, null);
            return bl3;
        }
        DBUitl.closeConnStatementResultSet(conn, pst, null);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clear() {
        boolean bl;
        PreparedStatement pst;
        Connection conn;
        block5: {
            conn = null;
            pst = null;
            conn = this.getConnection();
            if (conn != null) break block5;
            boolean bl2 = false;
            Object var9_6 = null;
            DBUitl.closeConnStatementResultSet(conn, pst, null);
            return bl2;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date(System.currentTimeMillis()));
            int clearHour = calendar.get(11);
            clearHour = 0 == clearHour ? 22 : (1 == clearHour ? 23 : (clearHour -= 2));
            String partHour = "";
            partHour = clearHour < 10 ? "0" + String.valueOf(clearHour) : String.valueOf(clearHour);
            String sql = MessageFormat.format(CLEAR_SQL, this.getSchema(), partHour);
            pst = conn.prepareStatement(sql);
            pst.execute();
            bl = true;
            Object var9_7 = null;
        }
        catch (Exception ex) {
            boolean bl3;
            try {
                LOG.info("\u5220\u9664\u6570\u636e\u5206\u533a\u53d1\u751f\u5f02\u5e38" + ex.getMessage());
                bl3 = false;
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                DBUitl.closeConnStatementResultSet(conn, pst, null);
                throw throwable;
            }
            DBUitl.closeConnStatementResultSet(conn, pst, null);
            return bl3;
        }
        DBUitl.closeConnStatementResultSet(conn, pst, null);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExist(String cm) {
        boolean bl;
        ResultSet rs;
        PreparedStatement pst;
        Connection conn;
        block5: {
            conn = null;
            pst = null;
            rs = null;
            conn = this.getConnection();
            if (conn != null) break block5;
            boolean bl2 = false;
            Object var12_8 = null;
            DBUitl.closeConnStatementResultSet(conn, pst, rs);
            return bl2;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date(System.currentTimeMillis()));
            int currentHour = calendar.get(11);
            int lastHour = currentHour - 1 < 0 ? 23 : currentHour - 1;
            int nextHour = currentHour == 23 ? 0 : currentHour + 1;
            String sql = MessageFormat.format(ISEXIST_SQL, this.getSchema());
            pst = conn.prepareStatement(sql);
            pst.setInt(NumberConst.ONE, currentHour);
            pst.setInt(NumberConst.TWO, lastHour);
            pst.setInt(NumberConst.THREE, nextHour);
            pst.setString(NumberConst.FOUR, cm);
            rs = pst.executeQuery();
            bl = rs.next();
            Object var12_9 = null;
        }
        catch (Exception ex) {
            boolean bl3;
            try {
                LOG.info("\u5224\u65ad\u6570\u636e\u662f\u5426\u5b58\u5728\u53d1\u751f\u5f02\u5e38" + ex.getMessage());
                bl3 = false;
                Object var12_10 = null;
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                DBUitl.closeConnStatementResultSet(conn, pst, rs);
                throw throwable;
            }
            DBUitl.closeConnStatementResultSet(conn, pst, rs);
            return bl3;
        }
        DBUitl.closeConnStatementResultSet(conn, pst, rs);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Set<String> cms) {
        boolean bl;
        PreparedStatement pst;
        Connection conn;
        block7: {
            if (cms == null || cms.size() == 0) {
                return false;
            }
            conn = null;
            pst = null;
            conn = this.getConnection();
            if (conn != null) break block7;
            boolean bl2 = false;
            Object var9_7 = null;
            DBUitl.closeConnStatementResultSet(conn, pst, null);
            return bl2;
        }
        try {
            String sql = MessageFormat.format(ADD_SQL, this.getSchema());
            pst = conn.prepareStatement(sql);
            int size = 0;
            for (String cm : cms) {
                pst.setString(NumberConst.ONE, cm);
                pst.addBatch();
                if (++size % 30 != 0) continue;
                pst.executeBatch();
            }
            pst.executeBatch();
            bl = true;
            Object var9_8 = null;
        }
        catch (Exception ex) {
            boolean bl3;
            try {
                LOG.info("\u6279\u91cf\u8ffd\u52a0\u6570\u636e\u53d1\u751f\u5f02\u5e38" + ex.getMessage());
                bl3 = false;
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                DBUitl.closeConnStatementResultSet(conn, pst, null);
                throw throwable;
            }
            DBUitl.closeConnStatementResultSet(conn, pst, null);
            return bl3;
        }
        DBUitl.closeConnStatementResultSet(conn, pst, null);
        return bl;
    }
}

