/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor;

import java.text.MessageFormat;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private final String prefix;
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final boolean isDaemon;
    private final Thread.UncaughtExceptionHandler handler;

    public NamedThreadFactory(String prefix, boolean isDaemon) {
        this(prefix, null, isDaemon);
    }

    public NamedThreadFactory(String prefix, ThreadGroup threadGroup, boolean isDaemon) {
        this(prefix, threadGroup, isDaemon, null);
    }

    public NamedThreadFactory(String prefix, ThreadGroup threadGroup, boolean isDaemon, Thread.UncaughtExceptionHandler handler) {
        String string = this.prefix = prefix == null || prefix.trim().length() == 0 ? "tianqing" : prefix;
        if (null == threadGroup) {
            SecurityManager s = System.getSecurityManager();
            threadGroup = null != s ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }
        this.group = threadGroup;
        this.isDaemon = isDaemon;
        this.handler = handler;
    }

    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, MessageFormat.format("{}{}", this.prefix, this.threadNumber.getAndIncrement()));
        if (!t.isDaemon()) {
            if (this.isDaemon) {
                t.setDaemon(true);
            }
        } else if (!this.isDaemon) {
            t.setDaemon(false);
        }
        if (null != this.handler) {
            t.setUncaughtExceptionHandler(this.handler);
        }
        if (5 != t.getPriority()) {
            t.setPriority(5);
        }
        return t;
    }
}

