/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.async;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang.StringUtils;

public class FileUtil {
    public static void renameFile(String filePath, String newFileName) {
        FileUtil.checkStringParams(new String[]{"filePath", "newFileName"}, new String[]{filePath, newFileName});
        File file = new File(filePath);
        FileUtil.checkFile(file);
        File destFile = new File(file.getParent(), newFileName);
        file.renameTo(destFile);
    }

    public static String[] listFilesByFilter(String dirPath, String ignoreFileSuffixes) {
        FileUtil.checkStringParams(new String[]{"dirPath"}, new String[]{dirPath});
        File dir = new File(dirPath);
        FileUtil.checkDir(dir);
        return dir.list((FilenameFilter)FileUtil.createFileFilter(ignoreFileSuffixes));
    }

    public static void smartCopyFile(String srcFilePath, String destPath) {
        FileUtil.checkStringParams(new String[]{"srcFilePath", "destPath"}, new String[]{srcFilePath, destPath});
        boolean destIsFile = false;
        File destFile = new File(destPath);
        try {
            FileUtil.checkFile(destFile);
            destIsFile = true;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (destIsFile) {
            FileUtil.copyFile(srcFilePath, destPath);
        } else {
            FileUtil.copyFileToDir(srcFilePath, destPath);
        }
    }

    public static void copyFile(String srcFilePath, String destFilePath) {
        FileUtil.checkStringParams(new String[]{"srcFilePath", "destFilePath"}, new String[]{srcFilePath, destFilePath});
        File srcFile = new File(srcFilePath);
        FileUtil.checkFile(srcFile);
        File destFile = new File(destFilePath);
        FileUtil.createFile(destFile);
        try {
            FileUtils.copyFile((File)srcFile, (File)destFile);
        }
        catch (IOException e) {
            throw new RuntimeException("24000006", e);
        }
    }

    public static void copyFileToDir(String srcFilePath, String destDirPath) {
        FileUtil.checkStringParams(new String[]{"srcFilePath", "destDirPath"}, new String[]{srcFilePath, destDirPath});
        File srcFile = new File(srcFilePath);
        FileUtil.checkFile(srcFile);
        File destDir = new File(destDirPath);
        FileUtil.mkDirs(destDir);
        try {
            FileUtils.copyFileToDirectory((File)srcFile, (File)destDir);
        }
        catch (IOException e) {
            throw new RuntimeException("24000006", e);
        }
    }

    public static void copyFilesByFilter(String srcDirPath, String destDirPath, String ignoreFileSuffixes) {
        String[] fileNames;
        FileUtil.checkStringParams(new String[]{"srcDirPath", "destDirPath"}, new String[]{srcDirPath, destDirPath});
        File srcDir = new File(srcDirPath);
        FileUtil.checkDir(srcDir);
        File destDir = new File(destDirPath);
        FileUtil.mkDirs(destDir);
        for (String fileName : fileNames = srcDir.list((FilenameFilter)FileUtil.createFileFilter(ignoreFileSuffixes))) {
            try {
                FileUtils.copyFileToDirectory((File)new File(srcDir, fileName), (File)destDir);
            }
            catch (IOException e) {
                throw new RuntimeException("24000006", e);
            }
        }
    }

    public static void copyDir(String srcDirPath, String destDirPath) {
        FileUtil.checkStringParams(new String[]{"srcDirPath", "destDirPath"}, new String[]{srcDirPath, destDirPath});
        File srcDir = new File(srcDirPath);
        FileUtil.checkDir(srcDir);
        File destDir = new File(destDirPath);
        FileUtil.mkDirs(destDir);
        try {
            FileUtils.copyDirectory((File)srcDir, (File)destDir);
        }
        catch (IOException e) {
            throw new RuntimeException("24000006", e);
        }
    }

    public static void copyDirToDir(String srcDirPath, String destDirPath) {
        FileUtil.checkStringParams(new String[]{"srcDirPath", "destDirPath"}, new String[]{srcDirPath, destDirPath});
        File srcDir = new File(srcDirPath);
        FileUtil.checkDir(srcDir);
        File destDir = new File(destDirPath);
        FileUtil.mkDirs(destDir);
        try {
            FileUtils.copyDirectoryToDirectory((File)srcDir, (File)destDir);
        }
        catch (IOException e) {
            throw new RuntimeException("24000006", e);
        }
    }

    public static void copyLargeFileToDir(String srcFilePath, String destDirPath) {
        FileUtil.checkStringParams(new String[]{"srcFilePath", "destDirPath"}, new String[]{srcFilePath, destDirPath});
        File srcFile = new File(srcFilePath);
        File destDir = new File(destDirPath);
        FileUtil.mkDirs(destDir);
        FileUtil.copyLargeFile(srcFilePath, new File(destDir, srcFile.getName()).getAbsolutePath());
    }

    public static void copyLargeFile(String srcFilePath, String destFilePath) {
        FileUtil.checkStringParams(new String[]{"srcFilePath", "destFilePath"}, new String[]{srcFilePath, destFilePath});
        File srcFile = new File(srcFilePath);
        FileUtil.checkFile(srcFile);
        File destFile = new File(destFilePath);
        FileUtil.createFile(destFile);
        FileInputStream in = null;
        try {
            in = new FileInputStream(srcFile);
        }
        catch (FileNotFoundException e1) {
            throw new RuntimeException("24000003", e1);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(destFile);
        }
        catch (FileNotFoundException e1) {
            throw new RuntimeException("24000003", e1);
        }
        try {
            try {
                IOUtils.copyLarge((InputStream)in, (OutputStream)out);
            }
            catch (IOException e) {
                throw new RuntimeException("24000006", e);
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            FileUtil.closeCloseable(in);
            FileUtil.closeCloseable(out);
            throw throwable;
        }
        FileUtil.closeCloseable(in);
        FileUtil.closeCloseable(out);
    }

    public static void delete(String path) {
        FileUtil.checkStringParams(new String[]{"path"}, new String[]{path});
        boolean pathIsFile = false;
        File file = new File(path);
        try {
            FileUtil.checkFile(file);
            pathIsFile = true;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (pathIsFile) {
            FileUtil.deleteFile(path);
        } else {
            FileUtil.deleteDir(path);
        }
    }

    public static void deleteDir(String dirPath) {
        FileUtil.checkStringParams(new String[]{"dirPath"}, new String[]{dirPath});
        File dir = new File(dirPath);
        if (!dir.exists()) {
            return;
        }
        FileUtil.checkDir(dir);
        try {
            FileUtils.deleteDirectory((File)dir);
        }
        catch (IOException e) {
            throw new RuntimeException("24000006", e);
        }
    }

    public static void deleteFile(String filePath) {
        FileUtil.checkStringParams(new String[]{"filePath"}, new String[]{filePath});
        File file = new File(filePath);
        if (!file.exists()) {
            return;
        }
        FileUtil.checkFile(file);
        file.delete();
    }

    public static void deleteFilesByFilter(String dirPath, String ignoreFileSuffixes) {
        String[] fileNames;
        FileUtil.checkStringParams(new String[]{"dirPath"}, new String[]{dirPath});
        File dir = new File(dirPath);
        FileUtil.checkDir(dir);
        for (String fileName : fileNames = dir.list((FilenameFilter)FileUtil.createFileFilter(ignoreFileSuffixes))) {
            new File(dir, fileName).delete();
        }
    }

    public static void moveDir(String srcDirPath, String destDirPath) {
        FileUtil.copyDir(srcDirPath, destDirPath);
        FileUtil.deleteDir(srcDirPath);
    }

    public static void moveDirToDir(String srcDirPath, String destDirPath) {
        FileUtil.copyDirToDir(srcDirPath, destDirPath);
        FileUtil.deleteDir(srcDirPath);
    }

    public static void moveFileToDir(String srcFilePath, String destDirPath) {
        FileUtil.copyFileToDir(srcFilePath, destDirPath);
        FileUtil.deleteFile(srcFilePath);
    }

    public static void moveFilesByFilter(String srcDirPath, String destDirPath, String ignoreFileSuffixes) {
        FileUtil.copyFilesByFilter(srcDirPath, destDirPath, ignoreFileSuffixes);
        FileUtil.deleteFilesByFilter(srcDirPath, ignoreFileSuffixes);
    }

    public static String readFile(String filePath, String encoding) {
        FileUtil.checkStringParams(new String[]{"filePath"}, new String[]{filePath});
        File file = new File(filePath);
        FileUtil.checkFile(file);
        if (StringUtils.isBlank((String)encoding)) {
            encoding = System.getProperty("file.encoding");
        }
        try {
            return FileUtils.readFileToString((File)file, (String)encoding);
        }
        catch (IOException e) {
            throw new RuntimeException("24000006", e);
        }
    }

    public static void writeFile(String filePath, String data, String encoding) {
        FileUtil.checkStringParams(new String[]{"filePath"}, new String[]{filePath});
        File file = new File(filePath);
        FileUtil.createFile(file);
        if (StringUtils.isBlank((String)encoding)) {
            encoding = System.getProperty("file.encoding");
        }
        if (data == null) {
            data = "";
        }
        try {
            FileUtils.writeStringToFile((File)file, (String)data, (String)encoding);
        }
        catch (IOException e) {
            throw new RuntimeException("24000006", e);
        }
    }

    private static boolean mkDirs(File dir) throws RuntimeException {
        if (!dir.exists()) {
            return dir.mkdirs();
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException("24000002");
        }
        return false;
    }

    private static void checkDir(File file) throws RuntimeException {
        if (!file.exists()) {
            throw new RuntimeException("24000003");
        }
        if (!file.isDirectory()) {
            throw new RuntimeException("24000002");
        }
    }

    private static boolean createFile(File file) throws RuntimeException {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                return file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("24000006", e);
            }
        }
        if (!file.isFile()) {
            throw new RuntimeException("24000005");
        }
        return false;
    }

    private static void checkFile(File file) throws RuntimeException {
        if (!file.exists()) {
            throw new RuntimeException("24000003");
        }
        if (!file.isFile()) {
            throw new RuntimeException("24000005");
        }
    }

    private static void checkStringParams(String[] paramNames, String[] paramValues) {
        for (int i = 0; i < paramValues.length; ++i) {
            if (!StringUtils.isBlank((String)paramValues[i])) continue;
            throw new RuntimeException("24000001");
        }
    }

    private static IOFileFilter createFileFilter(String ignoreFileSuffixes) {
        String[] ignoreFileSuffixArray;
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(DirectoryFileFilter.INSTANCE);
        if (!StringUtils.isBlank((String)ignoreFileSuffixes) && (ignoreFileSuffixArray = ignoreFileSuffixes.split(",")).length > 0) {
            filters.add(new SuffixFileFilter(ignoreFileSuffixArray));
        }
        return new NotFileFilter((IOFileFilter)new OrFileFilter(filters));
    }

    private static void closeCloseable(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

