/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.pkcs.bc;

import org.bouncycastle149.asn1.ASN1Encodable;
import org.bouncycastle149.asn1.DERNull;
import org.bouncycastle149.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle149.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle149.operator.MacCalculator;
import org.bouncycastle149.operator.OperatorCreationException;
import org.bouncycastle149.operator.bc.BcDigestProvider;
import org.bouncycastle149.pkcs.PKCS12MacCalculatorBuilder;
import org.bouncycastle149.pkcs.PKCS12MacCalculatorBuilderProvider;
import org.bouncycastle149.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12MacCalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    private BcDigestProvider digestProvider;

    public BcPKCS12MacCalculatorBuilderProvider(BcDigestProvider bcDigestProvider) {
        this.digestProvider = bcDigestProvider;
    }

    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            public MacCalculator build(char[] cArray) throws OperatorCreationException {
                PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                return PKCS12PBEUtils.createMacCalculator(algorithmIdentifier.getAlgorithm(), BcPKCS12MacCalculatorBuilderProvider.this.digestProvider.get(algorithmIdentifier), pKCS12PBEParams, cArray);
            }

            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), (ASN1Encodable)DERNull.INSTANCE);
            }
        };
    }
}

