/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.crypto.tls;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle149.crypto.InvalidCipherTextException;
import org.bouncycastle149.crypto.encodings.PKCS1Encoding;
import org.bouncycastle149.crypto.engines.RSABlindedEngine;
import org.bouncycastle149.crypto.params.ParametersWithRandom;
import org.bouncycastle149.crypto.params.RSAKeyParameters;
import org.bouncycastle149.crypto.tls.TlsContext;
import org.bouncycastle149.crypto.tls.TlsFatalAlert;
import org.bouncycastle149.crypto.tls.TlsUtils;

public class TlsRSAUtils {
    public static byte[] generateEncryptedPreMasterSecret(TlsContext tlsContext, RSAKeyParameters rSAKeyParameters, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[48];
        tlsContext.getSecureRandom().nextBytes(byArray);
        TlsUtils.writeVersion(tlsContext.getClientVersion(), byArray, 0);
        PKCS1Encoding pKCS1Encoding = new PKCS1Encoding(new RSABlindedEngine());
        pKCS1Encoding.init(true, new ParametersWithRandom(rSAKeyParameters, tlsContext.getSecureRandom()));
        try {
            byte[] byArray2 = pKCS1Encoding.processBlock(byArray, 0, byArray.length);
            if (tlsContext.getServerVersion().isSSL()) {
                outputStream.write(byArray2);
            } else {
                TlsUtils.writeOpaque16(byArray2, outputStream);
            }
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new TlsFatalAlert(80);
        }
        return byArray;
    }
}

