/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.fastparser.timestamp;

import java.util.ArrayList;
import java.util.Collection;
import xjyb.org.bjca.jce.fastparser.ContentInfo;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.fastparser.Item;
import xjyb.org.bjca.jce.fastparser.timestamp.TimeStampContentInfo;

public class TimeStampSignedData {
    private Item version = new Item();
    private int _ver = 0;
    private Item digestAlgorithms = new Item();
    private ArrayList daset = new ArrayList();
    private Item contentInfo = new Item();
    private TimeStampContentInfo oci = null;
    private ArrayList vcerts = new ArrayList();
    private ArrayList vcrls = new ArrayList();
    private ArrayList vSignerInfos = new ArrayList();
    private static final int OPTIONS_NUM = 2;

    public TimeStampSignedData(byte[] input, Item it) {
        long start = System.currentTimeMillis();
        this.parse(input, it.offset, it.length);
        long end = System.currentTimeMillis();
    }

    public TimeStampSignedData(byte[] input, int offset, int length) {
        this.parse(input, offset, length);
    }

    public void parse(byte[] input, int offset, int length) {
        int position = 0;
        Item tmpitem = new Item();
        if (DerUtil.debug) {
            System.out.println("SignedData Parsing...\n");
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset;
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.version = new Item(tmpitem);
        this._ver = DerUtil.toInt(input, this.version.offset, this.version.length);
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.digestAlgorithms = new Item(tmpitem);
        DerUtil.computeOffset(input, tmpitem, this.digestAlgorithms.offset, 0);
        tmpitem.offset += this.digestAlgorithms.offset;
        this.digestAlgorithms = new Item(tmpitem);
        this.daset.add(this.digestAlgorithms);
        if (DerUtil.debug) {
            System.out.println("Parsing digestAlgorithms....");
            DerUtil.printItem(input, this.digestAlgorithms);
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.contentInfo = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("Parsing contentInfo....");
            DerUtil.printItem(input, tmpitem);
        }
        this.oci = new TimeStampContentInfo(input, this.contentInfo);
        block4: for (int i = 0; position < length && i < 2; ++i) {
            if ((input[offset + position] & 0xF0) != 160) continue;
            int option = input[offset + position] & 0xF;
            DerUtil.computeOffset(input, tmpitem, offset, position);
            position = tmpitem.offset + tmpitem.length;
            tmpitem.offset += offset;
            switch (option) {
                case 0: 
                case 2: {
                    if (DerUtil.debug) {
                        System.out.println("Parsing Certificates....");
                        DerUtil.printItem(input, tmpitem);
                    }
                    DerUtil.parseSequence(input, tmpitem, this.vcerts);
                    continue block4;
                }
                case 1: 
                case 3: {
                    if (DerUtil.debug) {
                        System.out.println("Parsing CRLs....");
                        DerUtil.printItem(input, tmpitem);
                    }
                    DerUtil.parseSequence(input, tmpitem.offset, tmpitem.length, this.vcrls);
                }
            }
        }
        if (position < length && (input[offset + position] & 0xA0) != 160) {
            DerUtil.computeOffset(input, tmpitem, offset, position);
            tmpitem.offset += offset;
            DerUtil.parseSequence(input, tmpitem, this.vSignerInfos);
        }
    }

    public final Collection getDigestAlgorithms() {
        return this.daset;
    }

    public final TimeStampContentInfo getContentInfo() {
        return this.oci;
    }

    public Collection getCertificates() {
        return this.vcerts;
    }

    public Collection getCrls() {
        return this.vcrls;
    }

    public Collection getSignerInfos() {
        return this.vSignerInfos;
    }

    public byte[] getSignedContentTypeOID(byte[] _input, Item contentInfo) {
        ContentInfo ci = new ContentInfo(_input, contentInfo.offset, contentInfo.length);
        switch (ci.getContentType()) {
            case 1: {
                return DerUtil.OID_Data;
            }
            case 2: {
                return DerUtil.OID_SignedData;
            }
            case 3: {
                return DerUtil.OID_EnvelopedData;
            }
            case 4: {
                return DerUtil.OID_SignedAndEnvelopedData;
            }
            case 5: {
                return DerUtil.OID_DigestedData;
            }
            case 6: {
                return DerUtil.OID_EncryptedData;
            }
        }
        return null;
    }

    public Item getSignedContent() {
        return this.contentInfo;
    }

    public int getVersion() {
        return this._ver;
    }
}

