/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1OctetString;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.ASN1Set;
import xjyb.org.bjca.asn1.DERConstructedSequence;
import xjyb.org.bjca.asn1.DERConstructedSet;
import xjyb.org.bjca.asn1.DEREncodable;
import xjyb.org.bjca.asn1.DERInputStream;
import xjyb.org.bjca.asn1.DERInteger;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.DEROutputStream;
import xjyb.org.bjca.asn1.DERTaggedObject;
import xjyb.org.bjca.asn1.pkcs.ContentInfo;
import xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber;
import xjyb.org.bjca.asn1.pkcs.PKCSObjectIdentifiers;
import xjyb.org.bjca.asn1.pkcs.SignedData;
import xjyb.org.bjca.asn1.pkcs.SignerInfo;
import xjyb.org.bjca.asn1.x509.AlgorithmIdentifier;
import xjyb.org.bjca.asn1.x509.CertificateList;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;
import xjyb.org.bjca.asn1.x509.X509Name;
import xjyb.org.bjca.jce.X509Principal;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.fastparser.FX509Certificate;
import xjyb.org.bjca.jce.fastparser.FastPkcs7;
import xjyb.org.bjca.jce.fastparser.Item;
import xjyb.org.bjca.jce.interfaces.P11Interface;
import xjyb.org.bjca.jce.provider.X509CRLObject;
import xjyb.org.bjca.jce.provider.X509CRLObjectFP;
import xjyb.org.bjca.jce.provider.X509CertificateObject;
import xjyb.org.bjca.jce.provider.X509CertificateObjectFP;
import xjyb.org.bjca.util.GetP7InfoUtil;

public class PKCS7SignedData
implements PKCSObjectIdentifiers {
    int version;
    int signerversion;
    Set digestalgos;
    Collection certs;
    Collection crls;
    X509Certificate signCert;
    byte[] digest;
    String digestAlgorithm;
    String digestEncryptionAlgorithm;
    Signature sig;
    transient PrivateKey privKey;
    byte[] contentData;
    byte[] signCertTBS;
    DERObject[] certsEncoded;
    Hashtable isAndsns;
    final String ID_PKCS7_DATA = "1.2.840.113549.1.7.1";
    final String ID_PKCS7_SIGNED_DATA = "1.2.840.113549.1.7.2";
    static final String ID_MD5 = "1.2.840.113549.2.5";
    static final String ID_MD2 = "1.2.840.113549.2.2";
    public static final String ID_SHA1 = "1.3.14.3.2.26";
    static final String ID_RSA = "1.2.840.113549.1.1.1";
    static final String ID_DSA = "1.2.840.10040.4.1";
    static final String ID_SHA224 = "2.16.840.1.101.3.4.2.4";
    public static final String ID_SHA256 = "2.16.840.1.101.3.4.2.1";
    static final String ID_SHA384 = "2.16.840.1.101.3.4.2.2";
    static final String ID_SHA512 = "2.16.840.1.101.3.4.2.3";
    static final String ID_RC4 = "1.2.840.113549.3.4";
    static final String ID_DES = "1.3.14.3.2.7";
    static final String ID_DESEDE = "1.2.840.113549.3.7";
    static final String ID_RC2 = "1.2.840.113549.3.2";
    static final String ID_AES = "2.16.840.1.101.3.4.2";
    static final int MD5 = 1;
    static final int MD2 = 2;
    static final int SHA1 = 3;
    static final int RSA = 4;
    static final int DSA = 5;
    static final int SHA224 = 6;
    static final int SHA256 = 7;
    static final int SHA384 = 8;
    static final int SHA512 = 9;
    static final int RC4 = 10;
    static final int DES = 11;
    static final int DESEDE = 12;
    static final int RC2 = 13;
    static final int AES = 14;
    static String[] algArray = new String[]{"MD5", "MD2", "SHA1", "RSA", "DSA", "SHA224", "SHA256", "SHA384", "SHA512", "RC4", "DES", "DESEDE", "RC2", "AES"};
    static String[] algArray2 = new String[]{"MD5", "MD2", "SHA1", "RSA", "DSA", "SHA224", "SHA256", "SHA384", "SHA512", "RC4", "DES", "3DES", "RC2", "AES"};
    static HashMap algmap = null;
    byte[] bsPKCS7 = null;
    FastPkcs7 fxPKCS7 = null;
    String provider = "";

    public PKCS7SignedData() {
    }

    public PKCS7SignedData(byte[] in) throws SecurityException, CRLException, InvalidKeyException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException {
        this(in, "BC");
    }

    public PKCS7SignedData(byte[] in, String provider) throws SecurityException, CRLException, InvalidKeyException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException {
        this.fxPKCS7 = new FastPkcs7();
        this.fxPKCS7.pkcs7Data(in);
        this.provider = provider;
        this.bsPKCS7 = in;
        ArrayList alCerts = this.fxPKCS7.getCerts();
        this.certs = new ArrayList();
        this.certsEncoded = new DERObject[alCerts.size()];
        for (int i = 0; i < alCerts.size(); ++i) {
            Item itCert = (Item)alCerts.get(i);
            byte[] bsCert = new byte[itCert.length + itCert.tagsize];
            System.arraycopy(this.bsPKCS7, itCert.offset - itCert.tagsize, bsCert, 0, bsCert.length);
            this.certs.add(new X509CertificateObjectFP(bsCert));
            ASN1InputStream ains = new ASN1InputStream(new ByteArrayInputStream(bsCert));
            try {
                ASN1Sequence derCert = (ASN1Sequence)ains.readObject();
                this.certsEncoded[i] = derCert;
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        ArrayList alCrls = this.fxPKCS7.getCrls();
        this.crls = new ArrayList();
        for (int i = 0; i < alCrls.size(); ++i) {
            Item itCrl = (Item)alCrls.get(i);
            byte[] bsCrl = new byte[itCrl.length + itCrl.tagsize];
            System.arraycopy(this.bsPKCS7, itCrl.offset - itCrl.tagsize, bsCrl, 0, bsCrl.length);
            try {
                this.crls.add(new X509CRLObjectFP(bsCrl));
                continue;
            }
            catch (CRLException e) {
                e.printStackTrace();
            }
        }
        Item signCertItem = this.fxPKCS7.getSignCert();
        byte[] bsData = null;
        bsData = DerUtil.getItemDataAndTag(this.bsPKCS7, signCertItem);
        if (bsData != null && bsData.length > 0) {
            this.signCert = new X509CertificateObjectFP(bsData);
            this.signCertTBS = this.signCert.getTBSCertificate();
        }
        Item item = this.fxPKCS7.getSignCert();
        byte[] bs = new byte[item.length];
        if (bs != null && bs.length > 0) {
            System.arraycopy(in, item.offset, bs, 0, item.length);
            FX509Certificate fx = new FX509Certificate();
            fx.parse(bs, 0, bs.length);
        }
        ArrayList daAl = this.fxPKCS7.getDigestAlgorithms();
        this.digestalgos = new HashSet();
        for (int i = 0; i < daAl.size(); ++i) {
            Item daItem = (Item)daAl.get(i);
            byte[] ds = DerUtil.getItemDataAndTag(this.bsPKCS7, daItem);
            ASN1InputStream a = new ASN1InputStream(ds);
            ASN1Sequence asn = null;
            try {
                DERObject obj = a.readObject();
                asn = (ASN1Sequence)obj;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            DERObjectIdentifier o = (DERObjectIdentifier)asn.getObjectAt(0);
            this.digestalgos.add(o.getId());
        }
        this.version = this.fxPKCS7.getVersion();
        this.signerversion = this.fxPKCS7.getSignInfoVersion();
        Item rawDataItem = this.fxPKCS7.getRawData();
        this.contentData = DerUtil.getItemData(this.bsPKCS7, rawDataItem);
        Item digestItem = this.fxPKCS7.getDigest();
        this.digest = DerUtil.getItemData(this.bsPKCS7, digestItem);
        this.digestAlgorithm = this.fxPKCS7.getDigestAlgorithm();
        this.digestEncryptionAlgorithm = this.fxPKCS7.getDigestEncryptionAlgorithm();
        this.sig = Signature.getInstance(this.getDigestAlgorithm(), provider);
        this.sig.initVerify(this.signCert.getPublicKey());
        if (this.contentData != null) {
            this.sig.update(this.contentData);
        }
    }

    public byte[][] getAttributeSignValueAndCert(byte[] p7sign) throws Exception {
        byte[][] rets = new byte[4][];
        byte[][] infos = GetP7InfoUtil.getAttributeSignValueAndCert(p7sign);
        if (infos.length >= 4) {
            for (int i = 0; i < rets.length; ++i) {
                rets[i] = infos[i];
            }
        }
        return rets;
    }

    public void PKCS7SignedData2(byte[] in, String provider) throws SecurityException, CRLException, InvalidKeyException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException {
        Enumeration ec;
        DERObject pkcs;
        DERInputStream din = new DERInputStream(new ByteArrayInputStream(in));
        try {
            pkcs = din.readObject();
        }
        catch (IOException e) {
            throw new SecurityException("can't decode PKCS7SignedData object");
        }
        if (!(pkcs instanceof DERConstructedSequence)) {
            throw new SecurityException("Not a valid PKCS#7 object - not a sequence");
        }
        ContentInfo content = ContentInfo.getInstance(pkcs);
        if (!content.getContentType().equals(signedData)) {
            throw new SecurityException("Not a valid PKCS#7 signed-data object - wrong header " + content.getContentType().getId());
        }
        SignedData data = SignedData.getInstance(content.getContent());
        this.certs = new ArrayList();
        if (data.getCertificates() != null) {
            ec = ASN1Set.getInstance(data.getCertificates()).getObjects();
            while (ec.hasMoreElements()) {
                this.certs.add(new X509CertificateObject(X509CertificateStructure.getInstance(ec.nextElement())));
            }
        }
        this.crls = new ArrayList();
        if (data.getCRLs() != null) {
            ec = ASN1Set.getInstance(data.getCRLs()).getObjects();
            while (ec.hasMoreElements()) {
                this.crls.add(new X509CRLObject(CertificateList.getInstance(ec.nextElement())));
            }
        }
        this.version = data.getVersion().getValue().intValue();
        ContentInfo dataContentInfo = data.getContentInfo();
        DEREncodable derEnc = dataContentInfo.getContent();
        if (derEnc != null) {
            ASN1OctetString asn1octet = (ASN1OctetString)derEnc;
            this.contentData = asn1octet.getOctets();
        } else {
            this.contentData = null;
        }
        this.digestalgos = new HashSet();
        Enumeration e = data.getDigestAlgorithms().getObjects();
        while (e.hasMoreElements()) {
            DERConstructedSequence s = (DERConstructedSequence)e.nextElement();
            DERObjectIdentifier o = (DERObjectIdentifier)s.getObjectAt(0);
            this.digestalgos.add(o.getId());
        }
        DERConstructedSet signerinfos = (DERConstructedSet)data.getSignerInfos();
        if (signerinfos.getSize() != 1) {
            throw new SecurityException("This PKCS#7 object has multiple SignerInfos - only one is supported at this time");
        }
        SignerInfo signerInfo = SignerInfo.getInstance(signerinfos.getObjectAt(0));
        this.signerversion = signerInfo.getVersion().getValue().intValue();
        IssuerAndSerialNumber isAnds = signerInfo.getIssuerAndSerialNumber();
        BigInteger serialNumber = isAnds.getCertificateSerialNumber().getValue();
        X509Principal issuer = new X509Principal(isAnds.getName());
        for (X509Certificate cert : this.certs) {
            if (!serialNumber.equals(cert.getSerialNumber()) || !issuer.equals(cert.getIssuerDN())) continue;
            this.signCert = cert;
            break;
        }
        if (this.signCert == null) {
            throw new SecurityException("Can't find signing certificate with serial " + serialNumber.toString(16));
        }
        this.digestAlgorithm = signerInfo.getDigestAlgorithm().getObjectId().getId();
        this.digest = signerInfo.getEncryptedDigest().getOctets();
        this.digestEncryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm().getObjectId().getId();
        this.sig = Signature.getInstance(this.getDigestAlgorithm(), provider);
        this.sig.initVerify(this.signCert.getPublicKey());
    }

    public PKCS7SignedData(PrivateKey privKey, Certificate[] certChain, String hashAlgorithm) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this(privKey, certChain, hashAlgorithm, "BC");
    }

    public PKCS7SignedData(PrivateKey privKey, Certificate[] certChain, String hashAlgorithm, String provider) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this(privKey, certChain, null, hashAlgorithm, provider);
    }

    public PKCS7SignedData(PrivateKey privKey, Certificate[] certChain, CRL[] crlList, String hashAlgorithm, String provider) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        int i;
        this.privKey = privKey;
        if (hashAlgorithm.equals("MD5")) {
            this.digestAlgorithm = ID_MD5;
        } else if (hashAlgorithm.equals("MD2")) {
            this.digestAlgorithm = ID_MD2;
        } else if (hashAlgorithm.equals("SHA")) {
            this.digestAlgorithm = ID_SHA1;
        } else if (hashAlgorithm.equals("SHA1")) {
            this.digestAlgorithm = ID_SHA1;
        } else if (hashAlgorithm.equals("SHA224")) {
            this.digestAlgorithm = ID_SHA224;
        } else if (hashAlgorithm.equals("SHA256")) {
            this.digestAlgorithm = ID_SHA256;
        } else if (hashAlgorithm.equals("ID_SHA384")) {
            this.digestAlgorithm = ID_SHA384;
        } else if (hashAlgorithm.equals("ID_SHA512")) {
            this.digestAlgorithm = ID_SHA512;
        } else {
            throw new NoSuchAlgorithmException("Unknown Hash Algorithm " + hashAlgorithm);
        }
        this.signerversion = 1;
        this.version = 1;
        this.certs = new ArrayList();
        this.crls = new ArrayList();
        this.digestalgos = new HashSet();
        this.digestalgos.add(this.digestAlgorithm);
        this.signCert = (X509Certificate)certChain[0];
        for (i = 0; i < certChain.length; ++i) {
            this.certs.add(certChain[i]);
        }
        if (crlList != null) {
            for (i = 0; i < crlList.length; ++i) {
                this.crls.add(crlList[i]);
            }
        }
        this.digestEncryptionAlgorithm = privKey.getAlgorithm();
        if (this.digestEncryptionAlgorithm.equals("RSA")) {
            this.digestEncryptionAlgorithm = ID_RSA;
        } else if (this.digestEncryptionAlgorithm.equals("DSA")) {
            this.digestEncryptionAlgorithm = ID_DSA;
        } else {
            throw new NoSuchAlgorithmException("Unknown Key Algorithm " + this.digestEncryptionAlgorithm);
        }
        this.sig = Signature.getInstance(this.getDigestAlgorithm(), provider);
        this.sig.initSign(privKey);
    }

    public PKCS7SignedData(Certificate[] certChain, CRL[] crlList, String hashAlgorithm, String provider) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        int i;
        if (hashAlgorithm.equals("MD5")) {
            this.digestAlgorithm = ID_MD5;
        } else if (hashAlgorithm.equals("MD2")) {
            this.digestAlgorithm = ID_MD2;
        } else if (hashAlgorithm.equals("SHA")) {
            this.digestAlgorithm = ID_SHA1;
        } else if (hashAlgorithm.equals("SHA1")) {
            this.digestAlgorithm = ID_SHA1;
        } else if (hashAlgorithm.equals("SHA224")) {
            this.digestAlgorithm = ID_SHA224;
        } else if (hashAlgorithm.equals("SHA256")) {
            this.digestAlgorithm = ID_SHA256;
        } else if (hashAlgorithm.equals("ID_SHA384")) {
            this.digestAlgorithm = ID_SHA384;
        } else if (hashAlgorithm.equals("SHA512")) {
            this.digestAlgorithm = ID_SHA512;
        } else {
            throw new NoSuchAlgorithmException("Unknown Hash Algorithm " + hashAlgorithm);
        }
        this.signerversion = 1;
        this.version = 1;
        this.certs = new ArrayList();
        this.crls = new ArrayList();
        this.digestalgos = new HashSet();
        this.digestalgos.add(this.digestAlgorithm);
        this.signCert = (X509Certificate)certChain[0];
        for (i = 0; i < certChain.length; ++i) {
            this.certs.add(certChain[i]);
        }
        if (crlList != null) {
            for (i = 0; i < crlList.length; ++i) {
                this.crls.add(crlList[i]);
            }
        }
        this.digestEncryptionAlgorithm = ID_RSA;
    }

    private static String getAlgName(String oid) {
        String name = null;
        if (algmap.containsKey(oid)) {
            name = algmap.get(oid).toString();
        }
        return name;
    }

    private static String getAlgName(int alg) {
        String name = null;
        name = algArray[alg - 1];
        return name;
    }

    private static int getAlgID(String alg) {
        int id = 0;
        int i = 0;
        int loop = algArray2.length;
        if (i < loop && alg.equalsIgnoreCase(algArray2[i])) {
            id = i + 1;
        }
        return id;
    }

    public String getDigestAlgorithm() {
        String da = this.digestAlgorithm;
        String dea = this.digestEncryptionAlgorithm;
        if (this.digestAlgorithm.equals(ID_MD5)) {
            da = "MD5";
        } else if (this.digestAlgorithm.equals(ID_MD2)) {
            da = "MD2";
        } else if (this.digestAlgorithm.equals(ID_SHA1)) {
            da = "SHA1";
        } else if (this.digestAlgorithm.equals(ID_SHA224)) {
            da = "SHA224";
        } else if (this.digestAlgorithm.equals(ID_SHA256)) {
            da = "SHA256";
        } else if (this.digestAlgorithm.equals(ID_SHA384)) {
            da = "SHA384";
        } else if (this.digestAlgorithm.equals(ID_SHA512)) {
            da = "SHA512";
        }
        if (this.digestEncryptionAlgorithm.equals(ID_RSA)) {
            dea = "RSA";
        } else if (this.digestEncryptionAlgorithm.equals(ID_DSA)) {
            dea = "DSA";
        }
        return da + "with" + dea;
    }

    public void reset() {
        try {
            if (this.privKey == null) {
                this.sig.initVerify(this.signCert.getPublicKey());
            } else {
                this.sig.initSign(this.privKey);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public Certificate[] getCertificates() {
        return this.certs.toArray(new X509Certificate[0]);
    }

    public Collection getCRLs() {
        return this.crls;
    }

    public X509Certificate getSigningCertificate() {
        return this.signCert;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public byte[] getContentData() {
        return this.contentData;
    }

    public byte[] getSignValue() {
        return this.digest;
    }

    public byte[] getSignCertTBS() {
        return this.signCertTBS;
    }

    public DERObject[] getCertEncoded() {
        return this.certsEncoded;
    }

    public void update(byte buf) throws SignatureException {
        this.sig.update(buf);
    }

    public void update(byte[] buf, int off, int len) throws SignatureException {
        this.sig.update(buf, off, len);
    }

    public boolean verify() throws SignatureException {
        return this.sig.verify(this.digest);
    }

    private DERObject getIssuer(byte[] enc) {
        try {
            DERInputStream in = new DERInputStream(new ByteArrayInputStream(enc));
            DERConstructedSequence seq = (DERConstructedSequence)in.readObject();
            return (DERObject)seq.getObjectAt(seq.getObjectAt(0) instanceof DERTaggedObject ? 3 : 2);
        }
        catch (IOException e) {
            throw new Error("IOException reading from ByteArray: " + e);
        }
    }

    public byte[] getEncoded() {
        return this.getEncoded(null);
    }

    public byte[] getEncoded(byte[] _contentData) {
        try {
            if (null == this.digest) {
                this.digest = this.sig.sign();
            }
            DERConstructedSet algos = new DERConstructedSet();
            Iterator i = this.digestalgos.iterator();
            while (i.hasNext()) {
                AlgorithmIdentifier a = new AlgorithmIdentifier(new DERObjectIdentifier((String)i.next()), null);
                algos.addObject(a);
            }
            DERConstructedSequence contentinfo = new DERConstructedSequence();
            contentinfo.addObject(new DERObjectIdentifier("1.2.840.113549.1.7.1"));
            if (_contentData != null) {
                DEROctetString octets = new DEROctetString(_contentData);
                DERTaggedObject tagged = new DERTaggedObject(0, octets);
                contentinfo.addObject(tagged);
            }
            DERConstructedSet dercertificates = new DERConstructedSet();
            Iterator i2 = this.certs.iterator();
            while (i2.hasNext()) {
                DERInputStream tempstream = new DERInputStream(new ByteArrayInputStream(((X509Certificate)i2.next()).getEncoded()));
                dercertificates.addObject(tempstream.readObject());
            }
            DERConstructedSequence signerinfo = new DERConstructedSequence();
            signerinfo.addObject(new DERInteger(this.signerversion));
            byte[] bsIssuer = this.signCert.getIssuerX500Principal().getEncoded();
            ASN1InputStream ans = new ASN1InputStream(bsIssuer);
            ASN1Sequence issuer = (ASN1Sequence)ans.readObject();
            IssuerAndSerialNumber isAnds = new IssuerAndSerialNumber(new X509Name(issuer), new DERInteger(this.signCert.getSerialNumber()));
            signerinfo.addObject(isAnds);
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestAlgorithm), null));
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestEncryptionAlgorithm), null));
            signerinfo.addObject(new DEROctetString(this.digest));
            DERConstructedSequence body = new DERConstructedSequence();
            body.addObject(new DERInteger(this.version));
            body.addObject(algos);
            body.addObject(contentinfo);
            body.addObject(new DERTaggedObject(false, 0, dercertificates));
            if (this.crls.size() > 0) {
                DERConstructedSet dercrls = new DERConstructedSet();
                Iterator i3 = this.crls.iterator();
                while (i3.hasNext()) {
                    DERInputStream t = new DERInputStream(new ByteArrayInputStream(((X509CRL)i3.next()).getEncoded()));
                    dercrls.addObject(t.readObject());
                }
                body.addObject(new DERTaggedObject(false, 1, dercrls));
            }
            DERConstructedSet signerinfos = new DERConstructedSet();
            signerinfos.addObject(signerinfo);
            body.addObject(signerinfos);
            DERConstructedSequence whole = new DERConstructedSequence();
            whole.addObject(new DERObjectIdentifier("1.2.840.113549.1.7.2"));
            whole.addObject(new DERTaggedObject(0, body));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dout = new DEROutputStream(bOut);
            dout.writeObject(whole);
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public byte[] getEncoded(P11Interface p11Impl, byte[] _contentData, String m_keyType, String m_container) throws Exception {
        if (null == this.digest) {
            this.digest = p11Impl.signByRsaSha1(_contentData, m_container, Integer.parseInt(m_keyType));
        }
        try {
            DERConstructedSet algos = new DERConstructedSet();
            Iterator i = this.digestalgos.iterator();
            while (i.hasNext()) {
                AlgorithmIdentifier a = new AlgorithmIdentifier(new DERObjectIdentifier((String)i.next()), null);
                algos.addObject(a);
            }
            DERConstructedSequence contentinfo = new DERConstructedSequence();
            contentinfo.addObject(new DERObjectIdentifier("1.2.840.113549.1.7.1"));
            if (_contentData != null) {
                DEROctetString octets = new DEROctetString(_contentData);
                DERTaggedObject tagged = new DERTaggedObject(0, octets);
                contentinfo.addObject(tagged);
            }
            DERConstructedSet dercertificates = new DERConstructedSet();
            Iterator i2 = this.certs.iterator();
            while (i2.hasNext()) {
                DERInputStream tempstream = new DERInputStream(new ByteArrayInputStream(((X509Certificate)i2.next()).getEncoded()));
                dercertificates.addObject(tempstream.readObject());
            }
            DERConstructedSequence signerinfo = new DERConstructedSequence();
            signerinfo.addObject(new DERInteger(this.signerversion));
            byte[] bsIssuer = this.signCert.getIssuerX500Principal().getEncoded();
            ASN1InputStream ans = new ASN1InputStream(bsIssuer);
            ASN1Sequence issuer = (ASN1Sequence)ans.readObject();
            IssuerAndSerialNumber isAnds = new IssuerAndSerialNumber(new X509Name(issuer), new DERInteger(this.signCert.getSerialNumber()));
            signerinfo.addObject(isAnds);
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestAlgorithm), null));
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestEncryptionAlgorithm), null));
            signerinfo.addObject(new DEROctetString(this.digest));
            DERConstructedSequence body = new DERConstructedSequence();
            body.addObject(new DERInteger(this.version));
            body.addObject(algos);
            body.addObject(contentinfo);
            body.addObject(new DERTaggedObject(false, 0, dercertificates));
            if (this.crls.size() > 0) {
                DERConstructedSet dercrls = new DERConstructedSet();
                Iterator i3 = this.crls.iterator();
                while (i3.hasNext()) {
                    DERInputStream t = new DERInputStream(new ByteArrayInputStream(((X509CRL)i3.next()).getEncoded()));
                    dercrls.addObject(t.readObject());
                }
                body.addObject(new DERTaggedObject(false, 1, dercrls));
            }
            DERConstructedSet signerinfos = new DERConstructedSet();
            signerinfos.addObject(signerinfo);
            body.addObject(signerinfos);
            DERConstructedSequence whole = new DERConstructedSequence();
            whole.addObject(new DERObjectIdentifier("1.2.840.113549.1.7.2"));
            whole.addObject(new DERTaggedObject(0, body));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dout = new DEROutputStream(bOut);
            dout.writeObject(whole);
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public byte[] getEncoded(byte[] signedData, byte[] contentData) throws Exception {
        this.digest = signedData;
        try {
            DERConstructedSet algos = new DERConstructedSet();
            Iterator i = this.digestalgos.iterator();
            while (i.hasNext()) {
                AlgorithmIdentifier a = new AlgorithmIdentifier(new DERObjectIdentifier((String)i.next()), null);
                algos.addObject(a);
            }
            DERConstructedSequence contentinfo = new DERConstructedSequence();
            contentinfo.addObject(new DERObjectIdentifier("1.2.840.113549.1.7.1"));
            if (contentData != null) {
                DEROctetString octets = new DEROctetString(contentData);
                DERTaggedObject tagged = new DERTaggedObject(0, octets);
                contentinfo.addObject(tagged);
            }
            DERConstructedSet dercertificates = new DERConstructedSet();
            Iterator i2 = this.certs.iterator();
            while (i2.hasNext()) {
                DERInputStream tempstream = new DERInputStream(new ByteArrayInputStream(((X509Certificate)i2.next()).getEncoded()));
                dercertificates.addObject(tempstream.readObject());
            }
            DERConstructedSequence signerinfo = new DERConstructedSequence();
            signerinfo.addObject(new DERInteger(this.signerversion));
            byte[] bsIssuer = this.signCert.getIssuerX500Principal().getEncoded();
            ASN1InputStream ans = new ASN1InputStream(bsIssuer);
            ASN1Sequence issuer = (ASN1Sequence)ans.readObject();
            IssuerAndSerialNumber isAnds = new IssuerAndSerialNumber(new X509Name(issuer), new DERInteger(this.signCert.getSerialNumber()));
            signerinfo.addObject(isAnds);
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestAlgorithm), null));
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestEncryptionAlgorithm), null));
            signerinfo.addObject(new DEROctetString(this.digest));
            DERConstructedSequence body = new DERConstructedSequence();
            body.addObject(new DERInteger(this.version));
            body.addObject(algos);
            body.addObject(contentinfo);
            body.addObject(new DERTaggedObject(false, 0, dercertificates));
            if (this.crls.size() > 0) {
                DERConstructedSet dercrls = new DERConstructedSet();
                Iterator i3 = this.crls.iterator();
                while (i3.hasNext()) {
                    DERInputStream t = new DERInputStream(new ByteArrayInputStream(((X509CRL)i3.next()).getEncoded()));
                    dercrls.addObject(t.readObject());
                }
                body.addObject(new DERTaggedObject(false, 1, dercrls));
            }
            DERConstructedSet signerinfos = new DERConstructedSet();
            signerinfos.addObject(signerinfo);
            body.addObject(signerinfos);
            DERConstructedSequence whole = new DERConstructedSequence();
            whole.addObject(new DERObjectIdentifier("1.2.840.113549.1.7.2"));
            whole.addObject(new DERTaggedObject(0, body));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dout = new DEROutputStream(bOut);
            dout.writeObject(whole);
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public byte[] getEncoded(byte[] signedData, byte[] contentData, DERTaggedObject authenticatedAttributes) throws Exception {
        this.digest = signedData;
        try {
            DERConstructedSet algos = new DERConstructedSet();
            Iterator i = this.digestalgos.iterator();
            while (i.hasNext()) {
                AlgorithmIdentifier a = new AlgorithmIdentifier(new DERObjectIdentifier((String)i.next()), null);
                algos.addObject(a);
            }
            DERConstructedSequence contentinfo = new DERConstructedSequence();
            contentinfo.addObject(new DERObjectIdentifier("1.2.840.113549.1.7.1"));
            if (contentData != null) {
                DEROctetString octets = new DEROctetString(contentData);
                DERTaggedObject tagged = new DERTaggedObject(0, octets);
                contentinfo.addObject(tagged);
            }
            DERConstructedSet dercertificates = new DERConstructedSet();
            Iterator i2 = this.certs.iterator();
            while (i2.hasNext()) {
                DERInputStream tempstream = new DERInputStream(new ByteArrayInputStream(((X509Certificate)i2.next()).getEncoded()));
                dercertificates.addObject(tempstream.readObject());
            }
            DERConstructedSequence signerinfo = new DERConstructedSequence();
            signerinfo.addObject(new DERInteger(this.signerversion));
            byte[] bsIssuer = this.signCert.getIssuerX500Principal().getEncoded();
            ASN1InputStream ans = new ASN1InputStream(bsIssuer);
            ASN1Sequence issuer = (ASN1Sequence)ans.readObject();
            IssuerAndSerialNumber isAnds = new IssuerAndSerialNumber(new X509Name(issuer), new DERInteger(this.signCert.getSerialNumber()));
            signerinfo.addObject(isAnds);
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestAlgorithm), null));
            signerinfo.addObject(authenticatedAttributes);
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestEncryptionAlgorithm), null));
            signerinfo.addObject(new DEROctetString(this.digest));
            DERConstructedSequence body = new DERConstructedSequence();
            body.addObject(new DERInteger(this.version));
            body.addObject(algos);
            body.addObject(contentinfo);
            body.addObject(new DERTaggedObject(false, 0, dercertificates));
            if (this.crls.size() > 0) {
                DERConstructedSet dercrls = new DERConstructedSet();
                Iterator i3 = this.crls.iterator();
                while (i3.hasNext()) {
                    DERInputStream t = new DERInputStream(new ByteArrayInputStream(((X509CRL)i3.next()).getEncoded()));
                    dercrls.addObject(t.readObject());
                }
                body.addObject(new DERTaggedObject(false, 1, dercrls));
            }
            DERConstructedSet signerinfos = new DERConstructedSet();
            signerinfos.addObject(signerinfo);
            body.addObject(signerinfos);
            DERConstructedSequence whole = new DERConstructedSequence();
            whole.addObject(new DERObjectIdentifier("1.2.840.113549.1.7.2"));
            whole.addObject(new DERTaggedObject(0, body));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dout = new DEROutputStream(bOut);
            dout.writeObject(whole);
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    static {
        algmap = new HashMap();
        algmap.put(ID_MD5, "MD5");
        algmap.put(ID_MD2, "MD2");
        algmap.put(ID_SHA1, "SHA1");
        algmap.put(ID_RSA, "RSA");
        algmap.put(ID_DSA, "DSA");
        algmap.put(ID_SHA224, "SHA224");
        algmap.put(ID_SHA256, "SHA256");
        algmap.put(ID_SHA384, "SHA384");
        algmap.put(ID_SHA512, "SHA512");
        algmap.put(ID_RC4, "RC4");
        algmap.put(ID_DES, "DES");
        algmap.put(ID_DESEDE, "DESEDE");
        algmap.put(ID_RC2, "RC2");
        algmap.put(ID_AES, "AES");
    }
}

