/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.digests.sm3;

import java.math.BigInteger;
import xjyb.org.bjca.crypto.digests.sm3.SM3Func;
import xjyb.org.bjca.crypto.digests.sm3.Util;
import xjyb.org.bjca.sm4soft.util.ByteUtil;

public class SM3Digest {
    private static final int BYTE_LENGTH = 32;
    private static final int BLOCK_LENGTH = 64;
    private static final int BUFFER_LENGTH = 64;
    private byte[] xBuf = new byte[64];
    private int xBufOff;
    private byte[] V = (byte[])SM3Func.iv.clone();
    private int cntBlock = 0;

    public SM3Digest() {
    }

    public SM3Digest(SM3Digest t) {
        System.arraycopy(t.xBuf, 0, this.xBuf, 0, t.xBuf.length);
        this.xBufOff = t.xBufOff;
        System.arraycopy(t.V, 0, this.V, 0, t.V.length);
        this.cntBlock = t.cntBlock;
    }

    public int doFinal(byte[] out, int outOff) {
        byte[] hash = this.doFinal();
        System.arraycopy(hash, 0, out, outOff, 32);
        this.reset();
        return 32;
    }

    public void reset() {
        this.xBufOff = 0;
        this.cntBlock = 0;
        this.V = (byte[])SM3Func.iv.clone();
    }

    public void update(byte[] in, int inOff, int len) {
        int leftLen = 64 - this.xBufOff;
        int inputLen = len;
        int dPos = inOff;
        if (leftLen < inputLen) {
            System.arraycopy(in, dPos, this.xBuf, this.xBufOff, leftLen);
            inputLen -= leftLen;
            dPos += leftLen;
            this.compute();
            while (inputLen > 64) {
                System.arraycopy(in, dPos, this.xBuf, 0, 64);
                inputLen -= 64;
                dPos += 64;
                this.compute();
            }
        }
        System.arraycopy(in, dPos, this.xBuf, this.xBufOff, inputLen);
        this.xBufOff += inputLen;
    }

    private void compute() {
        byte[] B = new byte[64];
        for (int i = 0; i < 64; i += 64) {
            System.arraycopy(this.xBuf, i, B, 0, 64);
            this.compute(B);
        }
        this.xBufOff = 0;
    }

    private void compute(byte[] block) {
        byte[] V1 = SM3Func.CF(this.V, block);
        System.arraycopy(V1, 0, this.V, 0, this.V.length);
        ++this.cntBlock;
    }

    private byte[] doFinal() {
        byte[] B = new byte[64];
        byte[] buffer = new byte[this.xBufOff];
        System.arraycopy(this.xBuf, 0, buffer, 0, buffer.length);
        byte[] tmp = SM3Func.padding(buffer, this.cntBlock);
        for (int i = 0; i < tmp.length; i += 64) {
            System.arraycopy(tmp, i, B, 0, B.length);
            this.compute(B);
        }
        return this.V;
    }

    static void print(String str, String str1) {
        System.out.print("unsigned char " + str + "[32] = {");
        for (int i = 0; i < str1.length(); i += 2) {
            System.out.print("0x" + str1.substring(i, i + 2) + ", ");
        }
        System.out.println("};");
    }

    public static void main(String[] args) {
        SM3Digest.print("a", ByteUtil.bytes2hex(Util.a));
        SM3Digest.print("b", ByteUtil.bytes2hex(Util.b));
        SM3Digest.print("Gx", ByteUtil.bytes2hex(Util.Gx));
        SM3Digest.print("Gy", ByteUtil.bytes2hex(Util.Gy));
    }

    private byte[] getSM2Za(byte[] x, byte[] y, byte[] id) {
        byte[] tmp = Util.int2bytes(id.length * 8);
        byte[] buffer = new byte[194 + id.length];
        buffer[0] = tmp[2];
        buffer[1] = tmp[3];
        byte[] a = Util.a;
        byte[] b = Util.b;
        byte[] gx = Util.Gx;
        byte[] gy = Util.Gy;
        int dPos = 2;
        System.arraycopy(id, 0, buffer, dPos, id.length);
        System.arraycopy(a, 0, buffer, dPos += id.length, 32);
        System.arraycopy(b, 0, buffer, dPos += 32, 32);
        System.arraycopy(gx, 0, buffer, dPos += 32, 32);
        System.arraycopy(gy, 0, buffer, dPos += 32, 32);
        System.arraycopy(x, 0, buffer, dPos += 32, 32);
        System.arraycopy(y, 0, buffer, dPos += 32, 32);
        dPos += 32;
        SM3Digest digest = new SM3Digest();
        digest.update(buffer, 0, buffer.length);
        byte[] out = new byte[32];
        digest.doFinal(out, 0);
        return out;
    }

    public byte[] getSM2Za(byte[] buffer) {
        SM3Digest digest = new SM3Digest();
        digest.update(buffer, 0, buffer.length);
        byte[] out = new byte[32];
        digest.doFinal(out, 0);
        return out;
    }

    public void addId(BigInteger affineX, BigInteger affineY, byte[] id) {
        byte[] x = Util.asUnsigned32ByteArray(affineX);
        byte[] y = Util.asUnsigned32ByteArray(affineY);
        this.initWithId(x, y, id);
    }

    public void initWithId(byte[] x, byte[] y, byte[] id) {
        if (x == null || x.length != 32 || y == null || y.length != 32 || id == null) {
            throw new RuntimeException("\u53c2\u6570\u6709\u8bef");
        }
        byte[] tmp = this.getSM2Za(x, y, id);
        this.reset();
        this.update(tmp, 0, tmp.length);
    }

    public String getAlgorithmName() {
        return "SM3";
    }

    public int getDigestSize() {
        return 32;
    }

    public void update(byte in) {
        byte[] buffer = new byte[]{in};
        this.update(buffer, 0, 1);
    }
}

