/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.digests.sm3;

import xjyb.org.bjca.crypto.digests.sm3.SM3Digest;
import xjyb.org.bjca.sm4soft.crypto.ParameterException;
import xjyb.org.bjca.sm4soft.util.ByteUtil;

public class SM3Crypto {
    private static final SM3Digest engine = new SM3Digest();

    public byte[] doSm3WithID(byte[] pubkey, byte[] id, byte[] data) throws ParameterException {
        if (pubkey == null) {
            throw new ParameterException("\u516c\u94a5\u53c2\u6570[null]");
        }
        if (pubkey.length != 64) {
            throw new ParameterException("\u516c\u94a5\u957f\u5ea6[ " + pubkey.length + " ]");
        }
        if (id == null) {
            throw new ParameterException("ID\u53c2\u6570[null]");
        }
        if (data == null) {
            throw new ParameterException("\u6570\u636e\u53c2\u6570[null]");
        }
        byte[] x = new byte[32];
        byte[] y = new byte[32];
        System.arraycopy(pubkey, 0, x, 0, 32);
        System.arraycopy(pubkey, 32, y, 0, 32);
        engine.initWithId(x, y, id);
        engine.update(data, 0, data.length);
        ByteUtil.printHex(data);
        byte[] hash = new byte[32];
        engine.doFinal(hash, 0);
        return hash;
    }

    public byte[] doSm3(byte[] data) throws ParameterException {
        if (data == null) {
            throw new ParameterException("\u6570\u636e\u53c2\u6570[null]");
        }
        engine.update(data, 0, data.length);
        byte[] hash = new byte[32];
        engine.doFinal(hash, 0);
        return hash;
    }
}

