/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pqc.crypto.xmss;

import cn.org.bjca.gaia.crypto.Digest;
import cn.org.bjca.gaia.pqc.crypto.xmss.DefaultXMSSMTOid;
import cn.org.bjca.gaia.pqc.crypto.xmss.WOTSPlus;
import cn.org.bjca.gaia.pqc.crypto.xmss.XMSSOid;
import cn.org.bjca.gaia.pqc.crypto.xmss.XMSSParameters;

public final class XMSSMTParameters {
    private final XMSSOid oid;
    private final XMSSParameters xmssParams;
    private final int height;
    private final int layers;

    public XMSSMTParameters(int height, int layers, Digest digest) {
        this.height = height;
        this.layers = layers;
        this.xmssParams = new XMSSParameters(XMSSMTParameters.xmssTreeHeight(height, layers), digest);
        this.oid = DefaultXMSSMTOid.lookup(this.getDigest().getAlgorithmName(), this.getDigestSize(), this.getWinternitzParameter(), this.getLen(), this.getHeight(), layers);
    }

    private static int xmssTreeHeight(int height, int layers) throws IllegalArgumentException {
        if (height < 2) {
            throw new IllegalArgumentException("totalHeight must be > 1");
        }
        if (height % layers != 0) {
            throw new IllegalArgumentException("layers must divide totalHeight without remainder");
        }
        if (height / layers == 1) {
            throw new IllegalArgumentException("height / layers must be greater than 1");
        }
        return height / layers;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLayers() {
        return this.layers;
    }

    protected XMSSParameters getXMSSParameters() {
        return this.xmssParams;
    }

    protected WOTSPlus getWOTSPlus() {
        return this.xmssParams.getWOTSPlus();
    }

    protected Digest getDigest() {
        return this.xmssParams.getDigest();
    }

    public int getDigestSize() {
        return this.xmssParams.getDigestSize();
    }

    public int getWinternitzParameter() {
        return this.xmssParams.getWinternitzParameter();
    }

    protected int getLen() {
        return this.xmssParams.getWOTSPlus().getParams().getLen();
    }

    protected XMSSOid getOid() {
        return this.oid;
    }
}

