/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.jcajce.provider.symmetric;

import cn.org.bjca.gaia.crypto.BlockCipher;
import cn.org.bjca.gaia.crypto.CipherKeyGenerator;
import cn.org.bjca.gaia.crypto.engines.RijndaelEngine;
import cn.org.bjca.gaia.jcajce.provider.config.ConfigurableProvider;
import cn.org.bjca.gaia.jcajce.provider.symmetric.util.BaseBlockCipher;
import cn.org.bjca.gaia.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.org.bjca.gaia.jcajce.provider.symmetric.util.BlockCipherProvider;
import cn.org.bjca.gaia.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import cn.org.bjca.gaia.jcajce.provider.util.AlgorithmProvider;

public final class Rijndael {
    private Rijndael() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Rijndael.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.RIJNDAEL", PREFIX + "$ECB");
            provider.addAlgorithm("KeyGenerator.RIJNDAEL", PREFIX + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameters.RIJNDAEL", PREFIX + "$AlgParams");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Rijndael IV";
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Rijndael", 192, new CipherKeyGenerator());
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                @Override
                public BlockCipher get() {
                    return new RijndaelEngine();
                }
            });
        }
    }
}

