/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.dvcs;

import cn.org.bjca.gaia.asn1.dvcs.Data;
import cn.org.bjca.gaia.cms.CMSException;
import cn.org.bjca.gaia.cms.CMSSignedData;
import cn.org.bjca.gaia.dvcs.DVCSConstructionException;
import cn.org.bjca.gaia.dvcs.DVCSRequestData;

public class VSDRequestData
extends DVCSRequestData {
    private CMSSignedData doc;

    VSDRequestData(Data data) throws DVCSConstructionException {
        super(data);
        this.initDocument();
    }

    private void initDocument() throws DVCSConstructionException {
        if (this.doc == null) {
            if (this.data.getMessage() == null) {
                throw new DVCSConstructionException("DVCSRequest.data.message should be specified for VSD service");
            }
            try {
                this.doc = new CMSSignedData(this.data.getMessage().getOctets());
            }
            catch (CMSException e) {
                throw new DVCSConstructionException("Can't read CMS SignedData from input", e);
            }
        }
    }

    public byte[] getMessage() {
        return this.data.getMessage().getOctets();
    }

    public CMSSignedData getParsedMessage() {
        return this.doc;
    }
}

