/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cms;

import cn.org.bjca.gaia.asn1.cms.KEKIdentifier;
import cn.org.bjca.gaia.asn1.cms.KEKRecipientInfo;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.cms.AuthAttributesProvider;
import cn.org.bjca.gaia.cms.CMSException;
import cn.org.bjca.gaia.cms.CMSSecureReadable;
import cn.org.bjca.gaia.cms.KEKRecipient;
import cn.org.bjca.gaia.cms.KEKRecipientId;
import cn.org.bjca.gaia.cms.Recipient;
import cn.org.bjca.gaia.cms.RecipientInformation;
import cn.org.bjca.gaia.cms.RecipientOperator;
import java.io.IOException;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        KEKIdentifier kekId = info.getKekid();
        this.rid = new KEKRecipientId(kekId.getKeyIdentifier().getOctets());
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

