/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cert.dane;

import cn.org.bjca.gaia.cert.X509CertificateHolder;
import cn.org.bjca.gaia.cert.dane.DANEEntry;
import cn.org.bjca.gaia.util.CollectionStore;
import cn.org.bjca.gaia.util.Selector;
import cn.org.bjca.gaia.util.Store;
import cn.org.bjca.gaia.util.StoreException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DANEEntryStore
implements Store {
    private final Map entries;

    DANEEntryStore(List entries) {
        HashMap<String, DANEEntry> entryMap = new HashMap<String, DANEEntry>();
        for (DANEEntry entry : entries) {
            entryMap.put(entry.getDomainName(), entry);
        }
        this.entries = Collections.unmodifiableMap(entryMap);
    }

    public Collection getMatches(Selector selector) throws StoreException {
        if (selector == null) {
            return this.entries.values();
        }
        ArrayList results = new ArrayList();
        for (Object next : this.entries.values()) {
            if (!selector.match(next)) continue;
            results.add(next);
        }
        return Collections.unmodifiableList(results);
    }

    public Store toCertificateStore() {
        Collection col = this.getMatches((Selector)null);
        ArrayList<X509CertificateHolder> certColl = new ArrayList<X509CertificateHolder>(col.size());
        for (DANEEntry entry : col) {
            certColl.add(entry.getCertificate());
        }
        return new CollectionStore(certColl);
    }
}

