/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cert.dane;

import cn.org.bjca.gaia.cert.X509CertificateHolder;
import cn.org.bjca.gaia.cert.dane.DANEEntry;
import cn.org.bjca.gaia.cert.dane.DANEEntryFetcherFactory;
import cn.org.bjca.gaia.cert.dane.DANEEntrySelector;
import cn.org.bjca.gaia.cert.dane.DANEEntrySelectorFactory;
import cn.org.bjca.gaia.cert.dane.DANEException;
import cn.org.bjca.gaia.operator.DigestCalculator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DANECertificateFetcher {
    private final DANEEntryFetcherFactory fetcherFactory;
    private final DANEEntrySelectorFactory selectorFactory;

    public DANECertificateFetcher(DANEEntryFetcherFactory fetcherFactory, DigestCalculator digestCalculator) {
        this.fetcherFactory = fetcherFactory;
        this.selectorFactory = new DANEEntrySelectorFactory(digestCalculator);
    }

    public List fetch(String emailAddress) throws DANEException {
        DANEEntrySelector daneSelector = this.selectorFactory.createSelector(emailAddress);
        List matches = this.fetcherFactory.build(daneSelector.getDomainName()).getEntries();
        ArrayList<X509CertificateHolder> certs = new ArrayList<X509CertificateHolder>(matches.size());
        for (DANEEntry next : matches) {
            if (!daneSelector.match(next)) continue;
            certs.add(next.getCertificate());
        }
        return Collections.unmodifiableList(certs);
    }
}

