/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.util;

import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.ASN1Set;
import cn.org.bjca.gaia.asn1.DERBitString;
import cn.org.bjca.gaia.asn1.DERNull;
import cn.org.bjca.gaia.asn1.DERSet;
import cn.org.bjca.gaia.asn1.DERUTF8String;
import cn.org.bjca.gaia.asn1.gm.GMObjectIdentifiers;
import cn.org.bjca.gaia.asn1.pkcs.Attribute;
import cn.org.bjca.gaia.asn1.pkcs.CertificationRequest;
import cn.org.bjca.gaia.asn1.pkcs.CertificationRequestInfo;
import cn.org.bjca.gaia.asn1.pkcs.PKCSObjectIdentifiers;
import cn.org.bjca.gaia.asn1.x500.X500Name;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.asn1.x509.SubjectPublicKeyInfo;
import cn.org.bjca.gaia.asn1.x9.X9ObjectIdentifiers;
import cn.org.bjca.gaia.assemb.base.GaiaProvider;
import cn.org.bjca.gaia.assemb.constant.AlgConstant;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.param.AlgPolicy;
import cn.org.bjca.gaia.assemb.param.BjcaKey;
import cn.org.bjca.gaia.assemb.param.SM3Param;
import cn.org.bjca.gaia.assemb.util.ASN1Util;
import cn.org.bjca.gaia.assemb.util.KeyPairUtil;
import cn.org.bjca.gaia.util.encoders.Base64;
import java.security.Signature;
import java.util.Map;

public class P10Util {
    private GaiaProvider provider = null;

    public P10Util(GaiaProvider provider) {
        this.provider = provider;
    }

    public String generatorP10(String alg, String dn, Map extension, BjcaKey bPublicKey, Signature signature) throws PkiException {
        if (!(alg.equals("RSA") || alg.equals("SHA1WithRSA") || alg.equals("SHA256WithRSA") || alg.equals("SM2"))) {
            throw new PkiException("11009001", "\u4ea7\u751fP10\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b alg =" + alg);
        }
        DERSet extentionSet = null;
        if (extension != null && extension.size() > 0) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            for (Map.Entry entry : extension.entrySet()) {
                String oid = (String)entry.getKey();
                String value = (String)entry.getValue();
                ASN1ObjectIdentifier derOid = new ASN1ObjectIdentifier(oid);
                DERUTF8String oidValue = new DERUTF8String(value);
                DERSet asn1Set = new DERSet(oidValue);
                Attribute att = new Attribute(derOid, asn1Set);
                v.add(att);
            }
            extentionSet = new DERSet(v);
        }
        try {
            AlgPolicy hashAlgPolicy;
            CertificationRequestInfo certReqInfo = null;
            if (alg.contains("RSA")) {
                String hashAlg = alg.toUpperCase().contains("SHA1") ? "SHA1" : "SHA256";
                hashAlgPolicy = new AlgPolicy(hashAlg);
                certReqInfo = this.semsRsaP10Generator(dn, extentionSet, bPublicKey);
            } else {
                hashAlgPolicy = new AlgPolicy("SM3", new SM3Param(bPublicKey.getKey()));
                certReqInfo = this.semsSm2P10Generator(dn, extentionSet, bPublicKey);
            }
            byte[] hash = this.provider.hash(hashAlgPolicy, certReqInfo.getEncoded("DER"));
            signature.update(hash);
            byte[] sign = signature.sign();
            AlgorithmIdentifier signId = AlgConstant.convertAlgorithmIdentifier(alg);
            CertificationRequest certReq = new CertificationRequest(certReqInfo, signId, new DERBitString(sign));
            return Base64.toBase64String(certReq.getEncoded("DER"));
        }
        catch (Exception e) {
            throw new PkiException("11009001", "\u4ea7\u751fP10\u5931\u8d25", e);
        }
    }

    public String generatorP10(String alg, String dn, Map extension, BjcaKey bPublicKey, BjcaKey bPrivateKey) throws PkiException {
        if (!(alg.equals("RSA") || alg.equals("SHA1WithRSA") || alg.equals("SHA256WithRSA") || alg.equals("SM2"))) {
            throw new PkiException("11009001", "\u4ea7\u751fP10\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b alg =" + alg);
        }
        String p10 = null;
        DERSet extentionSet = null;
        if (extension != null && extension.size() > 0) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            for (Map.Entry entry : extension.entrySet()) {
                String oid = (String)entry.getKey();
                String value = (String)entry.getValue();
                ASN1ObjectIdentifier derOid = new ASN1ObjectIdentifier(oid);
                DERUTF8String oidValue = new DERUTF8String(value);
                DERSet asn1Set = new DERSet(oidValue);
                Attribute att = new Attribute(derOid, asn1Set);
                v.add(att);
            }
            extentionSet = new DERSet(v);
        }
        if (alg.contains("RSA")) {
            p10 = this.rsaP10Generator(alg, dn, extentionSet, bPublicKey, bPrivateKey);
        } else if ("SM2".equals(alg)) {
            p10 = this.sm2P10Generator(dn, extentionSet, bPublicKey, bPrivateKey);
        }
        return p10;
    }

    private String rsaP10Generator(String alg, String dn, ASN1Set extension, BjcaKey pubKey, BjcaKey privateKey) throws PkiException {
        String base64P10 = null;
        String hashAlg = "SHA1";
        String signAlg = "SHA1WithRSA";
        if (alg.equals("SHA1WithRSA") || alg.equals("SHA256WithRSA")) {
            hashAlg = AlgConstant.convertSignAlgToHashAlg(alg);
            signAlg = alg;
        }
        try {
            CertificationRequestInfo certReqInfo = this.semsRsaP10Generator(dn, extension, pubKey);
            byte[] bReqInfo = certReqInfo.getEncoded("DER");
            AlgPolicy hashPolicy = new AlgPolicy(hashAlg);
            byte[] hash = this.provider.hash(hashPolicy, bReqInfo);
            AlgPolicy signPolicy = new AlgPolicy(signAlg);
            byte[] derSign = this.provider.signHashedData(signPolicy, hash, privateKey);
            AlgorithmIdentifier signId = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, DERNull.INSTANCE);
            CertificationRequest certReq = new CertificationRequest(certReqInfo, signId, new DERBitString(derSign));
            byte[] bP10 = certReq.getEncoded("DER");
            base64P10 = new String(Base64.encode(bP10));
        }
        catch (Exception e) {
            throw new PkiException("11009001", "\u4ea7\u751fP10\u5931\u8d25", e);
        }
        return base64P10;
    }

    private CertificationRequestInfo semsRsaP10Generator(String dn, ASN1Set extension, BjcaKey pubKey) throws PkiException {
        CertificationRequestInfo certReqInfo = null;
        try {
            ASN1Sequence seq = (ASN1Sequence)ASN1Primitive.fromByteArray(pubKey.getKey());
            X500Name subject = new X500Name(dn);
            certReqInfo = new CertificationRequestInfo(subject, SubjectPublicKeyInfo.getInstance(seq), extension);
        }
        catch (Exception e) {
            throw new PkiException("11009001", "\u4ea7\u751fP10\u5931\u8d25", e);
        }
        return certReqInfo;
    }

    private String sm2P10Generator(String dn, ASN1Set extension, BjcaKey pubKey, BjcaKey privateKey) throws PkiException {
        String base64P10 = null;
        try {
            CertificationRequestInfo certReqInfo = this.semsSm2P10Generator(dn, extension, pubKey);
            byte[] bReqInfo = certReqInfo.getEncoded("DER");
            SM3Param sm3Param = new SM3Param(pubKey.getKey());
            AlgPolicy hashPolicy = new AlgPolicy("SM3", sm3Param);
            byte[] hash = this.provider.hash(hashPolicy, bReqInfo);
            AlgPolicy signPolicy = new AlgPolicy("SM3WithSM2");
            byte[] derSign = this.provider.signHashedData(signPolicy, hash, privateKey);
            AlgorithmIdentifier signAlg = new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign_with_sm3);
            CertificationRequest certReq = new CertificationRequest(certReqInfo, signAlg, new DERBitString(derSign));
            byte[] bP10 = certReq.getEncoded("DER");
            base64P10 = new String(Base64.encode(bP10));
        }
        catch (Exception e) {
            throw new PkiException("11009001", "\u4ea7\u751fP10\u5931\u8d25", e);
        }
        return base64P10;
    }

    private CertificationRequestInfo semsSm2P10Generator(String dn, ASN1Set extension, BjcaKey pubKey) throws PkiException {
        CertificationRequestInfo certReqInfo = null;
        try {
            byte[] bPubKey = pubKey.getKey();
            AlgorithmIdentifier keyAlg = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, GMObjectIdentifiers.sm2p256v1);
            SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo(keyAlg, bPubKey);
            X500Name subject = new X500Name(dn);
            certReqInfo = new CertificationRequestInfo(subject, spki, extension);
        }
        catch (Exception e) {
            throw new PkiException("11009001", "\u4ea7\u751fP10\u5931\u8d25", e);
        }
        return certReqInfo;
    }

    public byte[] semsP10(String alg, String dn, Map extension, BjcaKey bPublicKey) throws PkiException {
        if (!(alg.equals("RSA") || alg.equals("SHA1WithRSA") || alg.equals("SHA256WithRSA") || alg.equals("SM2"))) {
            throw new PkiException("11009001", "\u4ea7\u751fP10\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b alg =" + alg);
        }
        byte[] p10 = null;
        CertificationRequestInfo certReqInfo = null;
        DERSet extentionSet = null;
        if (extension != null && extension.size() > 0) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            for (Map.Entry entry : extension.entrySet()) {
                String oid = (String)entry.getKey();
                String value = (String)entry.getValue();
                ASN1ObjectIdentifier derOid = new ASN1ObjectIdentifier(oid);
                DERUTF8String oidValue = new DERUTF8String(value);
                DERSet asn1Set = new DERSet(oidValue);
                Attribute att = new Attribute(derOid, asn1Set);
                v.add(att);
            }
            extentionSet = new DERSet(v);
        }
        try {
            if (alg.contains("RSA")) {
                certReqInfo = this.semsRsaP10Generator(dn, extentionSet, bPublicKey);
            } else if ("SM2".equals(alg)) {
                certReqInfo = this.semsSm2P10Generator(dn, extentionSet, bPublicKey);
            }
            if (certReqInfo == null) {
                throw new PkiException("11009001", "\u4ea7\u751fP10\u5931\u8d25 certReqInfo is null ");
            }
            p10 = certReqInfo.getEncoded("DER");
        }
        catch (Exception e) {
            throw new PkiException("11009001", "\u4ea7\u751fP10\u5931\u8d25", e);
        }
        return p10;
    }

    public static BjcaKey getP10PublicKey(String p10) throws PkiException {
        BjcaKey bPubKey = null;
        try {
            CertificationRequest certReq = CertificationRequest.getInstance(ASN1Util.checkAndGetASN1Object(Base64.decode(p10)));
            SubjectPublicKeyInfo spki = certReq.getCertificationRequestInfo().getSubjectPublicKeyInfo();
            bPubKey = KeyPairUtil.subjectPubKeyInfo2Key(spki);
        }
        catch (Exception e) {
            throw new PkiException("11009002", "\u4eceP10\u4e2d\u89e3\u6790\u516c\u94a5\u5931\u8d25", e);
        }
        return bPubKey;
    }

    public static String getP10DN(String p10) throws PkiException {
        String dn = null;
        try {
            CertificationRequest certReq = CertificationRequest.getInstance(ASN1Util.checkAndGetASN1Object(Base64.decode(p10)));
            dn = certReq.getCertificationRequestInfo().getSubject().toString();
        }
        catch (Exception e) {
            throw new PkiException("11009003", "\u4eceP10\u4e2d\u89e3\u6790\u8bc1\u4e66\u4e3b\u9898\u5931\u8d25", e);
        }
        return dn;
    }

    public static void checkDN(String dn) throws PkiException {
        try {
            new X500Name(dn);
        }
        catch (Exception e) {
            throw new PkiException("11009004", "\u4e0d\u662f\u5408\u6cd5\u7684\u8bc1\u4e66\u4e3b\u9898", e);
        }
    }
}

