/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.structure;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.ASN1OctetString;
import cn.org.bjca.gaia.asn1.ASN1Set;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.asn1.cms.ContentInfo;
import cn.org.bjca.gaia.asn1.cms.EncryptedContentInfo;
import cn.org.bjca.gaia.asn1.cms.EnvelopedData;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.assemb.constant.AlgConstant;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.util.ASN1Util;
import cn.org.bjca.gaia.util.encoders.Base64;
import java.math.BigInteger;

public class BjcaEnvelop {
    private EnvelopedData envData = null;

    public BjcaEnvelop(byte[] envelop) throws PkiException {
        try {
            ContentInfo info = ContentInfo.getInstance(ASN1Util.checkAndGetASN1Object(envelop));
            this.envData = EnvelopedData.getInstance(info.getContent());
        }
        catch (Exception e) {
            throw new PkiException("11013003", "\u6784\u9020\u6570\u5b57\u4fe1\u5c01\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public byte[] getEncryptedSymmKey() throws PkiException {
        try {
            ASN1Set recipientInfos = this.envData.getRecipientInfos();
            ASN1Encodable objectAt = recipientInfos.getObjectAt(0);
            if (objectAt instanceof DERSequence) {
                DERSequence objectAt1 = (DERSequence)objectAt;
                ASN1Encodable objectAt2 = objectAt1.getObjectAt(3);
                if (objectAt2 instanceof DEROctetString) {
                    DEROctetString encryptedKey = (DEROctetString)objectAt2;
                    return encryptedKey.getOctets();
                }
                throw new PkiException("11013004", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u5931\u8d25");
            }
            throw new PkiException("11013004", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u5931\u8d25");
        }
        catch (Exception e) {
            throw new PkiException("11013004", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
        }
    }

    public String getEncryptedKeyAlg() throws PkiException {
        try {
            ASN1Set recipientInfos = this.envData.getRecipientInfos();
            ASN1Encodable objectAt = recipientInfos.getObjectAt(0);
            if (objectAt instanceof DERSequence) {
                DERSequence objectAt1 = (DERSequence)objectAt;
                ASN1Encodable objectAt2 = objectAt1.getObjectAt(2);
                if (objectAt2 instanceof DERSequence) {
                    DERSequence encryptedKeyAlg = (DERSequence)objectAt2;
                    ASN1ObjectIdentifier objectAt3 = (ASN1ObjectIdentifier)encryptedKeyAlg.getObjectAt(0);
                    return AlgConstant.convertOidToAlgName(objectAt3);
                }
                throw new PkiException("11013004", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u5931\u8d25");
            }
            throw new PkiException("11013004", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u5931\u8d25");
        }
        catch (Exception e) {
            throw new PkiException("11013004", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
        }
    }

    public BigInteger getEncryptCertSn() throws PkiException {
        try {
            ASN1Set recipientInfos = this.envData.getRecipientInfos();
            ASN1Encodable objectAt = recipientInfos.getObjectAt(0);
            if (objectAt instanceof DERSequence) {
                DERSequence objectAt1 = (DERSequence)objectAt;
                ASN1Encodable objectAt2 = objectAt1.getObjectAt(1);
                if (objectAt2 instanceof DERSequence) {
                    DERSequence isAndSn = (DERSequence)objectAt2;
                    ASN1Encodable objectAt3 = isAndSn.getObjectAt(1);
                    return ((ASN1Integer)objectAt3).getValue();
                }
                throw new PkiException("11013004", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u5931\u8d25");
            }
            throw new PkiException("11013004", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u5931\u8d25");
        }
        catch (Exception e) {
            throw new PkiException("11013004", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
        }
    }

    public byte[] getEncryptedContent() throws PkiException {
        try {
            EncryptedContentInfo encryptedContentInfo = this.envData.getEncryptedContentInfo();
            ASN1OctetString encryptedContent = encryptedContentInfo.getEncryptedContent();
            return encryptedContent.getOctets();
        }
        catch (Exception e) {
            throw new PkiException("11013004", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
        }
    }

    public String getEncryptedContentAlg() throws PkiException {
        try {
            EncryptedContentInfo encryptedContentInfo = this.envData.getEncryptedContentInfo();
            AlgorithmIdentifier contentEncryptionAlgorithm = encryptedContentInfo.getContentEncryptionAlgorithm();
            return AlgConstant.convertOidToAlgName(contentEncryptionAlgorithm.getAlgorithm());
        }
        catch (Exception e) {
            throw new PkiException("11013004", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
        }
    }

    public byte[] getEncryptedContentIv() throws PkiException {
        try {
            EncryptedContentInfo encryptedContentInfo = this.envData.getEncryptedContentInfo();
            AlgorithmIdentifier contentEncryptionAlgorithm = encryptedContentInfo.getContentEncryptionAlgorithm();
            ASN1Encodable parameters = contentEncryptionAlgorithm.getParameters();
            if (parameters != null && parameters instanceof ASN1OctetString) {
                ASN1OctetString parameters1 = (ASN1OctetString)parameters;
                return parameters1.getOctets();
            }
            return null;
        }
        catch (Exception e) {
            throw new PkiException("11013004", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
        }
    }

    public static void main(String[] args) throws PkiException {
        String en = "MIIBPwYKKoEcz1UGAQQCA6CCAS8wggErAgEAMYHnMIHkAgEAMFIwRDELMAkGA1UEBhMCQ04xDTALBgNVBAoMBEJKQ0ExDTALBgNVBAsMBEJKQ0ExFzAVBgNVBAMMDkJlaWppbmcgU00yIENBAgoaEAAAAAAAyOHaMA0GCSqBHM9VAYItAwUABHwwegIhAL8CwY2P1V5WJXUW/ymKFOpv40SB1s5ML6bHaSmY12htAiEA3cYRrJaMFFe2jbAdZrPn5HiUNXjYnlgP1VFxHTJaogkEIJNJyWS5IvusMCbp/p/cArjOfCGb/UuKOwuREZdIxFdMBBDq/KHZsvAVyMKSvK74FZogMDwGCiqBHM9VBgEEAgEwHAYIKoEcz1UBaAIEEAnKUSDOwyaTB/PfvOgwVcmAEMUL+O+LcPxwhb9+7saGR30=";
        BjcaEnvelop bjcaEnvelop = new BjcaEnvelop(Base64.decode(en));
        System.out.println(bjcaEnvelop.getEncryptCertSn());
        System.out.println(bjcaEnvelop.getEncryptCertSn().toString(16));
        bjcaEnvelop.getEncryptedSymmKey();
    }
}

