/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.generator;

import cn.org.bjca.gaia.asn1.ASN1Boolean;
import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.assemb.util.ASN1Util;
import cn.org.bjca.gaia.tsp.TimeStampRequest;
import cn.org.bjca.gaia.tsp.TimeStampRequestGenerator;
import java.math.BigInteger;

public class TsReqGenerator {
    private int version = 1;

    public byte[] generate(ASN1ObjectIdentifier digestAlgorithm, byte[] hash, boolean isAttachCert) throws Exception {
        ASN1EncodableVector msImprintOidV = new ASN1EncodableVector();
        msImprintOidV.add(digestAlgorithm);
        DEROctetString digest = new DEROctetString(hash);
        msImprintOidV.add(digest);
        DERSequence msImprint = new DERSequence(msImprintOidV);
        ASN1Boolean isAttachCertASN1 = ASN1Boolean.getInstance(isAttachCert);
        ASN1EncodableVector reqV = new ASN1EncodableVector();
        reqV.add(new ASN1Integer(this.version));
        reqV.add(msImprint);
        reqV.add(isAttachCertASN1);
        DERSequence req = new DERSequence(reqV);
        return req.getEncoded();
    }

    public TimeStampRequest convertReqToStandardReq(byte[] req) throws Exception {
        ASN1Object signCertPkcs = ASN1Util.checkAndGetASN1Object(req);
        DERSequence reqSeq = new DERSequence(signCertPkcs);
        ASN1Sequence derSequence = (ASN1Sequence)reqSeq.getObjectAt(0);
        ASN1Sequence msSequence = (ASN1Sequence)derSequence.getObjectAt(1);
        ASN1ObjectIdentifier digestAlgorithm = (ASN1ObjectIdentifier)msSequence.getObjectAt(0);
        DEROctetString hashOctStr = (DEROctetString)msSequence.getObjectAt(1);
        byte[] hash = hashOctStr.getOctets();
        ASN1Boolean isAttachCert = (ASN1Boolean)derSequence.getObjectAt(2);
        TimeStampRequestGenerator localTimeStampRequestGenerator = new TimeStampRequestGenerator();
        localTimeStampRequestGenerator.setCertReq(isAttachCert.isTrue());
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        TimeStampRequest localTimeStampRequest = localTimeStampRequestGenerator.generate(digestAlgorithm, hash, nonce);
        return localTimeStampRequest;
    }
}

